// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Storage for deployed package used by the function app.
 */
@Fluent
public final class FunctionsDeploymentStorage implements JsonSerializable<FunctionsDeploymentStorage> {
    /*
     * Property to select Azure Storage type. Available options: blobContainer.
     */
    private FunctionsDeploymentStorageType type;

    /*
     * Property to set the URL for the selected Azure Storage type. Example: For blobContainer, the value could be
     * https://<storageAccountName>.blob.core.windows.net/<containerName>.
     */
    private String value;

    /*
     * Authentication method to access the storage account for deployment.
     */
    private FunctionsDeploymentStorageAuthentication authentication;

    /**
     * Creates an instance of FunctionsDeploymentStorage class.
     */
    public FunctionsDeploymentStorage() {
    }

    /**
     * Get the type property: Property to select Azure Storage type. Available options: blobContainer.
     * 
     * @return the type value.
     */
    public FunctionsDeploymentStorageType type() {
        return this.type;
    }

    /**
     * Set the type property: Property to select Azure Storage type. Available options: blobContainer.
     * 
     * @param type the type value to set.
     * @return the FunctionsDeploymentStorage object itself.
     */
    public FunctionsDeploymentStorage withType(FunctionsDeploymentStorageType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the value property: Property to set the URL for the selected Azure Storage type. Example: For blobContainer,
     * the value could be https://&lt;storageAccountName&gt;.blob.core.windows.net/&lt;containerName&gt;.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: Property to set the URL for the selected Azure Storage type. Example: For blobContainer,
     * the value could be https://&lt;storageAccountName&gt;.blob.core.windows.net/&lt;containerName&gt;.
     * 
     * @param value the value value to set.
     * @return the FunctionsDeploymentStorage object itself.
     */
    public FunctionsDeploymentStorage withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Get the authentication property: Authentication method to access the storage account for deployment.
     * 
     * @return the authentication value.
     */
    public FunctionsDeploymentStorageAuthentication authentication() {
        return this.authentication;
    }

    /**
     * Set the authentication property: Authentication method to access the storage account for deployment.
     * 
     * @param authentication the authentication value to set.
     * @return the FunctionsDeploymentStorage object itself.
     */
    public FunctionsDeploymentStorage withAuthentication(FunctionsDeploymentStorageAuthentication authentication) {
        this.authentication = authentication;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (authentication() != null) {
            authentication().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeJsonField("authentication", this.authentication);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FunctionsDeploymentStorage from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FunctionsDeploymentStorage if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FunctionsDeploymentStorage.
     */
    public static FunctionsDeploymentStorage fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FunctionsDeploymentStorage deserializedFunctionsDeploymentStorage = new FunctionsDeploymentStorage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedFunctionsDeploymentStorage.type
                        = FunctionsDeploymentStorageType.fromString(reader.getString());
                } else if ("value".equals(fieldName)) {
                    deserializedFunctionsDeploymentStorage.value = reader.getString();
                } else if ("authentication".equals(fieldName)) {
                    deserializedFunctionsDeploymentStorage.authentication
                        = FunctionsDeploymentStorageAuthentication.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFunctionsDeploymentStorage;
        });
    }
}
