// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

/**
 * The unit of time for how often the backup should be executed (e.g. for weekly backup, this should be set to Day and
 * FrequencyInterval should be set to 7).
 */
public enum FrequencyUnit {
    /**
     * Enum value Day.
     */
    DAY("Day"),

    /**
     * Enum value Hour.
     */
    HOUR("Hour");

    /**
     * The actual serialized value for a FrequencyUnit instance.
     */
    private final String value;

    FrequencyUnit(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a FrequencyUnit instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed FrequencyUnit object, or null if unable to parse.
     */
    public static FrequencyUnit fromString(String value) {
        if (value == null) {
            return null;
        }
        FrequencyUnit[] items = FrequencyUnit.values();
        for (FrequencyUnit item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
