// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The access control configuration policy.
 */
@Fluent
public final class FlowAccessControlConfigurationPolicy
    implements JsonSerializable<FlowAccessControlConfigurationPolicy> {
    /*
     * The allowed caller IP address ranges.
     */
    private List<IpAddressRange> allowedCallerIpAddresses;

    /*
     * The authentication policies for workflow.
     */
    private OpenAuthenticationAccessPolicies openAuthenticationPolicies;

    /**
     * Creates an instance of FlowAccessControlConfigurationPolicy class.
     */
    public FlowAccessControlConfigurationPolicy() {
    }

    /**
     * Get the allowedCallerIpAddresses property: The allowed caller IP address ranges.
     * 
     * @return the allowedCallerIpAddresses value.
     */
    public List<IpAddressRange> allowedCallerIpAddresses() {
        return this.allowedCallerIpAddresses;
    }

    /**
     * Set the allowedCallerIpAddresses property: The allowed caller IP address ranges.
     * 
     * @param allowedCallerIpAddresses the allowedCallerIpAddresses value to set.
     * @return the FlowAccessControlConfigurationPolicy object itself.
     */
    public FlowAccessControlConfigurationPolicy
        withAllowedCallerIpAddresses(List<IpAddressRange> allowedCallerIpAddresses) {
        this.allowedCallerIpAddresses = allowedCallerIpAddresses;
        return this;
    }

    /**
     * Get the openAuthenticationPolicies property: The authentication policies for workflow.
     * 
     * @return the openAuthenticationPolicies value.
     */
    public OpenAuthenticationAccessPolicies openAuthenticationPolicies() {
        return this.openAuthenticationPolicies;
    }

    /**
     * Set the openAuthenticationPolicies property: The authentication policies for workflow.
     * 
     * @param openAuthenticationPolicies the openAuthenticationPolicies value to set.
     * @return the FlowAccessControlConfigurationPolicy object itself.
     */
    public FlowAccessControlConfigurationPolicy
        withOpenAuthenticationPolicies(OpenAuthenticationAccessPolicies openAuthenticationPolicies) {
        this.openAuthenticationPolicies = openAuthenticationPolicies;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (allowedCallerIpAddresses() != null) {
            allowedCallerIpAddresses().forEach(e -> e.validate());
        }
        if (openAuthenticationPolicies() != null) {
            openAuthenticationPolicies().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("allowedCallerIpAddresses", this.allowedCallerIpAddresses,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("openAuthenticationPolicies", this.openAuthenticationPolicies);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FlowAccessControlConfigurationPolicy from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FlowAccessControlConfigurationPolicy if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FlowAccessControlConfigurationPolicy.
     */
    public static FlowAccessControlConfigurationPolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FlowAccessControlConfigurationPolicy deserializedFlowAccessControlConfigurationPolicy
                = new FlowAccessControlConfigurationPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("allowedCallerIpAddresses".equals(fieldName)) {
                    List<IpAddressRange> allowedCallerIpAddresses
                        = reader.readArray(reader1 -> IpAddressRange.fromJson(reader1));
                    deserializedFlowAccessControlConfigurationPolicy.allowedCallerIpAddresses
                        = allowedCallerIpAddresses;
                } else if ("openAuthenticationPolicies".equals(fieldName)) {
                    deserializedFlowAccessControlConfigurationPolicy.openAuthenticationPolicies
                        = OpenAuthenticationAccessPolicies.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFlowAccessControlConfigurationPolicy;
        });
    }
}
