// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Http logs to file system configuration.
 */
@Fluent
public final class FileSystemHttpLogsConfig implements JsonSerializable<FileSystemHttpLogsConfig> {
    /*
     * Maximum size in megabytes that http log files can use.
     * When reached old log files will be removed to make space for new ones.
     * Value can range between 25 and 100.
     */
    private Integer retentionInMb;

    /*
     * Retention in days.
     * Remove files older than X days.
     * 0 or lower means no retention.
     */
    private Integer retentionInDays;

    /*
     * True if configuration is enabled, false if it is disabled and null if configuration is not set.
     */
    private Boolean enabled;

    /**
     * Creates an instance of FileSystemHttpLogsConfig class.
     */
    public FileSystemHttpLogsConfig() {
    }

    /**
     * Get the retentionInMb property: Maximum size in megabytes that http log files can use.
     * When reached old log files will be removed to make space for new ones.
     * Value can range between 25 and 100.
     * 
     * @return the retentionInMb value.
     */
    public Integer retentionInMb() {
        return this.retentionInMb;
    }

    /**
     * Set the retentionInMb property: Maximum size in megabytes that http log files can use.
     * When reached old log files will be removed to make space for new ones.
     * Value can range between 25 and 100.
     * 
     * @param retentionInMb the retentionInMb value to set.
     * @return the FileSystemHttpLogsConfig object itself.
     */
    public FileSystemHttpLogsConfig withRetentionInMb(Integer retentionInMb) {
        this.retentionInMb = retentionInMb;
        return this;
    }

    /**
     * Get the retentionInDays property: Retention in days.
     * Remove files older than X days.
     * 0 or lower means no retention.
     * 
     * @return the retentionInDays value.
     */
    public Integer retentionInDays() {
        return this.retentionInDays;
    }

    /**
     * Set the retentionInDays property: Retention in days.
     * Remove files older than X days.
     * 0 or lower means no retention.
     * 
     * @param retentionInDays the retentionInDays value to set.
     * @return the FileSystemHttpLogsConfig object itself.
     */
    public FileSystemHttpLogsConfig withRetentionInDays(Integer retentionInDays) {
        this.retentionInDays = retentionInDays;
        return this;
    }

    /**
     * Get the enabled property: True if configuration is enabled, false if it is disabled and null if configuration is
     * not set.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: True if configuration is enabled, false if it is disabled and null if configuration is
     * not set.
     * 
     * @param enabled the enabled value to set.
     * @return the FileSystemHttpLogsConfig object itself.
     */
    public FileSystemHttpLogsConfig withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("retentionInMb", this.retentionInMb);
        jsonWriter.writeNumberField("retentionInDays", this.retentionInDays);
        jsonWriter.writeBooleanField("enabled", this.enabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FileSystemHttpLogsConfig from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FileSystemHttpLogsConfig if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FileSystemHttpLogsConfig.
     */
    public static FileSystemHttpLogsConfig fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FileSystemHttpLogsConfig deserializedFileSystemHttpLogsConfig = new FileSystemHttpLogsConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("retentionInMb".equals(fieldName)) {
                    deserializedFileSystemHttpLogsConfig.retentionInMb = reader.getNullable(JsonReader::getInt);
                } else if ("retentionInDays".equals(fieldName)) {
                    deserializedFileSystemHttpLogsConfig.retentionInDays = reader.getNullable(JsonReader::getInt);
                } else if ("enabled".equals(fieldName)) {
                    deserializedFileSystemHttpLogsConfig.enabled = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFileSystemHttpLogsConfig;
        });
    }
}
