// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The configuration settings of the Azure Active Directory default authorization policy.
 */
@Fluent
public final class DefaultAuthorizationPolicy implements JsonSerializable<DefaultAuthorizationPolicy> {
    /*
     * The configuration settings of the Azure Active Directory allowed principals.
     */
    private AllowedPrincipals allowedPrincipals;

    /*
     * The configuration settings of the Azure Active Directory allowed applications.
     */
    private List<String> allowedApplications;

    /**
     * Creates an instance of DefaultAuthorizationPolicy class.
     */
    public DefaultAuthorizationPolicy() {
    }

    /**
     * Get the allowedPrincipals property: The configuration settings of the Azure Active Directory allowed principals.
     * 
     * @return the allowedPrincipals value.
     */
    public AllowedPrincipals allowedPrincipals() {
        return this.allowedPrincipals;
    }

    /**
     * Set the allowedPrincipals property: The configuration settings of the Azure Active Directory allowed principals.
     * 
     * @param allowedPrincipals the allowedPrincipals value to set.
     * @return the DefaultAuthorizationPolicy object itself.
     */
    public DefaultAuthorizationPolicy withAllowedPrincipals(AllowedPrincipals allowedPrincipals) {
        this.allowedPrincipals = allowedPrincipals;
        return this;
    }

    /**
     * Get the allowedApplications property: The configuration settings of the Azure Active Directory allowed
     * applications.
     * 
     * @return the allowedApplications value.
     */
    public List<String> allowedApplications() {
        return this.allowedApplications;
    }

    /**
     * Set the allowedApplications property: The configuration settings of the Azure Active Directory allowed
     * applications.
     * 
     * @param allowedApplications the allowedApplications value to set.
     * @return the DefaultAuthorizationPolicy object itself.
     */
    public DefaultAuthorizationPolicy withAllowedApplications(List<String> allowedApplications) {
        this.allowedApplications = allowedApplications;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (allowedPrincipals() != null) {
            allowedPrincipals().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("allowedPrincipals", this.allowedPrincipals);
        jsonWriter.writeArrayField("allowedApplications", this.allowedApplications,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DefaultAuthorizationPolicy from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DefaultAuthorizationPolicy if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DefaultAuthorizationPolicy.
     */
    public static DefaultAuthorizationPolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DefaultAuthorizationPolicy deserializedDefaultAuthorizationPolicy = new DefaultAuthorizationPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("allowedPrincipals".equals(fieldName)) {
                    deserializedDefaultAuthorizationPolicy.allowedPrincipals = AllowedPrincipals.fromJson(reader);
                } else if ("allowedApplications".equals(fieldName)) {
                    List<String> allowedApplications = reader.readArray(reader1 -> reader1.getString());
                    deserializedDefaultAuthorizationPolicy.allowedApplications = allowedApplications;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDefaultAuthorizationPolicy;
        });
    }
}
