// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Deployment status collection ARM resource.
 */
@Fluent
public final class CsmDeploymentStatusCollection implements JsonSerializable<CsmDeploymentStatusCollection> {
    /*
     * Collection of resources.
     */
    private List<CsmDeploymentStatus> value;

    /*
     * Link to next page of resources.
     */
    private String nextLink;

    /**
     * Creates an instance of CsmDeploymentStatusCollection class.
     */
    public CsmDeploymentStatusCollection() {
    }

    /**
     * Get the value property: Collection of resources.
     * 
     * @return the value value.
     */
    public List<CsmDeploymentStatus> value() {
        return this.value;
    }

    /**
     * Set the value property: Collection of resources.
     * 
     * @param value the value value to set.
     * @return the CsmDeploymentStatusCollection object itself.
     */
    public CsmDeploymentStatusCollection withValue(List<CsmDeploymentStatus> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Link to next page of resources.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property value in model CsmDeploymentStatusCollection"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CsmDeploymentStatusCollection.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CsmDeploymentStatusCollection from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CsmDeploymentStatusCollection if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CsmDeploymentStatusCollection.
     */
    public static CsmDeploymentStatusCollection fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CsmDeploymentStatusCollection deserializedCsmDeploymentStatusCollection
                = new CsmDeploymentStatusCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<CsmDeploymentStatus> value
                        = reader.readArray(reader1 -> CsmDeploymentStatus.fromJson(reader1));
                    deserializedCsmDeploymentStatusCollection.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedCsmDeploymentStatusCollection.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCsmDeploymentStatusCollection;
        });
    }
}
