// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Database connection string information.
 */
@Fluent
public final class ConnStringInfo implements JsonSerializable<ConnStringInfo> {
    /*
     * Name of connection string.
     */
    private String name;

    /*
     * Connection string value.
     */
    private String connectionString;

    /*
     * Type of database.
     */
    private ConnectionStringType type;

    /**
     * Creates an instance of ConnStringInfo class.
     */
    public ConnStringInfo() {
    }

    /**
     * Get the name property: Name of connection string.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of connection string.
     * 
     * @param name the name value to set.
     * @return the ConnStringInfo object itself.
     */
    public ConnStringInfo withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the connectionString property: Connection string value.
     * 
     * @return the connectionString value.
     */
    public String connectionString() {
        return this.connectionString;
    }

    /**
     * Set the connectionString property: Connection string value.
     * 
     * @param connectionString the connectionString value to set.
     * @return the ConnStringInfo object itself.
     */
    public ConnStringInfo withConnectionString(String connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    /**
     * Get the type property: Type of database.
     * 
     * @return the type value.
     */
    public ConnectionStringType type() {
        return this.type;
    }

    /**
     * Set the type property: Type of database.
     * 
     * @param type the type value to set.
     * @return the ConnStringInfo object itself.
     */
    public ConnStringInfo withType(ConnectionStringType type) {
        this.type = type;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("connectionString", this.connectionString);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnStringInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnStringInfo if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConnStringInfo.
     */
    public static ConnStringInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnStringInfo deserializedConnStringInfo = new ConnStringInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedConnStringInfo.name = reader.getString();
                } else if ("connectionString".equals(fieldName)) {
                    deserializedConnStringInfo.connectionString = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedConnStringInfo.type = ConnectionStringType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnStringInfo;
        });
    }
}
