// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The AppLogsConfiguration model.
 */
@Fluent
public final class AppLogsConfiguration implements JsonSerializable<AppLogsConfiguration> {
    /*
     * The destination property.
     */
    private String destination;

    /*
     * The logAnalyticsConfiguration property.
     */
    private LogAnalyticsConfiguration logAnalyticsConfiguration;

    /**
     * Creates an instance of AppLogsConfiguration class.
     */
    public AppLogsConfiguration() {
    }

    /**
     * Get the destination property: The destination property.
     * 
     * @return the destination value.
     */
    public String destination() {
        return this.destination;
    }

    /**
     * Set the destination property: The destination property.
     * 
     * @param destination the destination value to set.
     * @return the AppLogsConfiguration object itself.
     */
    public AppLogsConfiguration withDestination(String destination) {
        this.destination = destination;
        return this;
    }

    /**
     * Get the logAnalyticsConfiguration property: The logAnalyticsConfiguration property.
     * 
     * @return the logAnalyticsConfiguration value.
     */
    public LogAnalyticsConfiguration logAnalyticsConfiguration() {
        return this.logAnalyticsConfiguration;
    }

    /**
     * Set the logAnalyticsConfiguration property: The logAnalyticsConfiguration property.
     * 
     * @param logAnalyticsConfiguration the logAnalyticsConfiguration value to set.
     * @return the AppLogsConfiguration object itself.
     */
    public AppLogsConfiguration withLogAnalyticsConfiguration(LogAnalyticsConfiguration logAnalyticsConfiguration) {
        this.logAnalyticsConfiguration = logAnalyticsConfiguration;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (logAnalyticsConfiguration() != null) {
            logAnalyticsConfiguration().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("destination", this.destination);
        jsonWriter.writeJsonField("logAnalyticsConfiguration", this.logAnalyticsConfiguration);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AppLogsConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AppLogsConfiguration if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AppLogsConfiguration.
     */
    public static AppLogsConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AppLogsConfiguration deserializedAppLogsConfiguration = new AppLogsConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("destination".equals(fieldName)) {
                    deserializedAppLogsConfiguration.destination = reader.getString();
                } else if ("logAnalyticsConfiguration".equals(fieldName)) {
                    deserializedAppLogsConfiguration.logAnalyticsConfiguration
                        = LogAnalyticsConfiguration.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAppLogsConfiguration;
        });
    }
}
