// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * Class representing Abnormal Time Period identified in diagnosis.
 */
@Fluent
public final class AbnormalTimePeriod implements JsonSerializable<AbnormalTimePeriod> {
    /*
     * Start time of the downtime
     */
    private OffsetDateTime startTime;

    /*
     * End time of the downtime
     */
    private OffsetDateTime endTime;

    /*
     * List of Possible Cause of downtime
     */
    private List<DetectorAbnormalTimePeriod> events;

    /*
     * List of proposed solutions
     */
    private List<Solution> solutions;

    /**
     * Creates an instance of AbnormalTimePeriod class.
     */
    public AbnormalTimePeriod() {
    }

    /**
     * Get the startTime property: Start time of the downtime.
     * 
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    /**
     * Set the startTime property: Start time of the downtime.
     * 
     * @param startTime the startTime value to set.
     * @return the AbnormalTimePeriod object itself.
     */
    public AbnormalTimePeriod withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the endTime property: End time of the downtime.
     * 
     * @return the endTime value.
     */
    public OffsetDateTime endTime() {
        return this.endTime;
    }

    /**
     * Set the endTime property: End time of the downtime.
     * 
     * @param endTime the endTime value to set.
     * @return the AbnormalTimePeriod object itself.
     */
    public AbnormalTimePeriod withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    /**
     * Get the events property: List of Possible Cause of downtime.
     * 
     * @return the events value.
     */
    public List<DetectorAbnormalTimePeriod> events() {
        return this.events;
    }

    /**
     * Set the events property: List of Possible Cause of downtime.
     * 
     * @param events the events value to set.
     * @return the AbnormalTimePeriod object itself.
     */
    public AbnormalTimePeriod withEvents(List<DetectorAbnormalTimePeriod> events) {
        this.events = events;
        return this;
    }

    /**
     * Get the solutions property: List of proposed solutions.
     * 
     * @return the solutions value.
     */
    public List<Solution> solutions() {
        return this.solutions;
    }

    /**
     * Set the solutions property: List of proposed solutions.
     * 
     * @param solutions the solutions value to set.
     * @return the AbnormalTimePeriod object itself.
     */
    public AbnormalTimePeriod withSolutions(List<Solution> solutions) {
        this.solutions = solutions;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (events() != null) {
            events().forEach(e -> e.validate());
        }
        if (solutions() != null) {
            solutions().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startTime",
            this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime",
            this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeArrayField("events", this.events, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("solutions", this.solutions, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AbnormalTimePeriod from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AbnormalTimePeriod if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the AbnormalTimePeriod.
     */
    public static AbnormalTimePeriod fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AbnormalTimePeriod deserializedAbnormalTimePeriod = new AbnormalTimePeriod();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("startTime".equals(fieldName)) {
                    deserializedAbnormalTimePeriod.startTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("endTime".equals(fieldName)) {
                    deserializedAbnormalTimePeriod.endTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("events".equals(fieldName)) {
                    List<DetectorAbnormalTimePeriod> events
                        = reader.readArray(reader1 -> DetectorAbnormalTimePeriod.fromJson(reader1));
                    deserializedAbnormalTimePeriod.events = events;
                } else if ("solutions".equals(fieldName)) {
                    List<Solution> solutions = reader.readArray(reader1 -> Solution.fromJson(reader1));
                    deserializedAbnormalTimePeriod.solutions = solutions;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAbnormalTimePeriod;
        });
    }
}
