// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.Correlation;
import com.azure.resourcemanager.appservice.models.ResourceReference;
import com.azure.resourcemanager.appservice.models.WorkflowOutputParameter;
import com.azure.resourcemanager.appservice.models.WorkflowRunTrigger;
import com.azure.resourcemanager.appservice.models.WorkflowStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

/**
 * The workflow run properties.
 */
@Fluent
public final class WorkflowRunProperties implements JsonSerializable<WorkflowRunProperties> {
    /*
     * Gets the wait end time.
     */
    private OffsetDateTime waitEndTime;

    /*
     * Gets the start time.
     */
    private OffsetDateTime startTime;

    /*
     * Gets the end time.
     */
    private OffsetDateTime endTime;

    /*
     * Gets the status.
     */
    private WorkflowStatus status;

    /*
     * Gets the code.
     */
    private String code;

    /*
     * Gets the error.
     */
    private Object error;

    /*
     * Gets the correlation id.
     */
    private String correlationId;

    /*
     * The run correlation.
     */
    private Correlation correlation;

    /*
     * Gets the reference to workflow version.
     */
    private ResourceReference workflow;

    /*
     * Gets the fired trigger.
     */
    private WorkflowRunTrigger trigger;

    /*
     * Gets the outputs.
     */
    private Map<String, WorkflowOutputParameter> outputs;

    /*
     * Gets the response of the flow run.
     */
    private WorkflowRunTrigger response;

    /**
     * Creates an instance of WorkflowRunProperties class.
     */
    public WorkflowRunProperties() {
    }

    /**
     * Get the waitEndTime property: Gets the wait end time.
     * 
     * @return the waitEndTime value.
     */
    public OffsetDateTime waitEndTime() {
        return this.waitEndTime;
    }

    /**
     * Get the startTime property: Gets the start time.
     * 
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    /**
     * Get the endTime property: Gets the end time.
     * 
     * @return the endTime value.
     */
    public OffsetDateTime endTime() {
        return this.endTime;
    }

    /**
     * Get the status property: Gets the status.
     * 
     * @return the status value.
     */
    public WorkflowStatus status() {
        return this.status;
    }

    /**
     * Get the code property: Gets the code.
     * 
     * @return the code value.
     */
    public String code() {
        return this.code;
    }

    /**
     * Get the error property: Gets the error.
     * 
     * @return the error value.
     */
    public Object error() {
        return this.error;
    }

    /**
     * Get the correlationId property: Gets the correlation id.
     * 
     * @return the correlationId value.
     */
    public String correlationId() {
        return this.correlationId;
    }

    /**
     * Get the correlation property: The run correlation.
     * 
     * @return the correlation value.
     */
    public Correlation correlation() {
        return this.correlation;
    }

    /**
     * Set the correlation property: The run correlation.
     * 
     * @param correlation the correlation value to set.
     * @return the WorkflowRunProperties object itself.
     */
    public WorkflowRunProperties withCorrelation(Correlation correlation) {
        this.correlation = correlation;
        return this;
    }

    /**
     * Get the workflow property: Gets the reference to workflow version.
     * 
     * @return the workflow value.
     */
    public ResourceReference workflow() {
        return this.workflow;
    }

    /**
     * Get the trigger property: Gets the fired trigger.
     * 
     * @return the trigger value.
     */
    public WorkflowRunTrigger trigger() {
        return this.trigger;
    }

    /**
     * Get the outputs property: Gets the outputs.
     * 
     * @return the outputs value.
     */
    public Map<String, WorkflowOutputParameter> outputs() {
        return this.outputs;
    }

    /**
     * Get the response property: Gets the response of the flow run.
     * 
     * @return the response value.
     */
    public WorkflowRunTrigger response() {
        return this.response;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (correlation() != null) {
            correlation().validate();
        }
        if (workflow() != null) {
            workflow().validate();
        }
        if (trigger() != null) {
            trigger().validate();
        }
        if (outputs() != null) {
            outputs().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (response() != null) {
            response().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("correlation", this.correlation);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WorkflowRunProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WorkflowRunProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the WorkflowRunProperties.
     */
    public static WorkflowRunProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WorkflowRunProperties deserializedWorkflowRunProperties = new WorkflowRunProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("waitEndTime".equals(fieldName)) {
                    deserializedWorkflowRunProperties.waitEndTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("startTime".equals(fieldName)) {
                    deserializedWorkflowRunProperties.startTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("endTime".equals(fieldName)) {
                    deserializedWorkflowRunProperties.endTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("status".equals(fieldName)) {
                    deserializedWorkflowRunProperties.status = WorkflowStatus.fromString(reader.getString());
                } else if ("code".equals(fieldName)) {
                    deserializedWorkflowRunProperties.code = reader.getString();
                } else if ("error".equals(fieldName)) {
                    deserializedWorkflowRunProperties.error = reader.readUntyped();
                } else if ("correlationId".equals(fieldName)) {
                    deserializedWorkflowRunProperties.correlationId = reader.getString();
                } else if ("correlation".equals(fieldName)) {
                    deserializedWorkflowRunProperties.correlation = Correlation.fromJson(reader);
                } else if ("workflow".equals(fieldName)) {
                    deserializedWorkflowRunProperties.workflow = ResourceReference.fromJson(reader);
                } else if ("trigger".equals(fieldName)) {
                    deserializedWorkflowRunProperties.trigger = WorkflowRunTrigger.fromJson(reader);
                } else if ("outputs".equals(fieldName)) {
                    Map<String, WorkflowOutputParameter> outputs
                        = reader.readMap(reader1 -> WorkflowOutputParameter.fromJson(reader1));
                    deserializedWorkflowRunProperties.outputs = outputs;
                } else if ("response".equals(fieldName)) {
                    deserializedWorkflowRunProperties.response = WorkflowRunTrigger.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWorkflowRunProperties;
        });
    }
}
