// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * VnetGateway resource specific properties.
 */
@Fluent
public final class VnetGatewayProperties implements JsonSerializable<VnetGatewayProperties> {
    /*
     * The Virtual Network name.
     */
    private String vnetName;

    /*
     * The URI where the VPN package can be downloaded.
     */
    private String vpnPackageUri;

    /**
     * Creates an instance of VnetGatewayProperties class.
     */
    public VnetGatewayProperties() {
    }

    /**
     * Get the vnetName property: The Virtual Network name.
     * 
     * @return the vnetName value.
     */
    public String vnetName() {
        return this.vnetName;
    }

    /**
     * Set the vnetName property: The Virtual Network name.
     * 
     * @param vnetName the vnetName value to set.
     * @return the VnetGatewayProperties object itself.
     */
    public VnetGatewayProperties withVnetName(String vnetName) {
        this.vnetName = vnetName;
        return this;
    }

    /**
     * Get the vpnPackageUri property: The URI where the VPN package can be downloaded.
     * 
     * @return the vpnPackageUri value.
     */
    public String vpnPackageUri() {
        return this.vpnPackageUri;
    }

    /**
     * Set the vpnPackageUri property: The URI where the VPN package can be downloaded.
     * 
     * @param vpnPackageUri the vpnPackageUri value to set.
     * @return the VnetGatewayProperties object itself.
     */
    public VnetGatewayProperties withVpnPackageUri(String vpnPackageUri) {
        this.vpnPackageUri = vpnPackageUri;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (vpnPackageUri() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property vpnPackageUri in model VnetGatewayProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(VnetGatewayProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("vpnPackageUri", this.vpnPackageUri);
        jsonWriter.writeStringField("vnetName", this.vnetName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VnetGatewayProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VnetGatewayProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VnetGatewayProperties.
     */
    public static VnetGatewayProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VnetGatewayProperties deserializedVnetGatewayProperties = new VnetGatewayProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("vpnPackageUri".equals(fieldName)) {
                    deserializedVnetGatewayProperties.vpnPackageUri = reader.getString();
                } else if ("vnetName".equals(fieldName)) {
                    deserializedVnetGatewayProperties.vnetName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVnetGatewayProperties;
        });
    }
}
