// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * App properties used for validation.
 */
@Fluent
public final class ValidatePropertiesInner implements JsonSerializable<ValidatePropertiesInner> {
    /*
     * ARM resource ID of an App Service plan that would host the app.
     */
    private String serverFarmId;

    /*
     * Name of the target SKU for the App Service plan.
     */
    private String skuName;

    /*
     * <code>true</code> if App Service plan is for Linux workers; otherwise, <code>false</code>.
     */
    private Boolean needLinuxWorkers;

    /*
     * <code>true</code> if App Service plan is for Spot instances; otherwise, <code>false</code>.
     */
    private Boolean isSpot;

    /*
     * Target capacity of the App Service plan (number of VMs).
     */
    private Integer capacity;

    /*
     * Name of App Service Environment where app or App Service plan should be created.
     */
    private String hostingEnvironment;

    /*
     * <code>true</code> if App Service plan is running as a windows container
     */
    private Boolean isXenon;

    /*
     * Base URL of the container registry
     */
    private String containerRegistryBaseUrl;

    /*
     * Username for to access the container registry
     */
    private String containerRegistryUsername;

    /*
     * Password for to access the container registry
     */
    private String containerRegistryPassword;

    /*
     * Repository name (image name)
     */
    private String containerImageRepository;

    /*
     * Image tag
     */
    private String containerImageTag;

    /*
     * Platform (windows or linux)
     */
    private String containerImagePlatform;

    /*
     * App Service Environment Properties
     */
    private AppServiceEnvironmentInner appServiceEnvironment;

    /**
     * Creates an instance of ValidatePropertiesInner class.
     */
    public ValidatePropertiesInner() {
    }

    /**
     * Get the serverFarmId property: ARM resource ID of an App Service plan that would host the app.
     * 
     * @return the serverFarmId value.
     */
    public String serverFarmId() {
        return this.serverFarmId;
    }

    /**
     * Set the serverFarmId property: ARM resource ID of an App Service plan that would host the app.
     * 
     * @param serverFarmId the serverFarmId value to set.
     * @return the ValidatePropertiesInner object itself.
     */
    public ValidatePropertiesInner withServerFarmId(String serverFarmId) {
        this.serverFarmId = serverFarmId;
        return this;
    }

    /**
     * Get the skuName property: Name of the target SKU for the App Service plan.
     * 
     * @return the skuName value.
     */
    public String skuName() {
        return this.skuName;
    }

    /**
     * Set the skuName property: Name of the target SKU for the App Service plan.
     * 
     * @param skuName the skuName value to set.
     * @return the ValidatePropertiesInner object itself.
     */
    public ValidatePropertiesInner withSkuName(String skuName) {
        this.skuName = skuName;
        return this;
    }

    /**
     * Get the needLinuxWorkers property: &lt;code&gt;true&lt;/code&gt; if App Service plan is for Linux workers;
     * otherwise, &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the needLinuxWorkers value.
     */
    public Boolean needLinuxWorkers() {
        return this.needLinuxWorkers;
    }

    /**
     * Set the needLinuxWorkers property: &lt;code&gt;true&lt;/code&gt; if App Service plan is for Linux workers;
     * otherwise, &lt;code&gt;false&lt;/code&gt;.
     * 
     * @param needLinuxWorkers the needLinuxWorkers value to set.
     * @return the ValidatePropertiesInner object itself.
     */
    public ValidatePropertiesInner withNeedLinuxWorkers(Boolean needLinuxWorkers) {
        this.needLinuxWorkers = needLinuxWorkers;
        return this;
    }

    /**
     * Get the isSpot property: &lt;code&gt;true&lt;/code&gt; if App Service plan is for Spot instances; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the isSpot value.
     */
    public Boolean isSpot() {
        return this.isSpot;
    }

    /**
     * Set the isSpot property: &lt;code&gt;true&lt;/code&gt; if App Service plan is for Spot instances; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @param isSpot the isSpot value to set.
     * @return the ValidatePropertiesInner object itself.
     */
    public ValidatePropertiesInner withIsSpot(Boolean isSpot) {
        this.isSpot = isSpot;
        return this;
    }

    /**
     * Get the capacity property: Target capacity of the App Service plan (number of VMs).
     * 
     * @return the capacity value.
     */
    public Integer capacity() {
        return this.capacity;
    }

    /**
     * Set the capacity property: Target capacity of the App Service plan (number of VMs).
     * 
     * @param capacity the capacity value to set.
     * @return the ValidatePropertiesInner object itself.
     */
    public ValidatePropertiesInner withCapacity(Integer capacity) {
        this.capacity = capacity;
        return this;
    }

    /**
     * Get the hostingEnvironment property: Name of App Service Environment where app or App Service plan should be
     * created.
     * 
     * @return the hostingEnvironment value.
     */
    public String hostingEnvironment() {
        return this.hostingEnvironment;
    }

    /**
     * Set the hostingEnvironment property: Name of App Service Environment where app or App Service plan should be
     * created.
     * 
     * @param hostingEnvironment the hostingEnvironment value to set.
     * @return the ValidatePropertiesInner object itself.
     */
    public ValidatePropertiesInner withHostingEnvironment(String hostingEnvironment) {
        this.hostingEnvironment = hostingEnvironment;
        return this;
    }

    /**
     * Get the isXenon property: &lt;code&gt;true&lt;/code&gt; if App Service plan is running as a windows container.
     * 
     * @return the isXenon value.
     */
    public Boolean isXenon() {
        return this.isXenon;
    }

    /**
     * Set the isXenon property: &lt;code&gt;true&lt;/code&gt; if App Service plan is running as a windows container.
     * 
     * @param isXenon the isXenon value to set.
     * @return the ValidatePropertiesInner object itself.
     */
    public ValidatePropertiesInner withIsXenon(Boolean isXenon) {
        this.isXenon = isXenon;
        return this;
    }

    /**
     * Get the containerRegistryBaseUrl property: Base URL of the container registry.
     * 
     * @return the containerRegistryBaseUrl value.
     */
    public String containerRegistryBaseUrl() {
        return this.containerRegistryBaseUrl;
    }

    /**
     * Set the containerRegistryBaseUrl property: Base URL of the container registry.
     * 
     * @param containerRegistryBaseUrl the containerRegistryBaseUrl value to set.
     * @return the ValidatePropertiesInner object itself.
     */
    public ValidatePropertiesInner withContainerRegistryBaseUrl(String containerRegistryBaseUrl) {
        this.containerRegistryBaseUrl = containerRegistryBaseUrl;
        return this;
    }

    /**
     * Get the containerRegistryUsername property: Username for to access the container registry.
     * 
     * @return the containerRegistryUsername value.
     */
    public String containerRegistryUsername() {
        return this.containerRegistryUsername;
    }

    /**
     * Set the containerRegistryUsername property: Username for to access the container registry.
     * 
     * @param containerRegistryUsername the containerRegistryUsername value to set.
     * @return the ValidatePropertiesInner object itself.
     */
    public ValidatePropertiesInner withContainerRegistryUsername(String containerRegistryUsername) {
        this.containerRegistryUsername = containerRegistryUsername;
        return this;
    }

    /**
     * Get the containerRegistryPassword property: Password for to access the container registry.
     * 
     * @return the containerRegistryPassword value.
     */
    public String containerRegistryPassword() {
        return this.containerRegistryPassword;
    }

    /**
     * Set the containerRegistryPassword property: Password for to access the container registry.
     * 
     * @param containerRegistryPassword the containerRegistryPassword value to set.
     * @return the ValidatePropertiesInner object itself.
     */
    public ValidatePropertiesInner withContainerRegistryPassword(String containerRegistryPassword) {
        this.containerRegistryPassword = containerRegistryPassword;
        return this;
    }

    /**
     * Get the containerImageRepository property: Repository name (image name).
     * 
     * @return the containerImageRepository value.
     */
    public String containerImageRepository() {
        return this.containerImageRepository;
    }

    /**
     * Set the containerImageRepository property: Repository name (image name).
     * 
     * @param containerImageRepository the containerImageRepository value to set.
     * @return the ValidatePropertiesInner object itself.
     */
    public ValidatePropertiesInner withContainerImageRepository(String containerImageRepository) {
        this.containerImageRepository = containerImageRepository;
        return this;
    }

    /**
     * Get the containerImageTag property: Image tag.
     * 
     * @return the containerImageTag value.
     */
    public String containerImageTag() {
        return this.containerImageTag;
    }

    /**
     * Set the containerImageTag property: Image tag.
     * 
     * @param containerImageTag the containerImageTag value to set.
     * @return the ValidatePropertiesInner object itself.
     */
    public ValidatePropertiesInner withContainerImageTag(String containerImageTag) {
        this.containerImageTag = containerImageTag;
        return this;
    }

    /**
     * Get the containerImagePlatform property: Platform (windows or linux).
     * 
     * @return the containerImagePlatform value.
     */
    public String containerImagePlatform() {
        return this.containerImagePlatform;
    }

    /**
     * Set the containerImagePlatform property: Platform (windows or linux).
     * 
     * @param containerImagePlatform the containerImagePlatform value to set.
     * @return the ValidatePropertiesInner object itself.
     */
    public ValidatePropertiesInner withContainerImagePlatform(String containerImagePlatform) {
        this.containerImagePlatform = containerImagePlatform;
        return this;
    }

    /**
     * Get the appServiceEnvironment property: App Service Environment Properties.
     * 
     * @return the appServiceEnvironment value.
     */
    public AppServiceEnvironmentInner appServiceEnvironment() {
        return this.appServiceEnvironment;
    }

    /**
     * Set the appServiceEnvironment property: App Service Environment Properties.
     * 
     * @param appServiceEnvironment the appServiceEnvironment value to set.
     * @return the ValidatePropertiesInner object itself.
     */
    public ValidatePropertiesInner withAppServiceEnvironment(AppServiceEnvironmentInner appServiceEnvironment) {
        this.appServiceEnvironment = appServiceEnvironment;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (appServiceEnvironment() != null) {
            appServiceEnvironment().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serverFarmId", this.serverFarmId);
        jsonWriter.writeStringField("skuName", this.skuName);
        jsonWriter.writeBooleanField("needLinuxWorkers", this.needLinuxWorkers);
        jsonWriter.writeBooleanField("isSpot", this.isSpot);
        jsonWriter.writeNumberField("capacity", this.capacity);
        jsonWriter.writeStringField("hostingEnvironment", this.hostingEnvironment);
        jsonWriter.writeBooleanField("isXenon", this.isXenon);
        jsonWriter.writeStringField("containerRegistryBaseUrl", this.containerRegistryBaseUrl);
        jsonWriter.writeStringField("containerRegistryUsername", this.containerRegistryUsername);
        jsonWriter.writeStringField("containerRegistryPassword", this.containerRegistryPassword);
        jsonWriter.writeStringField("containerImageRepository", this.containerImageRepository);
        jsonWriter.writeStringField("containerImageTag", this.containerImageTag);
        jsonWriter.writeStringField("containerImagePlatform", this.containerImagePlatform);
        jsonWriter.writeJsonField("appServiceEnvironment", this.appServiceEnvironment);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ValidatePropertiesInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ValidatePropertiesInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ValidatePropertiesInner.
     */
    public static ValidatePropertiesInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ValidatePropertiesInner deserializedValidatePropertiesInner = new ValidatePropertiesInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("serverFarmId".equals(fieldName)) {
                    deserializedValidatePropertiesInner.serverFarmId = reader.getString();
                } else if ("skuName".equals(fieldName)) {
                    deserializedValidatePropertiesInner.skuName = reader.getString();
                } else if ("needLinuxWorkers".equals(fieldName)) {
                    deserializedValidatePropertiesInner.needLinuxWorkers = reader.getNullable(JsonReader::getBoolean);
                } else if ("isSpot".equals(fieldName)) {
                    deserializedValidatePropertiesInner.isSpot = reader.getNullable(JsonReader::getBoolean);
                } else if ("capacity".equals(fieldName)) {
                    deserializedValidatePropertiesInner.capacity = reader.getNullable(JsonReader::getInt);
                } else if ("hostingEnvironment".equals(fieldName)) {
                    deserializedValidatePropertiesInner.hostingEnvironment = reader.getString();
                } else if ("isXenon".equals(fieldName)) {
                    deserializedValidatePropertiesInner.isXenon = reader.getNullable(JsonReader::getBoolean);
                } else if ("containerRegistryBaseUrl".equals(fieldName)) {
                    deserializedValidatePropertiesInner.containerRegistryBaseUrl = reader.getString();
                } else if ("containerRegistryUsername".equals(fieldName)) {
                    deserializedValidatePropertiesInner.containerRegistryUsername = reader.getString();
                } else if ("containerRegistryPassword".equals(fieldName)) {
                    deserializedValidatePropertiesInner.containerRegistryPassword = reader.getString();
                } else if ("containerImageRepository".equals(fieldName)) {
                    deserializedValidatePropertiesInner.containerImageRepository = reader.getString();
                } else if ("containerImageTag".equals(fieldName)) {
                    deserializedValidatePropertiesInner.containerImageTag = reader.getString();
                } else if ("containerImagePlatform".equals(fieldName)) {
                    deserializedValidatePropertiesInner.containerImagePlatform = reader.getString();
                } else if ("appServiceEnvironment".equals(fieldName)) {
                    deserializedValidatePropertiesInner.appServiceEnvironment
                        = AppServiceEnvironmentInner.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedValidatePropertiesInner;
        });
    }
}
