// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.TriggerTypes;
import java.io.IOException;

/**
 * StaticSiteFunctionOverviewARMResource resource specific properties.
 */
@Immutable
public final class StaticSiteFunctionOverviewArmResourceProperties
    implements JsonSerializable<StaticSiteFunctionOverviewArmResourceProperties> {
    /*
     * The name for the function
     */
    private String functionName;

    /*
     * The trigger type of the function
     */
    private TriggerTypes triggerType;

    /**
     * Creates an instance of StaticSiteFunctionOverviewArmResourceProperties class.
     */
    public StaticSiteFunctionOverviewArmResourceProperties() {
    }

    /**
     * Get the functionName property: The name for the function.
     * 
     * @return the functionName value.
     */
    public String functionName() {
        return this.functionName;
    }

    /**
     * Get the triggerType property: The trigger type of the function.
     * 
     * @return the triggerType value.
     */
    public TriggerTypes triggerType() {
        return this.triggerType;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StaticSiteFunctionOverviewArmResourceProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StaticSiteFunctionOverviewArmResourceProperties if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the StaticSiteFunctionOverviewArmResourceProperties.
     */
    public static StaticSiteFunctionOverviewArmResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StaticSiteFunctionOverviewArmResourceProperties deserializedStaticSiteFunctionOverviewArmResourceProperties
                = new StaticSiteFunctionOverviewArmResourceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("functionName".equals(fieldName)) {
                    deserializedStaticSiteFunctionOverviewArmResourceProperties.functionName = reader.getString();
                } else if ("triggerType".equals(fieldName)) {
                    deserializedStaticSiteFunctionOverviewArmResourceProperties.triggerType
                        = TriggerTypes.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStaticSiteFunctionOverviewArmResourceProperties;
        });
    }
}
