// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.TriggerTypes;
import java.io.IOException;

/**
 * Static Site Function Overview ARM resource.
 */
@Fluent
public final class StaticSiteFunctionOverviewArmResourceInner extends ProxyOnlyResource {
    /*
     * StaticSiteFunctionOverviewARMResource resource specific properties
     */
    private StaticSiteFunctionOverviewArmResourceProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of StaticSiteFunctionOverviewArmResourceInner class.
     */
    public StaticSiteFunctionOverviewArmResourceInner() {
    }

    /**
     * Get the innerProperties property: StaticSiteFunctionOverviewARMResource resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private StaticSiteFunctionOverviewArmResourceProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public StaticSiteFunctionOverviewArmResourceInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the functionName property: The name for the function.
     * 
     * @return the functionName value.
     */
    public String functionName() {
        return this.innerProperties() == null ? null : this.innerProperties().functionName();
    }

    /**
     * Get the triggerType property: The trigger type of the function.
     * 
     * @return the triggerType value.
     */
    public TriggerTypes triggerType() {
        return this.innerProperties() == null ? null : this.innerProperties().triggerType();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StaticSiteFunctionOverviewArmResourceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StaticSiteFunctionOverviewArmResourceInner if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the StaticSiteFunctionOverviewArmResourceInner.
     */
    public static StaticSiteFunctionOverviewArmResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StaticSiteFunctionOverviewArmResourceInner deserializedStaticSiteFunctionOverviewArmResourceInner
                = new StaticSiteFunctionOverviewArmResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedStaticSiteFunctionOverviewArmResourceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedStaticSiteFunctionOverviewArmResourceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedStaticSiteFunctionOverviewArmResourceInner.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedStaticSiteFunctionOverviewArmResourceInner.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedStaticSiteFunctionOverviewArmResourceInner.innerProperties
                        = StaticSiteFunctionOverviewArmResourceProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStaticSiteFunctionOverviewArmResourceInner;
        });
    }
}
