// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.SiteExtensionType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * Site Extension Information.
 */
@Fluent
public final class SiteExtensionInfoInner extends ProxyOnlyResource {
    /*
     * SiteExtensionInfo resource specific properties
     */
    private SiteExtensionInfoProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of SiteExtensionInfoInner class.
     */
    public SiteExtensionInfoInner() {
    }

    /**
     * Get the innerProperties property: SiteExtensionInfo resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private SiteExtensionInfoProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SiteExtensionInfoInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the extensionId property: Site extension ID.
     * 
     * @return the extensionId value.
     */
    public String extensionId() {
        return this.innerProperties() == null ? null : this.innerProperties().extensionId();
    }

    /**
     * Set the extensionId property: Site extension ID.
     * 
     * @param extensionId the extensionId value to set.
     * @return the SiteExtensionInfoInner object itself.
     */
    public SiteExtensionInfoInner withExtensionId(String extensionId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteExtensionInfoProperties();
        }
        this.innerProperties().withExtensionId(extensionId);
        return this;
    }

    /**
     * Get the title property: The title property.
     * 
     * @return the title value.
     */
    public String title() {
        return this.innerProperties() == null ? null : this.innerProperties().title();
    }

    /**
     * Set the title property: The title property.
     * 
     * @param title the title value to set.
     * @return the SiteExtensionInfoInner object itself.
     */
    public SiteExtensionInfoInner withTitle(String title) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteExtensionInfoProperties();
        }
        this.innerProperties().withTitle(title);
        return this;
    }

    /**
     * Get the extensionType property: Site extension type.
     * 
     * @return the extensionType value.
     */
    public SiteExtensionType extensionType() {
        return this.innerProperties() == null ? null : this.innerProperties().extensionType();
    }

    /**
     * Set the extensionType property: Site extension type.
     * 
     * @param extensionType the extensionType value to set.
     * @return the SiteExtensionInfoInner object itself.
     */
    public SiteExtensionInfoInner withExtensionType(SiteExtensionType extensionType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteExtensionInfoProperties();
        }
        this.innerProperties().withExtensionType(extensionType);
        return this;
    }

    /**
     * Get the summary property: Summary description.
     * 
     * @return the summary value.
     */
    public String summary() {
        return this.innerProperties() == null ? null : this.innerProperties().summary();
    }

    /**
     * Set the summary property: Summary description.
     * 
     * @param summary the summary value to set.
     * @return the SiteExtensionInfoInner object itself.
     */
    public SiteExtensionInfoInner withSummary(String summary) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteExtensionInfoProperties();
        }
        this.innerProperties().withSummary(summary);
        return this;
    }

    /**
     * Get the description property: Detailed description.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: Detailed description.
     * 
     * @param description the description value to set.
     * @return the SiteExtensionInfoInner object itself.
     */
    public SiteExtensionInfoInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteExtensionInfoProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the version property: Version information.
     * 
     * @return the version value.
     */
    public String version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    /**
     * Set the version property: Version information.
     * 
     * @param version the version value to set.
     * @return the SiteExtensionInfoInner object itself.
     */
    public SiteExtensionInfoInner withVersion(String version) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteExtensionInfoProperties();
        }
        this.innerProperties().withVersion(version);
        return this;
    }

    /**
     * Get the extensionUrl property: Extension URL.
     * 
     * @return the extensionUrl value.
     */
    public String extensionUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().extensionUrl();
    }

    /**
     * Set the extensionUrl property: Extension URL.
     * 
     * @param extensionUrl the extensionUrl value to set.
     * @return the SiteExtensionInfoInner object itself.
     */
    public SiteExtensionInfoInner withExtensionUrl(String extensionUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteExtensionInfoProperties();
        }
        this.innerProperties().withExtensionUrl(extensionUrl);
        return this;
    }

    /**
     * Get the projectUrl property: Project URL.
     * 
     * @return the projectUrl value.
     */
    public String projectUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().projectUrl();
    }

    /**
     * Set the projectUrl property: Project URL.
     * 
     * @param projectUrl the projectUrl value to set.
     * @return the SiteExtensionInfoInner object itself.
     */
    public SiteExtensionInfoInner withProjectUrl(String projectUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteExtensionInfoProperties();
        }
        this.innerProperties().withProjectUrl(projectUrl);
        return this;
    }

    /**
     * Get the iconUrl property: Icon URL.
     * 
     * @return the iconUrl value.
     */
    public String iconUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().iconUrl();
    }

    /**
     * Set the iconUrl property: Icon URL.
     * 
     * @param iconUrl the iconUrl value to set.
     * @return the SiteExtensionInfoInner object itself.
     */
    public SiteExtensionInfoInner withIconUrl(String iconUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteExtensionInfoProperties();
        }
        this.innerProperties().withIconUrl(iconUrl);
        return this;
    }

    /**
     * Get the licenseUrl property: License URL.
     * 
     * @return the licenseUrl value.
     */
    public String licenseUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().licenseUrl();
    }

    /**
     * Set the licenseUrl property: License URL.
     * 
     * @param licenseUrl the licenseUrl value to set.
     * @return the SiteExtensionInfoInner object itself.
     */
    public SiteExtensionInfoInner withLicenseUrl(String licenseUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteExtensionInfoProperties();
        }
        this.innerProperties().withLicenseUrl(licenseUrl);
        return this;
    }

    /**
     * Get the feedUrl property: Feed URL.
     * 
     * @return the feedUrl value.
     */
    public String feedUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().feedUrl();
    }

    /**
     * Set the feedUrl property: Feed URL.
     * 
     * @param feedUrl the feedUrl value to set.
     * @return the SiteExtensionInfoInner object itself.
     */
    public SiteExtensionInfoInner withFeedUrl(String feedUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteExtensionInfoProperties();
        }
        this.innerProperties().withFeedUrl(feedUrl);
        return this;
    }

    /**
     * Get the authors property: List of authors.
     * 
     * @return the authors value.
     */
    public List<String> authors() {
        return this.innerProperties() == null ? null : this.innerProperties().authors();
    }

    /**
     * Set the authors property: List of authors.
     * 
     * @param authors the authors value to set.
     * @return the SiteExtensionInfoInner object itself.
     */
    public SiteExtensionInfoInner withAuthors(List<String> authors) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteExtensionInfoProperties();
        }
        this.innerProperties().withAuthors(authors);
        return this;
    }

    /**
     * Get the installerCommandLineParams property: Installer command line parameters.
     * 
     * @return the installerCommandLineParams value.
     */
    public String installerCommandLineParams() {
        return this.innerProperties() == null ? null : this.innerProperties().installerCommandLineParams();
    }

    /**
     * Set the installerCommandLineParams property: Installer command line parameters.
     * 
     * @param installerCommandLineParams the installerCommandLineParams value to set.
     * @return the SiteExtensionInfoInner object itself.
     */
    public SiteExtensionInfoInner withInstallerCommandLineParams(String installerCommandLineParams) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteExtensionInfoProperties();
        }
        this.innerProperties().withInstallerCommandLineParams(installerCommandLineParams);
        return this;
    }

    /**
     * Get the publishedDateTime property: Published timestamp.
     * 
     * @return the publishedDateTime value.
     */
    public OffsetDateTime publishedDateTime() {
        return this.innerProperties() == null ? null : this.innerProperties().publishedDateTime();
    }

    /**
     * Set the publishedDateTime property: Published timestamp.
     * 
     * @param publishedDateTime the publishedDateTime value to set.
     * @return the SiteExtensionInfoInner object itself.
     */
    public SiteExtensionInfoInner withPublishedDateTime(OffsetDateTime publishedDateTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteExtensionInfoProperties();
        }
        this.innerProperties().withPublishedDateTime(publishedDateTime);
        return this;
    }

    /**
     * Get the downloadCount property: Count of downloads.
     * 
     * @return the downloadCount value.
     */
    public Integer downloadCount() {
        return this.innerProperties() == null ? null : this.innerProperties().downloadCount();
    }

    /**
     * Set the downloadCount property: Count of downloads.
     * 
     * @param downloadCount the downloadCount value to set.
     * @return the SiteExtensionInfoInner object itself.
     */
    public SiteExtensionInfoInner withDownloadCount(Integer downloadCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteExtensionInfoProperties();
        }
        this.innerProperties().withDownloadCount(downloadCount);
        return this;
    }

    /**
     * Get the localIsLatestVersion property: &lt;code&gt;true&lt;/code&gt; if the local version is the latest version;
     * &lt;code&gt;false&lt;/code&gt; otherwise.
     * 
     * @return the localIsLatestVersion value.
     */
    public Boolean localIsLatestVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().localIsLatestVersion();
    }

    /**
     * Set the localIsLatestVersion property: &lt;code&gt;true&lt;/code&gt; if the local version is the latest version;
     * &lt;code&gt;false&lt;/code&gt; otherwise.
     * 
     * @param localIsLatestVersion the localIsLatestVersion value to set.
     * @return the SiteExtensionInfoInner object itself.
     */
    public SiteExtensionInfoInner withLocalIsLatestVersion(Boolean localIsLatestVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteExtensionInfoProperties();
        }
        this.innerProperties().withLocalIsLatestVersion(localIsLatestVersion);
        return this;
    }

    /**
     * Get the localPath property: Local path.
     * 
     * @return the localPath value.
     */
    public String localPath() {
        return this.innerProperties() == null ? null : this.innerProperties().localPath();
    }

    /**
     * Set the localPath property: Local path.
     * 
     * @param localPath the localPath value to set.
     * @return the SiteExtensionInfoInner object itself.
     */
    public SiteExtensionInfoInner withLocalPath(String localPath) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteExtensionInfoProperties();
        }
        this.innerProperties().withLocalPath(localPath);
        return this;
    }

    /**
     * Get the installedDateTime property: Installed timestamp.
     * 
     * @return the installedDateTime value.
     */
    public OffsetDateTime installedDateTime() {
        return this.innerProperties() == null ? null : this.innerProperties().installedDateTime();
    }

    /**
     * Set the installedDateTime property: Installed timestamp.
     * 
     * @param installedDateTime the installedDateTime value to set.
     * @return the SiteExtensionInfoInner object itself.
     */
    public SiteExtensionInfoInner withInstalledDateTime(OffsetDateTime installedDateTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteExtensionInfoProperties();
        }
        this.innerProperties().withInstalledDateTime(installedDateTime);
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning state.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Set the provisioningState property: Provisioning state.
     * 
     * @param provisioningState the provisioningState value to set.
     * @return the SiteExtensionInfoInner object itself.
     */
    public SiteExtensionInfoInner withProvisioningState(String provisioningState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteExtensionInfoProperties();
        }
        this.innerProperties().withProvisioningState(provisioningState);
        return this;
    }

    /**
     * Get the comment property: Site Extension comment.
     * 
     * @return the comment value.
     */
    public String comment() {
        return this.innerProperties() == null ? null : this.innerProperties().comment();
    }

    /**
     * Set the comment property: Site Extension comment.
     * 
     * @param comment the comment value to set.
     * @return the SiteExtensionInfoInner object itself.
     */
    public SiteExtensionInfoInner withComment(String comment) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteExtensionInfoProperties();
        }
        this.innerProperties().withComment(comment);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SiteExtensionInfoInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SiteExtensionInfoInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SiteExtensionInfoInner.
     */
    public static SiteExtensionInfoInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SiteExtensionInfoInner deserializedSiteExtensionInfoInner = new SiteExtensionInfoInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedSiteExtensionInfoInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedSiteExtensionInfoInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedSiteExtensionInfoInner.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedSiteExtensionInfoInner.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedSiteExtensionInfoInner.innerProperties = SiteExtensionInfoProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSiteExtensionInfoInner;
        });
    }
}
