// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ApiDefinitionInfo;
import com.azure.resourcemanager.appservice.models.ApiManagementConfig;
import com.azure.resourcemanager.appservice.models.AutoHealRules;
import com.azure.resourcemanager.appservice.models.AzureStorageInfoValue;
import com.azure.resourcemanager.appservice.models.ConnStringInfo;
import com.azure.resourcemanager.appservice.models.CorsSettings;
import com.azure.resourcemanager.appservice.models.DefaultAction;
import com.azure.resourcemanager.appservice.models.Experiments;
import com.azure.resourcemanager.appservice.models.FtpsState;
import com.azure.resourcemanager.appservice.models.HandlerMapping;
import com.azure.resourcemanager.appservice.models.IpSecurityRestriction;
import com.azure.resourcemanager.appservice.models.ManagedPipelineMode;
import com.azure.resourcemanager.appservice.models.NameValuePair;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.ScmType;
import com.azure.resourcemanager.appservice.models.SiteLimits;
import com.azure.resourcemanager.appservice.models.SiteLoadBalancing;
import com.azure.resourcemanager.appservice.models.SiteMachineKey;
import com.azure.resourcemanager.appservice.models.SupportedTlsVersions;
import com.azure.resourcemanager.appservice.models.TlsCipherSuites;
import com.azure.resourcemanager.appservice.models.VirtualApplication;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

/**
 * Web app configuration ARM resource.
 */
@Fluent
public final class SiteConfigResourceInner extends ProxyOnlyResource {
    /*
     * Core resource properties
     */
    private SiteConfigInner innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of SiteConfigResourceInner class.
     */
    public SiteConfigResourceInner() {
    }

    /**
     * Get the innerProperties property: Core resource properties.
     * 
     * @return the innerProperties value.
     */
    private SiteConfigInner innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SiteConfigResourceInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the numberOfWorkers property: Number of workers.
     * 
     * @return the numberOfWorkers value.
     */
    public Integer numberOfWorkers() {
        return this.innerProperties() == null ? null : this.innerProperties().numberOfWorkers();
    }

    /**
     * Set the numberOfWorkers property: Number of workers.
     * 
     * @param numberOfWorkers the numberOfWorkers value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withNumberOfWorkers(Integer numberOfWorkers) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withNumberOfWorkers(numberOfWorkers);
        return this;
    }

    /**
     * Get the defaultDocuments property: Default documents.
     * 
     * @return the defaultDocuments value.
     */
    public List<String> defaultDocuments() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultDocuments();
    }

    /**
     * Set the defaultDocuments property: Default documents.
     * 
     * @param defaultDocuments the defaultDocuments value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withDefaultDocuments(List<String> defaultDocuments) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withDefaultDocuments(defaultDocuments);
        return this;
    }

    /**
     * Get the netFrameworkVersion property: .NET Framework version.
     * 
     * @return the netFrameworkVersion value.
     */
    public String netFrameworkVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().netFrameworkVersion();
    }

    /**
     * Set the netFrameworkVersion property: .NET Framework version.
     * 
     * @param netFrameworkVersion the netFrameworkVersion value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withNetFrameworkVersion(String netFrameworkVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withNetFrameworkVersion(netFrameworkVersion);
        return this;
    }

    /**
     * Get the phpVersion property: Version of PHP.
     * 
     * @return the phpVersion value.
     */
    public String phpVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().phpVersion();
    }

    /**
     * Set the phpVersion property: Version of PHP.
     * 
     * @param phpVersion the phpVersion value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withPhpVersion(String phpVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withPhpVersion(phpVersion);
        return this;
    }

    /**
     * Get the pythonVersion property: Version of Python.
     * 
     * @return the pythonVersion value.
     */
    public String pythonVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().pythonVersion();
    }

    /**
     * Set the pythonVersion property: Version of Python.
     * 
     * @param pythonVersion the pythonVersion value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withPythonVersion(String pythonVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withPythonVersion(pythonVersion);
        return this;
    }

    /**
     * Get the nodeVersion property: Version of Node.js.
     * 
     * @return the nodeVersion value.
     */
    public String nodeVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().nodeVersion();
    }

    /**
     * Set the nodeVersion property: Version of Node.js.
     * 
     * @param nodeVersion the nodeVersion value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withNodeVersion(String nodeVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withNodeVersion(nodeVersion);
        return this;
    }

    /**
     * Get the powerShellVersion property: Version of PowerShell.
     * 
     * @return the powerShellVersion value.
     */
    public String powerShellVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().powerShellVersion();
    }

    /**
     * Set the powerShellVersion property: Version of PowerShell.
     * 
     * @param powerShellVersion the powerShellVersion value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withPowerShellVersion(String powerShellVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withPowerShellVersion(powerShellVersion);
        return this;
    }

    /**
     * Get the linuxFxVersion property: Linux App Framework and version.
     * 
     * @return the linuxFxVersion value.
     */
    public String linuxFxVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().linuxFxVersion();
    }

    /**
     * Set the linuxFxVersion property: Linux App Framework and version.
     * 
     * @param linuxFxVersion the linuxFxVersion value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withLinuxFxVersion(String linuxFxVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withLinuxFxVersion(linuxFxVersion);
        return this;
    }

    /**
     * Get the windowsFxVersion property: Xenon App Framework and version.
     * 
     * @return the windowsFxVersion value.
     */
    public String windowsFxVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().windowsFxVersion();
    }

    /**
     * Set the windowsFxVersion property: Xenon App Framework and version.
     * 
     * @param windowsFxVersion the windowsFxVersion value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withWindowsFxVersion(String windowsFxVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withWindowsFxVersion(windowsFxVersion);
        return this;
    }

    /**
     * Get the requestTracingEnabled property: &lt;code&gt;true&lt;/code&gt; if request tracing is enabled; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the requestTracingEnabled value.
     */
    public Boolean requestTracingEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().requestTracingEnabled();
    }

    /**
     * Set the requestTracingEnabled property: &lt;code&gt;true&lt;/code&gt; if request tracing is enabled; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @param requestTracingEnabled the requestTracingEnabled value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withRequestTracingEnabled(Boolean requestTracingEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withRequestTracingEnabled(requestTracingEnabled);
        return this;
    }

    /**
     * Get the requestTracingExpirationTime property: Request tracing expiration time.
     * 
     * @return the requestTracingExpirationTime value.
     */
    public OffsetDateTime requestTracingExpirationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().requestTracingExpirationTime();
    }

    /**
     * Set the requestTracingExpirationTime property: Request tracing expiration time.
     * 
     * @param requestTracingExpirationTime the requestTracingExpirationTime value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withRequestTracingExpirationTime(OffsetDateTime requestTracingExpirationTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withRequestTracingExpirationTime(requestTracingExpirationTime);
        return this;
    }

    /**
     * Get the remoteDebuggingEnabled property: &lt;code&gt;true&lt;/code&gt; if remote debugging is enabled; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the remoteDebuggingEnabled value.
     */
    public Boolean remoteDebuggingEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().remoteDebuggingEnabled();
    }

    /**
     * Set the remoteDebuggingEnabled property: &lt;code&gt;true&lt;/code&gt; if remote debugging is enabled; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @param remoteDebuggingEnabled the remoteDebuggingEnabled value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withRemoteDebuggingEnabled(Boolean remoteDebuggingEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withRemoteDebuggingEnabled(remoteDebuggingEnabled);
        return this;
    }

    /**
     * Get the remoteDebuggingVersion property: Remote debugging version.
     * 
     * @return the remoteDebuggingVersion value.
     */
    public String remoteDebuggingVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().remoteDebuggingVersion();
    }

    /**
     * Set the remoteDebuggingVersion property: Remote debugging version.
     * 
     * @param remoteDebuggingVersion the remoteDebuggingVersion value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withRemoteDebuggingVersion(String remoteDebuggingVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withRemoteDebuggingVersion(remoteDebuggingVersion);
        return this;
    }

    /**
     * Get the httpLoggingEnabled property: &lt;code&gt;true&lt;/code&gt; if HTTP logging is enabled; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the httpLoggingEnabled value.
     */
    public Boolean httpLoggingEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().httpLoggingEnabled();
    }

    /**
     * Set the httpLoggingEnabled property: &lt;code&gt;true&lt;/code&gt; if HTTP logging is enabled; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @param httpLoggingEnabled the httpLoggingEnabled value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withHttpLoggingEnabled(Boolean httpLoggingEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withHttpLoggingEnabled(httpLoggingEnabled);
        return this;
    }

    /**
     * Get the acrUseManagedIdentityCreds property: Flag to use Managed Identity Creds for ACR pull.
     * 
     * @return the acrUseManagedIdentityCreds value.
     */
    public Boolean acrUseManagedIdentityCreds() {
        return this.innerProperties() == null ? null : this.innerProperties().acrUseManagedIdentityCreds();
    }

    /**
     * Set the acrUseManagedIdentityCreds property: Flag to use Managed Identity Creds for ACR pull.
     * 
     * @param acrUseManagedIdentityCreds the acrUseManagedIdentityCreds value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withAcrUseManagedIdentityCreds(Boolean acrUseManagedIdentityCreds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withAcrUseManagedIdentityCreds(acrUseManagedIdentityCreds);
        return this;
    }

    /**
     * Get the acrUserManagedIdentityId property: If using user managed identity, the user managed identity ClientId.
     * 
     * @return the acrUserManagedIdentityId value.
     */
    public String acrUserManagedIdentityId() {
        return this.innerProperties() == null ? null : this.innerProperties().acrUserManagedIdentityId();
    }

    /**
     * Set the acrUserManagedIdentityId property: If using user managed identity, the user managed identity ClientId.
     * 
     * @param acrUserManagedIdentityId the acrUserManagedIdentityId value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withAcrUserManagedIdentityId(String acrUserManagedIdentityId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withAcrUserManagedIdentityId(acrUserManagedIdentityId);
        return this;
    }

    /**
     * Get the logsDirectorySizeLimit property: HTTP logs directory size limit.
     * 
     * @return the logsDirectorySizeLimit value.
     */
    public Integer logsDirectorySizeLimit() {
        return this.innerProperties() == null ? null : this.innerProperties().logsDirectorySizeLimit();
    }

    /**
     * Set the logsDirectorySizeLimit property: HTTP logs directory size limit.
     * 
     * @param logsDirectorySizeLimit the logsDirectorySizeLimit value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withLogsDirectorySizeLimit(Integer logsDirectorySizeLimit) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withLogsDirectorySizeLimit(logsDirectorySizeLimit);
        return this;
    }

    /**
     * Get the detailedErrorLoggingEnabled property: &lt;code&gt;true&lt;/code&gt; if detailed error logging is enabled;
     * otherwise, &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the detailedErrorLoggingEnabled value.
     */
    public Boolean detailedErrorLoggingEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().detailedErrorLoggingEnabled();
    }

    /**
     * Set the detailedErrorLoggingEnabled property: &lt;code&gt;true&lt;/code&gt; if detailed error logging is enabled;
     * otherwise, &lt;code&gt;false&lt;/code&gt;.
     * 
     * @param detailedErrorLoggingEnabled the detailedErrorLoggingEnabled value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withDetailedErrorLoggingEnabled(Boolean detailedErrorLoggingEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withDetailedErrorLoggingEnabled(detailedErrorLoggingEnabled);
        return this;
    }

    /**
     * Get the publishingUsername property: Publishing user name.
     * 
     * @return the publishingUsername value.
     */
    public String publishingUsername() {
        return this.innerProperties() == null ? null : this.innerProperties().publishingUsername();
    }

    /**
     * Set the publishingUsername property: Publishing user name.
     * 
     * @param publishingUsername the publishingUsername value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withPublishingUsername(String publishingUsername) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withPublishingUsername(publishingUsername);
        return this;
    }

    /**
     * Get the appSettings property: Application settings. This property is not returned in response to normal create
     * and read requests since it may contain sensitive information.
     * 
     * @return the appSettings value.
     */
    public List<NameValuePair> appSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().appSettings();
    }

    /**
     * Set the appSettings property: Application settings. This property is not returned in response to normal create
     * and read requests since it may contain sensitive information.
     * 
     * @param appSettings the appSettings value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withAppSettings(List<NameValuePair> appSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withAppSettings(appSettings);
        return this;
    }

    /**
     * Get the metadata property: Application metadata. This property cannot be retrieved, since it may contain secrets.
     * 
     * @return the metadata value.
     */
    public List<NameValuePair> metadata() {
        return this.innerProperties() == null ? null : this.innerProperties().metadata();
    }

    /**
     * Set the metadata property: Application metadata. This property cannot be retrieved, since it may contain secrets.
     * 
     * @param metadata the metadata value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withMetadata(List<NameValuePair> metadata) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withMetadata(metadata);
        return this;
    }

    /**
     * Get the connectionStrings property: Connection strings. This property is not returned in response to normal
     * create and read requests since it may contain sensitive information.
     * 
     * @return the connectionStrings value.
     */
    public List<ConnStringInfo> connectionStrings() {
        return this.innerProperties() == null ? null : this.innerProperties().connectionStrings();
    }

    /**
     * Set the connectionStrings property: Connection strings. This property is not returned in response to normal
     * create and read requests since it may contain sensitive information.
     * 
     * @param connectionStrings the connectionStrings value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withConnectionStrings(List<ConnStringInfo> connectionStrings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withConnectionStrings(connectionStrings);
        return this;
    }

    /**
     * Get the machineKey property: Site MachineKey.
     * 
     * @return the machineKey value.
     */
    public SiteMachineKey machineKey() {
        return this.innerProperties() == null ? null : this.innerProperties().machineKey();
    }

    /**
     * Get the handlerMappings property: Handler mappings.
     * 
     * @return the handlerMappings value.
     */
    public List<HandlerMapping> handlerMappings() {
        return this.innerProperties() == null ? null : this.innerProperties().handlerMappings();
    }

    /**
     * Set the handlerMappings property: Handler mappings.
     * 
     * @param handlerMappings the handlerMappings value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withHandlerMappings(List<HandlerMapping> handlerMappings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withHandlerMappings(handlerMappings);
        return this;
    }

    /**
     * Get the documentRoot property: Document root.
     * 
     * @return the documentRoot value.
     */
    public String documentRoot() {
        return this.innerProperties() == null ? null : this.innerProperties().documentRoot();
    }

    /**
     * Set the documentRoot property: Document root.
     * 
     * @param documentRoot the documentRoot value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withDocumentRoot(String documentRoot) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withDocumentRoot(documentRoot);
        return this;
    }

    /**
     * Get the scmType property: SCM type.
     * 
     * @return the scmType value.
     */
    public ScmType scmType() {
        return this.innerProperties() == null ? null : this.innerProperties().scmType();
    }

    /**
     * Set the scmType property: SCM type.
     * 
     * @param scmType the scmType value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withScmType(ScmType scmType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withScmType(scmType);
        return this;
    }

    /**
     * Get the use32BitWorkerProcess property: &lt;code&gt;true&lt;/code&gt; to use 32-bit worker process; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the use32BitWorkerProcess value.
     */
    public Boolean use32BitWorkerProcess() {
        return this.innerProperties() == null ? null : this.innerProperties().use32BitWorkerProcess();
    }

    /**
     * Set the use32BitWorkerProcess property: &lt;code&gt;true&lt;/code&gt; to use 32-bit worker process; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @param use32BitWorkerProcess the use32BitWorkerProcess value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withUse32BitWorkerProcess(Boolean use32BitWorkerProcess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withUse32BitWorkerProcess(use32BitWorkerProcess);
        return this;
    }

    /**
     * Get the webSocketsEnabled property: &lt;code&gt;true&lt;/code&gt; if WebSocket is enabled; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the webSocketsEnabled value.
     */
    public Boolean webSocketsEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().webSocketsEnabled();
    }

    /**
     * Set the webSocketsEnabled property: &lt;code&gt;true&lt;/code&gt; if WebSocket is enabled; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @param webSocketsEnabled the webSocketsEnabled value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withWebSocketsEnabled(Boolean webSocketsEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withWebSocketsEnabled(webSocketsEnabled);
        return this;
    }

    /**
     * Get the alwaysOn property: &lt;code&gt;true&lt;/code&gt; if Always On is enabled; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the alwaysOn value.
     */
    public Boolean alwaysOn() {
        return this.innerProperties() == null ? null : this.innerProperties().alwaysOn();
    }

    /**
     * Set the alwaysOn property: &lt;code&gt;true&lt;/code&gt; if Always On is enabled; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @param alwaysOn the alwaysOn value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withAlwaysOn(Boolean alwaysOn) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withAlwaysOn(alwaysOn);
        return this;
    }

    /**
     * Get the javaVersion property: Java version.
     * 
     * @return the javaVersion value.
     */
    public String javaVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().javaVersion();
    }

    /**
     * Set the javaVersion property: Java version.
     * 
     * @param javaVersion the javaVersion value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withJavaVersion(String javaVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withJavaVersion(javaVersion);
        return this;
    }

    /**
     * Get the javaContainer property: Java container.
     * 
     * @return the javaContainer value.
     */
    public String javaContainer() {
        return this.innerProperties() == null ? null : this.innerProperties().javaContainer();
    }

    /**
     * Set the javaContainer property: Java container.
     * 
     * @param javaContainer the javaContainer value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withJavaContainer(String javaContainer) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withJavaContainer(javaContainer);
        return this;
    }

    /**
     * Get the javaContainerVersion property: Java container version.
     * 
     * @return the javaContainerVersion value.
     */
    public String javaContainerVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().javaContainerVersion();
    }

    /**
     * Set the javaContainerVersion property: Java container version.
     * 
     * @param javaContainerVersion the javaContainerVersion value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withJavaContainerVersion(String javaContainerVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withJavaContainerVersion(javaContainerVersion);
        return this;
    }

    /**
     * Get the appCommandLine property: App command line to launch.
     * 
     * @return the appCommandLine value.
     */
    public String appCommandLine() {
        return this.innerProperties() == null ? null : this.innerProperties().appCommandLine();
    }

    /**
     * Set the appCommandLine property: App command line to launch.
     * 
     * @param appCommandLine the appCommandLine value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withAppCommandLine(String appCommandLine) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withAppCommandLine(appCommandLine);
        return this;
    }

    /**
     * Get the managedPipelineMode property: Managed pipeline mode.
     * 
     * @return the managedPipelineMode value.
     */
    public ManagedPipelineMode managedPipelineMode() {
        return this.innerProperties() == null ? null : this.innerProperties().managedPipelineMode();
    }

    /**
     * Set the managedPipelineMode property: Managed pipeline mode.
     * 
     * @param managedPipelineMode the managedPipelineMode value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withManagedPipelineMode(ManagedPipelineMode managedPipelineMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withManagedPipelineMode(managedPipelineMode);
        return this;
    }

    /**
     * Get the virtualApplications property: Virtual applications.
     * 
     * @return the virtualApplications value.
     */
    public List<VirtualApplication> virtualApplications() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualApplications();
    }

    /**
     * Set the virtualApplications property: Virtual applications.
     * 
     * @param virtualApplications the virtualApplications value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withVirtualApplications(List<VirtualApplication> virtualApplications) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withVirtualApplications(virtualApplications);
        return this;
    }

    /**
     * Get the loadBalancing property: Site load balancing.
     * 
     * @return the loadBalancing value.
     */
    public SiteLoadBalancing loadBalancing() {
        return this.innerProperties() == null ? null : this.innerProperties().loadBalancing();
    }

    /**
     * Set the loadBalancing property: Site load balancing.
     * 
     * @param loadBalancing the loadBalancing value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withLoadBalancing(SiteLoadBalancing loadBalancing) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withLoadBalancing(loadBalancing);
        return this;
    }

    /**
     * Get the experiments property: This is work around for polymorphic types.
     * 
     * @return the experiments value.
     */
    public Experiments experiments() {
        return this.innerProperties() == null ? null : this.innerProperties().experiments();
    }

    /**
     * Set the experiments property: This is work around for polymorphic types.
     * 
     * @param experiments the experiments value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withExperiments(Experiments experiments) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withExperiments(experiments);
        return this;
    }

    /**
     * Get the limits property: Site limits.
     * 
     * @return the limits value.
     */
    public SiteLimits limits() {
        return this.innerProperties() == null ? null : this.innerProperties().limits();
    }

    /**
     * Set the limits property: Site limits.
     * 
     * @param limits the limits value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withLimits(SiteLimits limits) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withLimits(limits);
        return this;
    }

    /**
     * Get the autoHealEnabled property: &lt;code&gt;true&lt;/code&gt; if Auto Heal is enabled; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the autoHealEnabled value.
     */
    public Boolean autoHealEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().autoHealEnabled();
    }

    /**
     * Set the autoHealEnabled property: &lt;code&gt;true&lt;/code&gt; if Auto Heal is enabled; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @param autoHealEnabled the autoHealEnabled value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withAutoHealEnabled(Boolean autoHealEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withAutoHealEnabled(autoHealEnabled);
        return this;
    }

    /**
     * Get the autoHealRules property: Auto Heal rules.
     * 
     * @return the autoHealRules value.
     */
    public AutoHealRules autoHealRules() {
        return this.innerProperties() == null ? null : this.innerProperties().autoHealRules();
    }

    /**
     * Set the autoHealRules property: Auto Heal rules.
     * 
     * @param autoHealRules the autoHealRules value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withAutoHealRules(AutoHealRules autoHealRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withAutoHealRules(autoHealRules);
        return this;
    }

    /**
     * Get the tracingOptions property: Tracing options.
     * 
     * @return the tracingOptions value.
     */
    public String tracingOptions() {
        return this.innerProperties() == null ? null : this.innerProperties().tracingOptions();
    }

    /**
     * Set the tracingOptions property: Tracing options.
     * 
     * @param tracingOptions the tracingOptions value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withTracingOptions(String tracingOptions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withTracingOptions(tracingOptions);
        return this;
    }

    /**
     * Get the vnetName property: Virtual Network name.
     * 
     * @return the vnetName value.
     */
    public String vnetName() {
        return this.innerProperties() == null ? null : this.innerProperties().vnetName();
    }

    /**
     * Set the vnetName property: Virtual Network name.
     * 
     * @param vnetName the vnetName value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withVnetName(String vnetName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withVnetName(vnetName);
        return this;
    }

    /**
     * Get the vnetRouteAllEnabled property: Virtual Network Route All enabled. This causes all outbound traffic to have
     * Virtual Network Security Groups and User Defined Routes applied.
     * 
     * @return the vnetRouteAllEnabled value.
     */
    public Boolean vnetRouteAllEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().vnetRouteAllEnabled();
    }

    /**
     * Set the vnetRouteAllEnabled property: Virtual Network Route All enabled. This causes all outbound traffic to have
     * Virtual Network Security Groups and User Defined Routes applied.
     * 
     * @param vnetRouteAllEnabled the vnetRouteAllEnabled value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withVnetRouteAllEnabled(Boolean vnetRouteAllEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withVnetRouteAllEnabled(vnetRouteAllEnabled);
        return this;
    }

    /**
     * Get the vnetPrivatePortsCount property: The number of private ports assigned to this app. These will be assigned
     * dynamically on runtime.
     * 
     * @return the vnetPrivatePortsCount value.
     */
    public Integer vnetPrivatePortsCount() {
        return this.innerProperties() == null ? null : this.innerProperties().vnetPrivatePortsCount();
    }

    /**
     * Set the vnetPrivatePortsCount property: The number of private ports assigned to this app. These will be assigned
     * dynamically on runtime.
     * 
     * @param vnetPrivatePortsCount the vnetPrivatePortsCount value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withVnetPrivatePortsCount(Integer vnetPrivatePortsCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withVnetPrivatePortsCount(vnetPrivatePortsCount);
        return this;
    }

    /**
     * Get the cors property: Cross-Origin Resource Sharing (CORS) settings.
     * 
     * @return the cors value.
     */
    public CorsSettings cors() {
        return this.innerProperties() == null ? null : this.innerProperties().cors();
    }

    /**
     * Set the cors property: Cross-Origin Resource Sharing (CORS) settings.
     * 
     * @param cors the cors value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withCors(CorsSettings cors) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withCors(cors);
        return this;
    }

    /**
     * Get the push property: Push endpoint settings.
     * 
     * @return the push value.
     */
    public PushSettingsInner push() {
        return this.innerProperties() == null ? null : this.innerProperties().push();
    }

    /**
     * Set the push property: Push endpoint settings.
     * 
     * @param push the push value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withPush(PushSettingsInner push) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withPush(push);
        return this;
    }

    /**
     * Get the apiDefinition property: Information about the formal API definition for the app.
     * 
     * @return the apiDefinition value.
     */
    public ApiDefinitionInfo apiDefinition() {
        return this.innerProperties() == null ? null : this.innerProperties().apiDefinition();
    }

    /**
     * Set the apiDefinition property: Information about the formal API definition for the app.
     * 
     * @param apiDefinition the apiDefinition value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withApiDefinition(ApiDefinitionInfo apiDefinition) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withApiDefinition(apiDefinition);
        return this;
    }

    /**
     * Get the apiManagementConfig property: Azure API management settings linked to the app.
     * 
     * @return the apiManagementConfig value.
     */
    public ApiManagementConfig apiManagementConfig() {
        return this.innerProperties() == null ? null : this.innerProperties().apiManagementConfig();
    }

    /**
     * Set the apiManagementConfig property: Azure API management settings linked to the app.
     * 
     * @param apiManagementConfig the apiManagementConfig value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withApiManagementConfig(ApiManagementConfig apiManagementConfig) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withApiManagementConfig(apiManagementConfig);
        return this;
    }

    /**
     * Get the autoSwapSlotName property: Auto-swap slot name.
     * 
     * @return the autoSwapSlotName value.
     */
    public String autoSwapSlotName() {
        return this.innerProperties() == null ? null : this.innerProperties().autoSwapSlotName();
    }

    /**
     * Set the autoSwapSlotName property: Auto-swap slot name.
     * 
     * @param autoSwapSlotName the autoSwapSlotName value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withAutoSwapSlotName(String autoSwapSlotName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withAutoSwapSlotName(autoSwapSlotName);
        return this;
    }

    /**
     * Get the localMySqlEnabled property: &lt;code&gt;true&lt;/code&gt; to enable local MySQL; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the localMySqlEnabled value.
     */
    public Boolean localMySqlEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().localMySqlEnabled();
    }

    /**
     * Set the localMySqlEnabled property: &lt;code&gt;true&lt;/code&gt; to enable local MySQL; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @param localMySqlEnabled the localMySqlEnabled value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withLocalMySqlEnabled(Boolean localMySqlEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withLocalMySqlEnabled(localMySqlEnabled);
        return this;
    }

    /**
     * Get the managedServiceIdentityId property: Managed Service Identity Id.
     * 
     * @return the managedServiceIdentityId value.
     */
    public Integer managedServiceIdentityId() {
        return this.innerProperties() == null ? null : this.innerProperties().managedServiceIdentityId();
    }

    /**
     * Set the managedServiceIdentityId property: Managed Service Identity Id.
     * 
     * @param managedServiceIdentityId the managedServiceIdentityId value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withManagedServiceIdentityId(Integer managedServiceIdentityId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withManagedServiceIdentityId(managedServiceIdentityId);
        return this;
    }

    /**
     * Get the xManagedServiceIdentityId property: Explicit Managed Service Identity Id.
     * 
     * @return the xManagedServiceIdentityId value.
     */
    public Integer xManagedServiceIdentityId() {
        return this.innerProperties() == null ? null : this.innerProperties().xManagedServiceIdentityId();
    }

    /**
     * Set the xManagedServiceIdentityId property: Explicit Managed Service Identity Id.
     * 
     * @param xManagedServiceIdentityId the xManagedServiceIdentityId value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withXManagedServiceIdentityId(Integer xManagedServiceIdentityId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withXManagedServiceIdentityId(xManagedServiceIdentityId);
        return this;
    }

    /**
     * Get the keyVaultReferenceIdentity property: Identity to use for Key Vault Reference authentication.
     * 
     * @return the keyVaultReferenceIdentity value.
     */
    public String keyVaultReferenceIdentity() {
        return this.innerProperties() == null ? null : this.innerProperties().keyVaultReferenceIdentity();
    }

    /**
     * Set the keyVaultReferenceIdentity property: Identity to use for Key Vault Reference authentication.
     * 
     * @param keyVaultReferenceIdentity the keyVaultReferenceIdentity value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withKeyVaultReferenceIdentity(String keyVaultReferenceIdentity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withKeyVaultReferenceIdentity(keyVaultReferenceIdentity);
        return this;
    }

    /**
     * Get the ipSecurityRestrictions property: IP security restrictions for main.
     * 
     * @return the ipSecurityRestrictions value.
     */
    public List<IpSecurityRestriction> ipSecurityRestrictions() {
        return this.innerProperties() == null ? null : this.innerProperties().ipSecurityRestrictions();
    }

    /**
     * Set the ipSecurityRestrictions property: IP security restrictions for main.
     * 
     * @param ipSecurityRestrictions the ipSecurityRestrictions value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withIpSecurityRestrictions(List<IpSecurityRestriction> ipSecurityRestrictions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withIpSecurityRestrictions(ipSecurityRestrictions);
        return this;
    }

    /**
     * Get the ipSecurityRestrictionsDefaultAction property: Default action for main access restriction if no rules are
     * matched.
     * 
     * @return the ipSecurityRestrictionsDefaultAction value.
     */
    public DefaultAction ipSecurityRestrictionsDefaultAction() {
        return this.innerProperties() == null ? null : this.innerProperties().ipSecurityRestrictionsDefaultAction();
    }

    /**
     * Set the ipSecurityRestrictionsDefaultAction property: Default action for main access restriction if no rules are
     * matched.
     * 
     * @param ipSecurityRestrictionsDefaultAction the ipSecurityRestrictionsDefaultAction value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner
        withIpSecurityRestrictionsDefaultAction(DefaultAction ipSecurityRestrictionsDefaultAction) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withIpSecurityRestrictionsDefaultAction(ipSecurityRestrictionsDefaultAction);
        return this;
    }

    /**
     * Get the scmIpSecurityRestrictions property: IP security restrictions for scm.
     * 
     * @return the scmIpSecurityRestrictions value.
     */
    public List<IpSecurityRestriction> scmIpSecurityRestrictions() {
        return this.innerProperties() == null ? null : this.innerProperties().scmIpSecurityRestrictions();
    }

    /**
     * Set the scmIpSecurityRestrictions property: IP security restrictions for scm.
     * 
     * @param scmIpSecurityRestrictions the scmIpSecurityRestrictions value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner
        withScmIpSecurityRestrictions(List<IpSecurityRestriction> scmIpSecurityRestrictions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withScmIpSecurityRestrictions(scmIpSecurityRestrictions);
        return this;
    }

    /**
     * Get the scmIpSecurityRestrictionsDefaultAction property: Default action for scm access restriction if no rules
     * are matched.
     * 
     * @return the scmIpSecurityRestrictionsDefaultAction value.
     */
    public DefaultAction scmIpSecurityRestrictionsDefaultAction() {
        return this.innerProperties() == null ? null : this.innerProperties().scmIpSecurityRestrictionsDefaultAction();
    }

    /**
     * Set the scmIpSecurityRestrictionsDefaultAction property: Default action for scm access restriction if no rules
     * are matched.
     * 
     * @param scmIpSecurityRestrictionsDefaultAction the scmIpSecurityRestrictionsDefaultAction value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner
        withScmIpSecurityRestrictionsDefaultAction(DefaultAction scmIpSecurityRestrictionsDefaultAction) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withScmIpSecurityRestrictionsDefaultAction(scmIpSecurityRestrictionsDefaultAction);
        return this;
    }

    /**
     * Get the scmIpSecurityRestrictionsUseMain property: IP security restrictions for scm to use main.
     * 
     * @return the scmIpSecurityRestrictionsUseMain value.
     */
    public Boolean scmIpSecurityRestrictionsUseMain() {
        return this.innerProperties() == null ? null : this.innerProperties().scmIpSecurityRestrictionsUseMain();
    }

    /**
     * Set the scmIpSecurityRestrictionsUseMain property: IP security restrictions for scm to use main.
     * 
     * @param scmIpSecurityRestrictionsUseMain the scmIpSecurityRestrictionsUseMain value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withScmIpSecurityRestrictionsUseMain(Boolean scmIpSecurityRestrictionsUseMain) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withScmIpSecurityRestrictionsUseMain(scmIpSecurityRestrictionsUseMain);
        return this;
    }

    /**
     * Get the http20Enabled property: Http20Enabled: configures a web site to allow clients to connect over http2.0.
     * 
     * @return the http20Enabled value.
     */
    public Boolean http20Enabled() {
        return this.innerProperties() == null ? null : this.innerProperties().http20Enabled();
    }

    /**
     * Set the http20Enabled property: Http20Enabled: configures a web site to allow clients to connect over http2.0.
     * 
     * @param http20Enabled the http20Enabled value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withHttp20Enabled(Boolean http20Enabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withHttp20Enabled(http20Enabled);
        return this;
    }

    /**
     * Get the http20ProxyFlag property: Http20ProxyFlag: Configures a website to allow http2.0 to pass be proxied all
     * the way to the app. 0 = disabled, 1 = pass through all http2 traffic, 2 = pass through gRPC only.
     * 
     * @return the http20ProxyFlag value.
     */
    public Integer http20ProxyFlag() {
        return this.innerProperties() == null ? null : this.innerProperties().http20ProxyFlag();
    }

    /**
     * Set the http20ProxyFlag property: Http20ProxyFlag: Configures a website to allow http2.0 to pass be proxied all
     * the way to the app. 0 = disabled, 1 = pass through all http2 traffic, 2 = pass through gRPC only.
     * 
     * @param http20ProxyFlag the http20ProxyFlag value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withHttp20ProxyFlag(Integer http20ProxyFlag) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withHttp20ProxyFlag(http20ProxyFlag);
        return this;
    }

    /**
     * Get the minTlsVersion property: MinTlsVersion: configures the minimum version of TLS required for SSL requests.
     * 
     * @return the minTlsVersion value.
     */
    public SupportedTlsVersions minTlsVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().minTlsVersion();
    }

    /**
     * Set the minTlsVersion property: MinTlsVersion: configures the minimum version of TLS required for SSL requests.
     * 
     * @param minTlsVersion the minTlsVersion value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withMinTlsVersion(SupportedTlsVersions minTlsVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withMinTlsVersion(minTlsVersion);
        return this;
    }

    /**
     * Get the minTlsCipherSuite property: The minimum strength TLS cipher suite allowed for an application.
     * 
     * @return the minTlsCipherSuite value.
     */
    public TlsCipherSuites minTlsCipherSuite() {
        return this.innerProperties() == null ? null : this.innerProperties().minTlsCipherSuite();
    }

    /**
     * Set the minTlsCipherSuite property: The minimum strength TLS cipher suite allowed for an application.
     * 
     * @param minTlsCipherSuite the minTlsCipherSuite value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withMinTlsCipherSuite(TlsCipherSuites minTlsCipherSuite) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withMinTlsCipherSuite(minTlsCipherSuite);
        return this;
    }

    /**
     * Get the scmMinTlsVersion property: ScmMinTlsVersion: configures the minimum version of TLS required for SSL
     * requests for SCM site.
     * 
     * @return the scmMinTlsVersion value.
     */
    public SupportedTlsVersions scmMinTlsVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().scmMinTlsVersion();
    }

    /**
     * Set the scmMinTlsVersion property: ScmMinTlsVersion: configures the minimum version of TLS required for SSL
     * requests for SCM site.
     * 
     * @param scmMinTlsVersion the scmMinTlsVersion value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withScmMinTlsVersion(SupportedTlsVersions scmMinTlsVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withScmMinTlsVersion(scmMinTlsVersion);
        return this;
    }

    /**
     * Get the ftpsState property: State of FTP / FTPS service.
     * 
     * @return the ftpsState value.
     */
    public FtpsState ftpsState() {
        return this.innerProperties() == null ? null : this.innerProperties().ftpsState();
    }

    /**
     * Set the ftpsState property: State of FTP / FTPS service.
     * 
     * @param ftpsState the ftpsState value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withFtpsState(FtpsState ftpsState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withFtpsState(ftpsState);
        return this;
    }

    /**
     * Get the preWarmedInstanceCount property: Number of preWarmed instances.
     * This setting only applies to the Consumption and Elastic Plans.
     * 
     * @return the preWarmedInstanceCount value.
     */
    public Integer preWarmedInstanceCount() {
        return this.innerProperties() == null ? null : this.innerProperties().preWarmedInstanceCount();
    }

    /**
     * Set the preWarmedInstanceCount property: Number of preWarmed instances.
     * This setting only applies to the Consumption and Elastic Plans.
     * 
     * @param preWarmedInstanceCount the preWarmedInstanceCount value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withPreWarmedInstanceCount(Integer preWarmedInstanceCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withPreWarmedInstanceCount(preWarmedInstanceCount);
        return this;
    }

    /**
     * Get the functionAppScaleLimit property: Maximum number of workers that a site can scale out to.
     * This setting only applies to the Consumption and Elastic Premium Plans.
     * 
     * @return the functionAppScaleLimit value.
     */
    public Integer functionAppScaleLimit() {
        return this.innerProperties() == null ? null : this.innerProperties().functionAppScaleLimit();
    }

    /**
     * Set the functionAppScaleLimit property: Maximum number of workers that a site can scale out to.
     * This setting only applies to the Consumption and Elastic Premium Plans.
     * 
     * @param functionAppScaleLimit the functionAppScaleLimit value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withFunctionAppScaleLimit(Integer functionAppScaleLimit) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withFunctionAppScaleLimit(functionAppScaleLimit);
        return this;
    }

    /**
     * Get the elasticWebAppScaleLimit property: Maximum number of workers that a site can scale out to.
     * This setting only applies to apps in plans where ElasticScaleEnabled is &lt;code&gt;true&lt;/code&gt;.
     * 
     * @return the elasticWebAppScaleLimit value.
     */
    public Integer elasticWebAppScaleLimit() {
        return this.innerProperties() == null ? null : this.innerProperties().elasticWebAppScaleLimit();
    }

    /**
     * Set the elasticWebAppScaleLimit property: Maximum number of workers that a site can scale out to.
     * This setting only applies to apps in plans where ElasticScaleEnabled is &lt;code&gt;true&lt;/code&gt;.
     * 
     * @param elasticWebAppScaleLimit the elasticWebAppScaleLimit value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withElasticWebAppScaleLimit(Integer elasticWebAppScaleLimit) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withElasticWebAppScaleLimit(elasticWebAppScaleLimit);
        return this;
    }

    /**
     * Get the healthCheckPath property: Health check path.
     * 
     * @return the healthCheckPath value.
     */
    public String healthCheckPath() {
        return this.innerProperties() == null ? null : this.innerProperties().healthCheckPath();
    }

    /**
     * Set the healthCheckPath property: Health check path.
     * 
     * @param healthCheckPath the healthCheckPath value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withHealthCheckPath(String healthCheckPath) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withHealthCheckPath(healthCheckPath);
        return this;
    }

    /**
     * Get the functionsRuntimeScaleMonitoringEnabled property: Gets or sets a value indicating whether functions
     * runtime scale monitoring is enabled. When enabled,
     * the ScaleController will not monitor event sources directly, but will instead call to the
     * runtime to get scale status.
     * 
     * @return the functionsRuntimeScaleMonitoringEnabled value.
     */
    public Boolean functionsRuntimeScaleMonitoringEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().functionsRuntimeScaleMonitoringEnabled();
    }

    /**
     * Set the functionsRuntimeScaleMonitoringEnabled property: Gets or sets a value indicating whether functions
     * runtime scale monitoring is enabled. When enabled,
     * the ScaleController will not monitor event sources directly, but will instead call to the
     * runtime to get scale status.
     * 
     * @param functionsRuntimeScaleMonitoringEnabled the functionsRuntimeScaleMonitoringEnabled value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner
        withFunctionsRuntimeScaleMonitoringEnabled(Boolean functionsRuntimeScaleMonitoringEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withFunctionsRuntimeScaleMonitoringEnabled(functionsRuntimeScaleMonitoringEnabled);
        return this;
    }

    /**
     * Get the websiteTimeZone property: Sets the time zone a site uses for generating timestamps. Compatible with Linux
     * and Windows App Service. Setting the WEBSITE_TIME_ZONE app setting takes precedence over this config. For Linux,
     * expects tz database values https://www.iana.org/time-zones (for a quick reference see
     * https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). For Windows, expects one of the time zones listed
     * under HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones.
     * 
     * @return the websiteTimeZone value.
     */
    public String websiteTimeZone() {
        return this.innerProperties() == null ? null : this.innerProperties().websiteTimeZone();
    }

    /**
     * Set the websiteTimeZone property: Sets the time zone a site uses for generating timestamps. Compatible with Linux
     * and Windows App Service. Setting the WEBSITE_TIME_ZONE app setting takes precedence over this config. For Linux,
     * expects tz database values https://www.iana.org/time-zones (for a quick reference see
     * https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). For Windows, expects one of the time zones listed
     * under HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones.
     * 
     * @param websiteTimeZone the websiteTimeZone value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withWebsiteTimeZone(String websiteTimeZone) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withWebsiteTimeZone(websiteTimeZone);
        return this;
    }

    /**
     * Get the minimumElasticInstanceCount property: Number of minimum instance count for a site
     * This setting only applies to the Elastic Plans.
     * 
     * @return the minimumElasticInstanceCount value.
     */
    public Integer minimumElasticInstanceCount() {
        return this.innerProperties() == null ? null : this.innerProperties().minimumElasticInstanceCount();
    }

    /**
     * Set the minimumElasticInstanceCount property: Number of minimum instance count for a site
     * This setting only applies to the Elastic Plans.
     * 
     * @param minimumElasticInstanceCount the minimumElasticInstanceCount value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withMinimumElasticInstanceCount(Integer minimumElasticInstanceCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withMinimumElasticInstanceCount(minimumElasticInstanceCount);
        return this;
    }

    /**
     * Get the azureStorageAccounts property: List of Azure Storage Accounts.
     * 
     * @return the azureStorageAccounts value.
     */
    public Map<String, AzureStorageInfoValue> azureStorageAccounts() {
        return this.innerProperties() == null ? null : this.innerProperties().azureStorageAccounts();
    }

    /**
     * Set the azureStorageAccounts property: List of Azure Storage Accounts.
     * 
     * @param azureStorageAccounts the azureStorageAccounts value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withAzureStorageAccounts(Map<String, AzureStorageInfoValue> azureStorageAccounts) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withAzureStorageAccounts(azureStorageAccounts);
        return this;
    }

    /**
     * Get the publicNetworkAccess property: Property to allow or block all public traffic.
     * 
     * @return the publicNetworkAccess value.
     */
    public String publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    /**
     * Set the publicNetworkAccess property: Property to allow or block all public traffic.
     * 
     * @param publicNetworkAccess the publicNetworkAccess value to set.
     * @return the SiteConfigResourceInner object itself.
     */
    public SiteConfigResourceInner withPublicNetworkAccess(String publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteConfigInner();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SiteConfigResourceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SiteConfigResourceInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SiteConfigResourceInner.
     */
    public static SiteConfigResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SiteConfigResourceInner deserializedSiteConfigResourceInner = new SiteConfigResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedSiteConfigResourceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedSiteConfigResourceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedSiteConfigResourceInner.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedSiteConfigResourceInner.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedSiteConfigResourceInner.innerProperties = SiteConfigInner.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSiteConfigResourceInner;
        });
    }
}
