// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * RenewCertificateOrderRequest resource specific properties.
 */
@Fluent
public final class RenewCertificateOrderRequestProperties
    implements JsonSerializable<RenewCertificateOrderRequestProperties> {
    /*
     * Certificate Key Size.
     */
    private Integer keySize;

    /*
     * Csr to be used for re-key operation.
     */
    private String csr;

    /*
     * Should we change the ASC type (from managed private key to external private key and vice versa).
     */
    private Boolean isPrivateKeyExternal;

    /**
     * Creates an instance of RenewCertificateOrderRequestProperties class.
     */
    public RenewCertificateOrderRequestProperties() {
    }

    /**
     * Get the keySize property: Certificate Key Size.
     * 
     * @return the keySize value.
     */
    public Integer keySize() {
        return this.keySize;
    }

    /**
     * Set the keySize property: Certificate Key Size.
     * 
     * @param keySize the keySize value to set.
     * @return the RenewCertificateOrderRequestProperties object itself.
     */
    public RenewCertificateOrderRequestProperties withKeySize(Integer keySize) {
        this.keySize = keySize;
        return this;
    }

    /**
     * Get the csr property: Csr to be used for re-key operation.
     * 
     * @return the csr value.
     */
    public String csr() {
        return this.csr;
    }

    /**
     * Set the csr property: Csr to be used for re-key operation.
     * 
     * @param csr the csr value to set.
     * @return the RenewCertificateOrderRequestProperties object itself.
     */
    public RenewCertificateOrderRequestProperties withCsr(String csr) {
        this.csr = csr;
        return this;
    }

    /**
     * Get the isPrivateKeyExternal property: Should we change the ASC type (from managed private key to external
     * private key and vice versa).
     * 
     * @return the isPrivateKeyExternal value.
     */
    public Boolean isPrivateKeyExternal() {
        return this.isPrivateKeyExternal;
    }

    /**
     * Set the isPrivateKeyExternal property: Should we change the ASC type (from managed private key to external
     * private key and vice versa).
     * 
     * @param isPrivateKeyExternal the isPrivateKeyExternal value to set.
     * @return the RenewCertificateOrderRequestProperties object itself.
     */
    public RenewCertificateOrderRequestProperties withIsPrivateKeyExternal(Boolean isPrivateKeyExternal) {
        this.isPrivateKeyExternal = isPrivateKeyExternal;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("keySize", this.keySize);
        jsonWriter.writeStringField("csr", this.csr);
        jsonWriter.writeBooleanField("isPrivateKeyExternal", this.isPrivateKeyExternal);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RenewCertificateOrderRequestProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RenewCertificateOrderRequestProperties if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RenewCertificateOrderRequestProperties.
     */
    public static RenewCertificateOrderRequestProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RenewCertificateOrderRequestProperties deserializedRenewCertificateOrderRequestProperties
                = new RenewCertificateOrderRequestProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("keySize".equals(fieldName)) {
                    deserializedRenewCertificateOrderRequestProperties.keySize = reader.getNullable(JsonReader::getInt);
                } else if ("csr".equals(fieldName)) {
                    deserializedRenewCertificateOrderRequestProperties.csr = reader.getString();
                } else if ("isPrivateKeyExternal".equals(fieldName)) {
                    deserializedRenewCertificateOrderRequestProperties.isPrivateKeyExternal
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRenewCertificateOrderRequestProperties;
        });
    }
}
