// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.Channels;
import com.azure.resourcemanager.appservice.models.NotificationLevel;
import com.azure.resourcemanager.appservice.models.ResourceScopeType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

/**
 * Recommendation resource specific properties.
 */
@Fluent
public final class RecommendationProperties implements JsonSerializable<RecommendationProperties> {
    /*
     * Timestamp when this instance was created.
     */
    private OffsetDateTime creationTime;

    /*
     * A GUID value that each recommendation object is associated with.
     */
    private UUID recommendationId;

    /*
     * Full ARM resource ID string that this recommendation object is associated with.
     */
    private String resourceId;

    /*
     * Name of a resource type this recommendation applies, e.g. Subscription, ServerFarm, Site.
     */
    private ResourceScopeType resourceScope;

    /*
     * Unique name of the rule.
     */
    private String ruleName;

    /*
     * UI friendly name of the rule (may not be unique).
     */
    private String displayName;

    /*
     * Recommendation text.
     */
    private String message;

    /*
     * Level indicating how critical this recommendation can impact.
     */
    private NotificationLevel level;

    /*
     * List of channels that this recommendation can apply.
     */
    private Channels channels;

    /*
     * The list of category tags that this recommendation belongs to.
     */
    private List<String> categoryTags;

    /*
     * Name of action recommended by this object.
     */
    private String actionName;

    /*
     * True if this recommendation is still valid (i.e. "actionable"). False if it is invalid.
     */
    private Integer enabled;

    /*
     * The list of states of this recommendation. If it's null then it should be considered "Active".
     */
    private List<String> states;

    /*
     * The beginning time in UTC of a range that the recommendation refers to.
     */
    private OffsetDateTime startTime;

    /*
     * The end time in UTC of a range that the recommendation refers to.
     */
    private OffsetDateTime endTime;

    /*
     * When to notify this recommendation next in UTC. Null means that this will never be notified anymore.
     */
    private OffsetDateTime nextNotificationTime;

    /*
     * Date and time in UTC when this notification expires.
     */
    private OffsetDateTime notificationExpirationTime;

    /*
     * Last timestamp in UTC this instance was actually notified. Null means that this recommendation hasn't been
     * notified yet.
     */
    private OffsetDateTime notifiedTime;

    /*
     * A metric value measured by the rule.
     */
    private Double score;

    /*
     * True if this is associated with a dynamically added rule
     */
    private Boolean isDynamic;

    /*
     * Extension name of the portal if exists.
     */
    private String extensionName;

    /*
     * Deep link to a blade on the portal.
     */
    private String bladeName;

    /*
     * Forward link to an external document associated with the rule.
     */
    private String forwardLink;

    /**
     * Creates an instance of RecommendationProperties class.
     */
    public RecommendationProperties() {
    }

    /**
     * Get the creationTime property: Timestamp when this instance was created.
     * 
     * @return the creationTime value.
     */
    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    /**
     * Set the creationTime property: Timestamp when this instance was created.
     * 
     * @param creationTime the creationTime value to set.
     * @return the RecommendationProperties object itself.
     */
    public RecommendationProperties withCreationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    /**
     * Get the recommendationId property: A GUID value that each recommendation object is associated with.
     * 
     * @return the recommendationId value.
     */
    public UUID recommendationId() {
        return this.recommendationId;
    }

    /**
     * Set the recommendationId property: A GUID value that each recommendation object is associated with.
     * 
     * @param recommendationId the recommendationId value to set.
     * @return the RecommendationProperties object itself.
     */
    public RecommendationProperties withRecommendationId(UUID recommendationId) {
        this.recommendationId = recommendationId;
        return this;
    }

    /**
     * Get the resourceId property: Full ARM resource ID string that this recommendation object is associated with.
     * 
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.resourceId;
    }

    /**
     * Set the resourceId property: Full ARM resource ID string that this recommendation object is associated with.
     * 
     * @param resourceId the resourceId value to set.
     * @return the RecommendationProperties object itself.
     */
    public RecommendationProperties withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
     * Get the resourceScope property: Name of a resource type this recommendation applies, e.g. Subscription,
     * ServerFarm, Site.
     * 
     * @return the resourceScope value.
     */
    public ResourceScopeType resourceScope() {
        return this.resourceScope;
    }

    /**
     * Set the resourceScope property: Name of a resource type this recommendation applies, e.g. Subscription,
     * ServerFarm, Site.
     * 
     * @param resourceScope the resourceScope value to set.
     * @return the RecommendationProperties object itself.
     */
    public RecommendationProperties withResourceScope(ResourceScopeType resourceScope) {
        this.resourceScope = resourceScope;
        return this;
    }

    /**
     * Get the ruleName property: Unique name of the rule.
     * 
     * @return the ruleName value.
     */
    public String ruleName() {
        return this.ruleName;
    }

    /**
     * Set the ruleName property: Unique name of the rule.
     * 
     * @param ruleName the ruleName value to set.
     * @return the RecommendationProperties object itself.
     */
    public RecommendationProperties withRuleName(String ruleName) {
        this.ruleName = ruleName;
        return this;
    }

    /**
     * Get the displayName property: UI friendly name of the rule (may not be unique).
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: UI friendly name of the rule (may not be unique).
     * 
     * @param displayName the displayName value to set.
     * @return the RecommendationProperties object itself.
     */
    public RecommendationProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the message property: Recommendation text.
     * 
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Set the message property: Recommendation text.
     * 
     * @param message the message value to set.
     * @return the RecommendationProperties object itself.
     */
    public RecommendationProperties withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Get the level property: Level indicating how critical this recommendation can impact.
     * 
     * @return the level value.
     */
    public NotificationLevel level() {
        return this.level;
    }

    /**
     * Set the level property: Level indicating how critical this recommendation can impact.
     * 
     * @param level the level value to set.
     * @return the RecommendationProperties object itself.
     */
    public RecommendationProperties withLevel(NotificationLevel level) {
        this.level = level;
        return this;
    }

    /**
     * Get the channels property: List of channels that this recommendation can apply.
     * 
     * @return the channels value.
     */
    public Channels channels() {
        return this.channels;
    }

    /**
     * Set the channels property: List of channels that this recommendation can apply.
     * 
     * @param channels the channels value to set.
     * @return the RecommendationProperties object itself.
     */
    public RecommendationProperties withChannels(Channels channels) {
        this.channels = channels;
        return this;
    }

    /**
     * Get the categoryTags property: The list of category tags that this recommendation belongs to.
     * 
     * @return the categoryTags value.
     */
    public List<String> categoryTags() {
        return this.categoryTags;
    }

    /**
     * Get the actionName property: Name of action recommended by this object.
     * 
     * @return the actionName value.
     */
    public String actionName() {
        return this.actionName;
    }

    /**
     * Set the actionName property: Name of action recommended by this object.
     * 
     * @param actionName the actionName value to set.
     * @return the RecommendationProperties object itself.
     */
    public RecommendationProperties withActionName(String actionName) {
        this.actionName = actionName;
        return this;
    }

    /**
     * Get the enabled property: True if this recommendation is still valid (i.e. "actionable"). False if it is invalid.
     * 
     * @return the enabled value.
     */
    public Integer enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: True if this recommendation is still valid (i.e. "actionable"). False if it is invalid.
     * 
     * @param enabled the enabled value to set.
     * @return the RecommendationProperties object itself.
     */
    public RecommendationProperties withEnabled(Integer enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the states property: The list of states of this recommendation. If it's null then it should be considered
     * "Active".
     * 
     * @return the states value.
     */
    public List<String> states() {
        return this.states;
    }

    /**
     * Set the states property: The list of states of this recommendation. If it's null then it should be considered
     * "Active".
     * 
     * @param states the states value to set.
     * @return the RecommendationProperties object itself.
     */
    public RecommendationProperties withStates(List<String> states) {
        this.states = states;
        return this;
    }

    /**
     * Get the startTime property: The beginning time in UTC of a range that the recommendation refers to.
     * 
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    /**
     * Set the startTime property: The beginning time in UTC of a range that the recommendation refers to.
     * 
     * @param startTime the startTime value to set.
     * @return the RecommendationProperties object itself.
     */
    public RecommendationProperties withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the endTime property: The end time in UTC of a range that the recommendation refers to.
     * 
     * @return the endTime value.
     */
    public OffsetDateTime endTime() {
        return this.endTime;
    }

    /**
     * Set the endTime property: The end time in UTC of a range that the recommendation refers to.
     * 
     * @param endTime the endTime value to set.
     * @return the RecommendationProperties object itself.
     */
    public RecommendationProperties withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    /**
     * Get the nextNotificationTime property: When to notify this recommendation next in UTC. Null means that this will
     * never be notified anymore.
     * 
     * @return the nextNotificationTime value.
     */
    public OffsetDateTime nextNotificationTime() {
        return this.nextNotificationTime;
    }

    /**
     * Set the nextNotificationTime property: When to notify this recommendation next in UTC. Null means that this will
     * never be notified anymore.
     * 
     * @param nextNotificationTime the nextNotificationTime value to set.
     * @return the RecommendationProperties object itself.
     */
    public RecommendationProperties withNextNotificationTime(OffsetDateTime nextNotificationTime) {
        this.nextNotificationTime = nextNotificationTime;
        return this;
    }

    /**
     * Get the notificationExpirationTime property: Date and time in UTC when this notification expires.
     * 
     * @return the notificationExpirationTime value.
     */
    public OffsetDateTime notificationExpirationTime() {
        return this.notificationExpirationTime;
    }

    /**
     * Set the notificationExpirationTime property: Date and time in UTC when this notification expires.
     * 
     * @param notificationExpirationTime the notificationExpirationTime value to set.
     * @return the RecommendationProperties object itself.
     */
    public RecommendationProperties withNotificationExpirationTime(OffsetDateTime notificationExpirationTime) {
        this.notificationExpirationTime = notificationExpirationTime;
        return this;
    }

    /**
     * Get the notifiedTime property: Last timestamp in UTC this instance was actually notified. Null means that this
     * recommendation hasn't been notified yet.
     * 
     * @return the notifiedTime value.
     */
    public OffsetDateTime notifiedTime() {
        return this.notifiedTime;
    }

    /**
     * Set the notifiedTime property: Last timestamp in UTC this instance was actually notified. Null means that this
     * recommendation hasn't been notified yet.
     * 
     * @param notifiedTime the notifiedTime value to set.
     * @return the RecommendationProperties object itself.
     */
    public RecommendationProperties withNotifiedTime(OffsetDateTime notifiedTime) {
        this.notifiedTime = notifiedTime;
        return this;
    }

    /**
     * Get the score property: A metric value measured by the rule.
     * 
     * @return the score value.
     */
    public Double score() {
        return this.score;
    }

    /**
     * Set the score property: A metric value measured by the rule.
     * 
     * @param score the score value to set.
     * @return the RecommendationProperties object itself.
     */
    public RecommendationProperties withScore(Double score) {
        this.score = score;
        return this;
    }

    /**
     * Get the isDynamic property: True if this is associated with a dynamically added rule.
     * 
     * @return the isDynamic value.
     */
    public Boolean isDynamic() {
        return this.isDynamic;
    }

    /**
     * Set the isDynamic property: True if this is associated with a dynamically added rule.
     * 
     * @param isDynamic the isDynamic value to set.
     * @return the RecommendationProperties object itself.
     */
    public RecommendationProperties withIsDynamic(Boolean isDynamic) {
        this.isDynamic = isDynamic;
        return this;
    }

    /**
     * Get the extensionName property: Extension name of the portal if exists.
     * 
     * @return the extensionName value.
     */
    public String extensionName() {
        return this.extensionName;
    }

    /**
     * Set the extensionName property: Extension name of the portal if exists.
     * 
     * @param extensionName the extensionName value to set.
     * @return the RecommendationProperties object itself.
     */
    public RecommendationProperties withExtensionName(String extensionName) {
        this.extensionName = extensionName;
        return this;
    }

    /**
     * Get the bladeName property: Deep link to a blade on the portal.
     * 
     * @return the bladeName value.
     */
    public String bladeName() {
        return this.bladeName;
    }

    /**
     * Set the bladeName property: Deep link to a blade on the portal.
     * 
     * @param bladeName the bladeName value to set.
     * @return the RecommendationProperties object itself.
     */
    public RecommendationProperties withBladeName(String bladeName) {
        this.bladeName = bladeName;
        return this;
    }

    /**
     * Get the forwardLink property: Forward link to an external document associated with the rule.
     * 
     * @return the forwardLink value.
     */
    public String forwardLink() {
        return this.forwardLink;
    }

    /**
     * Set the forwardLink property: Forward link to an external document associated with the rule.
     * 
     * @param forwardLink the forwardLink value to set.
     * @return the RecommendationProperties object itself.
     */
    public RecommendationProperties withForwardLink(String forwardLink) {
        this.forwardLink = forwardLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("creationTime",
            this.creationTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.creationTime));
        jsonWriter.writeStringField("recommendationId", Objects.toString(this.recommendationId, null));
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("resourceScope", this.resourceScope == null ? null : this.resourceScope.toString());
        jsonWriter.writeStringField("ruleName", this.ruleName);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("level", this.level == null ? null : this.level.toString());
        jsonWriter.writeStringField("channels", this.channels == null ? null : this.channels.toString());
        jsonWriter.writeStringField("actionName", this.actionName);
        jsonWriter.writeNumberField("enabled", this.enabled);
        jsonWriter.writeArrayField("states", this.states, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("startTime",
            this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime",
            this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeStringField("nextNotificationTime",
            this.nextNotificationTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.nextNotificationTime));
        jsonWriter.writeStringField("notificationExpirationTime",
            this.notificationExpirationTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.notificationExpirationTime));
        jsonWriter.writeStringField("notifiedTime",
            this.notifiedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.notifiedTime));
        jsonWriter.writeNumberField("score", this.score);
        jsonWriter.writeBooleanField("isDynamic", this.isDynamic);
        jsonWriter.writeStringField("extensionName", this.extensionName);
        jsonWriter.writeStringField("bladeName", this.bladeName);
        jsonWriter.writeStringField("forwardLink", this.forwardLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RecommendationProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RecommendationProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RecommendationProperties.
     */
    public static RecommendationProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RecommendationProperties deserializedRecommendationProperties = new RecommendationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("creationTime".equals(fieldName)) {
                    deserializedRecommendationProperties.creationTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("recommendationId".equals(fieldName)) {
                    deserializedRecommendationProperties.recommendationId
                        = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                } else if ("resourceId".equals(fieldName)) {
                    deserializedRecommendationProperties.resourceId = reader.getString();
                } else if ("resourceScope".equals(fieldName)) {
                    deserializedRecommendationProperties.resourceScope
                        = ResourceScopeType.fromString(reader.getString());
                } else if ("ruleName".equals(fieldName)) {
                    deserializedRecommendationProperties.ruleName = reader.getString();
                } else if ("displayName".equals(fieldName)) {
                    deserializedRecommendationProperties.displayName = reader.getString();
                } else if ("message".equals(fieldName)) {
                    deserializedRecommendationProperties.message = reader.getString();
                } else if ("level".equals(fieldName)) {
                    deserializedRecommendationProperties.level = NotificationLevel.fromString(reader.getString());
                } else if ("channels".equals(fieldName)) {
                    deserializedRecommendationProperties.channels = Channels.fromString(reader.getString());
                } else if ("categoryTags".equals(fieldName)) {
                    List<String> categoryTags = reader.readArray(reader1 -> reader1.getString());
                    deserializedRecommendationProperties.categoryTags = categoryTags;
                } else if ("actionName".equals(fieldName)) {
                    deserializedRecommendationProperties.actionName = reader.getString();
                } else if ("enabled".equals(fieldName)) {
                    deserializedRecommendationProperties.enabled = reader.getNullable(JsonReader::getInt);
                } else if ("states".equals(fieldName)) {
                    List<String> states = reader.readArray(reader1 -> reader1.getString());
                    deserializedRecommendationProperties.states = states;
                } else if ("startTime".equals(fieldName)) {
                    deserializedRecommendationProperties.startTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("endTime".equals(fieldName)) {
                    deserializedRecommendationProperties.endTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("nextNotificationTime".equals(fieldName)) {
                    deserializedRecommendationProperties.nextNotificationTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("notificationExpirationTime".equals(fieldName)) {
                    deserializedRecommendationProperties.notificationExpirationTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("notifiedTime".equals(fieldName)) {
                    deserializedRecommendationProperties.notifiedTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("score".equals(fieldName)) {
                    deserializedRecommendationProperties.score = reader.getNullable(JsonReader::getDouble);
                } else if ("isDynamic".equals(fieldName)) {
                    deserializedRecommendationProperties.isDynamic = reader.getNullable(JsonReader::getBoolean);
                } else if ("extensionName".equals(fieldName)) {
                    deserializedRecommendationProperties.extensionName = reader.getString();
                } else if ("bladeName".equals(fieldName)) {
                    deserializedRecommendationProperties.bladeName = reader.getString();
                } else if ("forwardLink".equals(fieldName)) {
                    deserializedRecommendationProperties.forwardLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRecommendationProperties;
        });
    }
}
