// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ErrorEntity;
import com.azure.resourcemanager.appservice.models.OperationStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

/**
 * An operation on a resource.
 */
@Fluent
public final class OperationInner implements JsonSerializable<OperationInner> {
    /*
     * Operation ID.
     */
    private String id;

    /*
     * Operation name.
     */
    private String name;

    /*
     * The current status of the operation.
     */
    private OperationStatus status;

    /*
     * Any errors associate with the operation.
     */
    private List<ErrorEntity> errors;

    /*
     * Time when operation has started.
     */
    private OffsetDateTime createdTime;

    /*
     * Time when operation has been updated.
     */
    private OffsetDateTime modifiedTime;

    /*
     * Time when operation will expire.
     */
    private OffsetDateTime expirationTime;

    /*
     * Applicable only for stamp operation ids.
     */
    private UUID geoMasterOperationId;

    /**
     * Creates an instance of OperationInner class.
     */
    public OperationInner() {
    }

    /**
     * Get the id property: Operation ID.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Operation ID.
     * 
     * @param id the id value to set.
     * @return the OperationInner object itself.
     */
    public OperationInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the name property: Operation name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Operation name.
     * 
     * @param name the name value to set.
     * @return the OperationInner object itself.
     */
    public OperationInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the status property: The current status of the operation.
     * 
     * @return the status value.
     */
    public OperationStatus status() {
        return this.status;
    }

    /**
     * Set the status property: The current status of the operation.
     * 
     * @param status the status value to set.
     * @return the OperationInner object itself.
     */
    public OperationInner withStatus(OperationStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the errors property: Any errors associate with the operation.
     * 
     * @return the errors value.
     */
    public List<ErrorEntity> errors() {
        return this.errors;
    }

    /**
     * Set the errors property: Any errors associate with the operation.
     * 
     * @param errors the errors value to set.
     * @return the OperationInner object itself.
     */
    public OperationInner withErrors(List<ErrorEntity> errors) {
        this.errors = errors;
        return this;
    }

    /**
     * Get the createdTime property: Time when operation has started.
     * 
     * @return the createdTime value.
     */
    public OffsetDateTime createdTime() {
        return this.createdTime;
    }

    /**
     * Set the createdTime property: Time when operation has started.
     * 
     * @param createdTime the createdTime value to set.
     * @return the OperationInner object itself.
     */
    public OperationInner withCreatedTime(OffsetDateTime createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    /**
     * Get the modifiedTime property: Time when operation has been updated.
     * 
     * @return the modifiedTime value.
     */
    public OffsetDateTime modifiedTime() {
        return this.modifiedTime;
    }

    /**
     * Set the modifiedTime property: Time when operation has been updated.
     * 
     * @param modifiedTime the modifiedTime value to set.
     * @return the OperationInner object itself.
     */
    public OperationInner withModifiedTime(OffsetDateTime modifiedTime) {
        this.modifiedTime = modifiedTime;
        return this;
    }

    /**
     * Get the expirationTime property: Time when operation will expire.
     * 
     * @return the expirationTime value.
     */
    public OffsetDateTime expirationTime() {
        return this.expirationTime;
    }

    /**
     * Set the expirationTime property: Time when operation will expire.
     * 
     * @param expirationTime the expirationTime value to set.
     * @return the OperationInner object itself.
     */
    public OperationInner withExpirationTime(OffsetDateTime expirationTime) {
        this.expirationTime = expirationTime;
        return this;
    }

    /**
     * Get the geoMasterOperationId property: Applicable only for stamp operation ids.
     * 
     * @return the geoMasterOperationId value.
     */
    public UUID geoMasterOperationId() {
        return this.geoMasterOperationId;
    }

    /**
     * Set the geoMasterOperationId property: Applicable only for stamp operation ids.
     * 
     * @param geoMasterOperationId the geoMasterOperationId value to set.
     * @return the OperationInner object itself.
     */
    public OperationInner withGeoMasterOperationId(UUID geoMasterOperationId) {
        this.geoMasterOperationId = geoMasterOperationId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (errors() != null) {
            errors().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeArrayField("errors", this.errors, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("createdTime",
            this.createdTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdTime));
        jsonWriter.writeStringField("modifiedTime",
            this.modifiedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.modifiedTime));
        jsonWriter.writeStringField("expirationTime",
            this.expirationTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationTime));
        jsonWriter.writeStringField("geoMasterOperationId", Objects.toString(this.geoMasterOperationId, null));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OperationInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OperationInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the OperationInner.
     */
    public static OperationInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OperationInner deserializedOperationInner = new OperationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedOperationInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedOperationInner.name = reader.getString();
                } else if ("status".equals(fieldName)) {
                    deserializedOperationInner.status = OperationStatus.fromString(reader.getString());
                } else if ("errors".equals(fieldName)) {
                    List<ErrorEntity> errors = reader.readArray(reader1 -> ErrorEntity.fromJson(reader1));
                    deserializedOperationInner.errors = errors;
                } else if ("createdTime".equals(fieldName)) {
                    deserializedOperationInner.createdTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("modifiedTime".equals(fieldName)) {
                    deserializedOperationInner.modifiedTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("expirationTime".equals(fieldName)) {
                    deserializedOperationInner.expirationTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("geoMasterOperationId".equals(fieldName)) {
                    deserializedOperationInner.geoMasterOperationId
                        = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOperationInner;
        });
    }
}
