// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * NetworkFeatures resource specific properties.
 */
@Immutable
public final class NetworkFeaturesProperties implements JsonSerializable<NetworkFeaturesProperties> {
    /*
     * The Virtual Network name.
     */
    private String virtualNetworkName;

    /*
     * The Virtual Network summary view.
     */
    private VnetInfo virtualNetworkConnection;

    /*
     * The Hybrid Connections summary view.
     */
    private List<RelayServiceConnectionEntityInner> hybridConnections;

    /*
     * The Hybrid Connection V2 (Service Bus) view.
     */
    private List<HybridConnectionInner> hybridConnectionsV2;

    /**
     * Creates an instance of NetworkFeaturesProperties class.
     */
    public NetworkFeaturesProperties() {
    }

    /**
     * Get the virtualNetworkName property: The Virtual Network name.
     * 
     * @return the virtualNetworkName value.
     */
    public String virtualNetworkName() {
        return this.virtualNetworkName;
    }

    /**
     * Get the virtualNetworkConnection property: The Virtual Network summary view.
     * 
     * @return the virtualNetworkConnection value.
     */
    public VnetInfo virtualNetworkConnection() {
        return this.virtualNetworkConnection;
    }

    /**
     * Get the hybridConnections property: The Hybrid Connections summary view.
     * 
     * @return the hybridConnections value.
     */
    public List<RelayServiceConnectionEntityInner> hybridConnections() {
        return this.hybridConnections;
    }

    /**
     * Get the hybridConnectionsV2 property: The Hybrid Connection V2 (Service Bus) view.
     * 
     * @return the hybridConnectionsV2 value.
     */
    public List<HybridConnectionInner> hybridConnectionsV2() {
        return this.hybridConnectionsV2;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (virtualNetworkConnection() != null) {
            virtualNetworkConnection().validate();
        }
        if (hybridConnections() != null) {
            hybridConnections().forEach(e -> e.validate());
        }
        if (hybridConnectionsV2() != null) {
            hybridConnectionsV2().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkFeaturesProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkFeaturesProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NetworkFeaturesProperties.
     */
    public static NetworkFeaturesProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkFeaturesProperties deserializedNetworkFeaturesProperties = new NetworkFeaturesProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("virtualNetworkName".equals(fieldName)) {
                    deserializedNetworkFeaturesProperties.virtualNetworkName = reader.getString();
                } else if ("virtualNetworkConnection".equals(fieldName)) {
                    deserializedNetworkFeaturesProperties.virtualNetworkConnection = VnetInfo.fromJson(reader);
                } else if ("hybridConnections".equals(fieldName)) {
                    List<RelayServiceConnectionEntityInner> hybridConnections
                        = reader.readArray(reader1 -> RelayServiceConnectionEntityInner.fromJson(reader1));
                    deserializedNetworkFeaturesProperties.hybridConnections = hybridConnections;
                } else if ("hybridConnectionsV2".equals(fieldName)) {
                    List<HybridConnectionInner> hybridConnectionsV2
                        = reader.readArray(reader1 -> HybridConnectionInner.fromJson(reader1));
                    deserializedNetworkFeaturesProperties.hybridConnectionsV2 = hybridConnectionsV2;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkFeaturesProperties;
        });
    }
}
