// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * HybridConnection resource specific properties.
 */
@Fluent
public final class HybridConnectionProperties implements JsonSerializable<HybridConnectionProperties> {
    /*
     * The name of the Service Bus namespace.
     */
    private String serviceBusNamespace;

    /*
     * The name of the Service Bus relay.
     */
    private String relayName;

    /*
     * The ARM URI to the Service Bus relay.
     */
    private String relayArmUri;

    /*
     * The hostname of the endpoint.
     */
    private String hostname;

    /*
     * The port of the endpoint.
     */
    private Integer port;

    /*
     * The name of the Service Bus key which has Send permissions. This is used to authenticate to Service Bus.
     */
    private String sendKeyName;

    /*
     * The value of the Service Bus key. This is used to authenticate to Service Bus. In ARM this key will not be
     * returned
     * normally, use the POST /listKeys API instead.
     */
    private String sendKeyValue;

    /*
     * The suffix for the service bus endpoint. By default this is .servicebus.windows.net
     */
    private String serviceBusSuffix;

    /**
     * Creates an instance of HybridConnectionProperties class.
     */
    public HybridConnectionProperties() {
    }

    /**
     * Get the serviceBusNamespace property: The name of the Service Bus namespace.
     * 
     * @return the serviceBusNamespace value.
     */
    public String serviceBusNamespace() {
        return this.serviceBusNamespace;
    }

    /**
     * Set the serviceBusNamespace property: The name of the Service Bus namespace.
     * 
     * @param serviceBusNamespace the serviceBusNamespace value to set.
     * @return the HybridConnectionProperties object itself.
     */
    public HybridConnectionProperties withServiceBusNamespace(String serviceBusNamespace) {
        this.serviceBusNamespace = serviceBusNamespace;
        return this;
    }

    /**
     * Get the relayName property: The name of the Service Bus relay.
     * 
     * @return the relayName value.
     */
    public String relayName() {
        return this.relayName;
    }

    /**
     * Set the relayName property: The name of the Service Bus relay.
     * 
     * @param relayName the relayName value to set.
     * @return the HybridConnectionProperties object itself.
     */
    public HybridConnectionProperties withRelayName(String relayName) {
        this.relayName = relayName;
        return this;
    }

    /**
     * Get the relayArmUri property: The ARM URI to the Service Bus relay.
     * 
     * @return the relayArmUri value.
     */
    public String relayArmUri() {
        return this.relayArmUri;
    }

    /**
     * Set the relayArmUri property: The ARM URI to the Service Bus relay.
     * 
     * @param relayArmUri the relayArmUri value to set.
     * @return the HybridConnectionProperties object itself.
     */
    public HybridConnectionProperties withRelayArmUri(String relayArmUri) {
        this.relayArmUri = relayArmUri;
        return this;
    }

    /**
     * Get the hostname property: The hostname of the endpoint.
     * 
     * @return the hostname value.
     */
    public String hostname() {
        return this.hostname;
    }

    /**
     * Set the hostname property: The hostname of the endpoint.
     * 
     * @param hostname the hostname value to set.
     * @return the HybridConnectionProperties object itself.
     */
    public HybridConnectionProperties withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    /**
     * Get the port property: The port of the endpoint.
     * 
     * @return the port value.
     */
    public Integer port() {
        return this.port;
    }

    /**
     * Set the port property: The port of the endpoint.
     * 
     * @param port the port value to set.
     * @return the HybridConnectionProperties object itself.
     */
    public HybridConnectionProperties withPort(Integer port) {
        this.port = port;
        return this;
    }

    /**
     * Get the sendKeyName property: The name of the Service Bus key which has Send permissions. This is used to
     * authenticate to Service Bus.
     * 
     * @return the sendKeyName value.
     */
    public String sendKeyName() {
        return this.sendKeyName;
    }

    /**
     * Set the sendKeyName property: The name of the Service Bus key which has Send permissions. This is used to
     * authenticate to Service Bus.
     * 
     * @param sendKeyName the sendKeyName value to set.
     * @return the HybridConnectionProperties object itself.
     */
    public HybridConnectionProperties withSendKeyName(String sendKeyName) {
        this.sendKeyName = sendKeyName;
        return this;
    }

    /**
     * Get the sendKeyValue property: The value of the Service Bus key. This is used to authenticate to Service Bus. In
     * ARM this key will not be returned
     * normally, use the POST /listKeys API instead.
     * 
     * @return the sendKeyValue value.
     */
    public String sendKeyValue() {
        return this.sendKeyValue;
    }

    /**
     * Set the sendKeyValue property: The value of the Service Bus key. This is used to authenticate to Service Bus. In
     * ARM this key will not be returned
     * normally, use the POST /listKeys API instead.
     * 
     * @param sendKeyValue the sendKeyValue value to set.
     * @return the HybridConnectionProperties object itself.
     */
    public HybridConnectionProperties withSendKeyValue(String sendKeyValue) {
        this.sendKeyValue = sendKeyValue;
        return this;
    }

    /**
     * Get the serviceBusSuffix property: The suffix for the service bus endpoint. By default this is
     * .servicebus.windows.net.
     * 
     * @return the serviceBusSuffix value.
     */
    public String serviceBusSuffix() {
        return this.serviceBusSuffix;
    }

    /**
     * Set the serviceBusSuffix property: The suffix for the service bus endpoint. By default this is
     * .servicebus.windows.net.
     * 
     * @param serviceBusSuffix the serviceBusSuffix value to set.
     * @return the HybridConnectionProperties object itself.
     */
    public HybridConnectionProperties withServiceBusSuffix(String serviceBusSuffix) {
        this.serviceBusSuffix = serviceBusSuffix;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serviceBusNamespace", this.serviceBusNamespace);
        jsonWriter.writeStringField("relayName", this.relayName);
        jsonWriter.writeStringField("relayArmUri", this.relayArmUri);
        jsonWriter.writeStringField("hostname", this.hostname);
        jsonWriter.writeNumberField("port", this.port);
        jsonWriter.writeStringField("sendKeyName", this.sendKeyName);
        jsonWriter.writeStringField("sendKeyValue", this.sendKeyValue);
        jsonWriter.writeStringField("serviceBusSuffix", this.serviceBusSuffix);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of HybridConnectionProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of HybridConnectionProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the HybridConnectionProperties.
     */
    public static HybridConnectionProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HybridConnectionProperties deserializedHybridConnectionProperties = new HybridConnectionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("serviceBusNamespace".equals(fieldName)) {
                    deserializedHybridConnectionProperties.serviceBusNamespace = reader.getString();
                } else if ("relayName".equals(fieldName)) {
                    deserializedHybridConnectionProperties.relayName = reader.getString();
                } else if ("relayArmUri".equals(fieldName)) {
                    deserializedHybridConnectionProperties.relayArmUri = reader.getString();
                } else if ("hostname".equals(fieldName)) {
                    deserializedHybridConnectionProperties.hostname = reader.getString();
                } else if ("port".equals(fieldName)) {
                    deserializedHybridConnectionProperties.port = reader.getNullable(JsonReader::getInt);
                } else if ("sendKeyName".equals(fieldName)) {
                    deserializedHybridConnectionProperties.sendKeyName = reader.getString();
                } else if ("sendKeyValue".equals(fieldName)) {
                    deserializedHybridConnectionProperties.sendKeyValue = reader.getString();
                } else if ("serviceBusSuffix".equals(fieldName)) {
                    deserializedHybridConnectionProperties.serviceBusSuffix = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedHybridConnectionProperties;
        });
    }
}
