// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;

/**
 * Hybrid Connection limits contract. This is used to return the plan limits of Hybrid Connections.
 */
@Fluent
public final class HybridConnectionLimitsInner extends ProxyOnlyResource {
    /*
     * HybridConnectionLimits resource specific properties
     */
    private HybridConnectionLimitsProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of HybridConnectionLimitsInner class.
     */
    public HybridConnectionLimitsInner() {
    }

    /**
     * Get the innerProperties property: HybridConnectionLimits resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private HybridConnectionLimitsProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public HybridConnectionLimitsInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the current property: The current number of Hybrid Connections.
     * 
     * @return the current value.
     */
    public Integer current() {
        return this.innerProperties() == null ? null : this.innerProperties().current();
    }

    /**
     * Get the maximum property: The maximum number of Hybrid Connections allowed.
     * 
     * @return the maximum value.
     */
    public Integer maximum() {
        return this.innerProperties() == null ? null : this.innerProperties().maximum();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of HybridConnectionLimitsInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of HybridConnectionLimitsInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the HybridConnectionLimitsInner.
     */
    public static HybridConnectionLimitsInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HybridConnectionLimitsInner deserializedHybridConnectionLimitsInner = new HybridConnectionLimitsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedHybridConnectionLimitsInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedHybridConnectionLimitsInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedHybridConnectionLimitsInner.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedHybridConnectionLimitsInner.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedHybridConnectionLimitsInner.innerProperties
                        = HybridConnectionLimitsProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedHybridConnectionLimitsInner;
        });
    }
}
