// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * HybridConnectionKey resource specific properties.
 */
@Immutable
public final class HybridConnectionKeyProperties implements JsonSerializable<HybridConnectionKeyProperties> {
    /*
     * The name of the send key.
     */
    private String sendKeyName;

    /*
     * The value of the send key.
     */
    private String sendKeyValue;

    /**
     * Creates an instance of HybridConnectionKeyProperties class.
     */
    public HybridConnectionKeyProperties() {
    }

    /**
     * Get the sendKeyName property: The name of the send key.
     * 
     * @return the sendKeyName value.
     */
    public String sendKeyName() {
        return this.sendKeyName;
    }

    /**
     * Get the sendKeyValue property: The value of the send key.
     * 
     * @return the sendKeyValue value.
     */
    public String sendKeyValue() {
        return this.sendKeyValue;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of HybridConnectionKeyProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of HybridConnectionKeyProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the HybridConnectionKeyProperties.
     */
    public static HybridConnectionKeyProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HybridConnectionKeyProperties deserializedHybridConnectionKeyProperties
                = new HybridConnectionKeyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sendKeyName".equals(fieldName)) {
                    deserializedHybridConnectionKeyProperties.sendKeyName = reader.getString();
                } else if ("sendKeyValue".equals(fieldName)) {
                    deserializedHybridConnectionKeyProperties.sendKeyValue = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedHybridConnectionKeyProperties;
        });
    }
}
