// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;

/**
 * A deleted app.
 */
@Fluent
public final class DeletedSiteInner extends ProxyOnlyResource {
    /*
     * DeletedSite resource specific properties
     */
    private DeletedSiteProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of DeletedSiteInner class.
     */
    public DeletedSiteInner() {
    }

    /**
     * Get the innerProperties property: DeletedSite resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private DeletedSiteProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DeletedSiteInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the deletedSiteId property: Numeric id for the deleted site.
     * 
     * @return the deletedSiteId value.
     */
    public Integer deletedSiteId() {
        return this.innerProperties() == null ? null : this.innerProperties().deletedSiteId();
    }

    /**
     * Get the deletedTimestamp property: Time in UTC when the app was deleted.
     * 
     * @return the deletedTimestamp value.
     */
    public String deletedTimestamp() {
        return this.innerProperties() == null ? null : this.innerProperties().deletedTimestamp();
    }

    /**
     * Get the subscription property: Subscription containing the deleted site.
     * 
     * @return the subscription value.
     */
    public String subscription() {
        return this.innerProperties() == null ? null : this.innerProperties().subscription();
    }

    /**
     * Get the resourceGroup property: ResourceGroup that contained the deleted site.
     * 
     * @return the resourceGroup value.
     */
    public String resourceGroup() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGroup();
    }

    /**
     * Get the deletedSiteName property: Name of the deleted site.
     * 
     * @return the deletedSiteName value.
     */
    public String deletedSiteName() {
        return this.innerProperties() == null ? null : this.innerProperties().deletedSiteName();
    }

    /**
     * Get the slot property: Slot of the deleted site.
     * 
     * @return the slot value.
     */
    public String slot() {
        return this.innerProperties() == null ? null : this.innerProperties().slot();
    }

    /**
     * Get the kind property: Kind of site that was deleted.
     * 
     * @return the kind value.
     */
    public String kindPropertiesKind() {
        return this.innerProperties() == null ? null : this.innerProperties().kind();
    }

    /**
     * Get the geoRegionName property: Geo Region of the deleted site.
     * 
     * @return the geoRegionName value.
     */
    public String geoRegionName() {
        return this.innerProperties() == null ? null : this.innerProperties().geoRegionName();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeletedSiteInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeletedSiteInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DeletedSiteInner.
     */
    public static DeletedSiteInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeletedSiteInner deserializedDeletedSiteInner = new DeletedSiteInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedDeletedSiteInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedDeletedSiteInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedDeletedSiteInner.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedDeletedSiteInner.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedDeletedSiteInner.innerProperties = DeletedSiteProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeletedSiteInner;
        });
    }
}
