// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.BackupItemStatus;
import com.azure.resourcemanager.appservice.models.DatabaseBackupSetting;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * BackupItem resource specific properties.
 */
@Immutable
public final class BackupItemProperties implements JsonSerializable<BackupItemProperties> {
    /*
     * Id of the backup.
     */
    private Integer backupId;

    /*
     * SAS URL for the storage account container which contains this backup.
     */
    private String storageAccountUrl;

    /*
     * Name of the blob which contains data for this backup.
     */
    private String blobName;

    /*
     * Name of this backup.
     */
    private String name;

    /*
     * Backup status.
     */
    private BackupItemStatus status;

    /*
     * Size of the backup in bytes.
     */
    private Long sizeInBytes;

    /*
     * Timestamp of the backup creation.
     */
    private OffsetDateTime created;

    /*
     * Details regarding this backup. Might contain an error message.
     */
    private String log;

    /*
     * List of databases included in the backup.
     */
    private List<DatabaseBackupSetting> databases;

    /*
     * True if this backup has been created due to a schedule being triggered.
     */
    private Boolean scheduled;

    /*
     * Timestamp of a last restore operation which used this backup.
     */
    private OffsetDateTime lastRestoreTimestamp;

    /*
     * Timestamp when this backup finished.
     */
    private OffsetDateTime finishedTimestamp;

    /*
     * Unique correlation identifier. Please use this along with the timestamp while communicating with Azure support.
     */
    private String correlationId;

    /*
     * Size of the original web app which has been backed up.
     */
    private Long websiteSizeInBytes;

    /**
     * Creates an instance of BackupItemProperties class.
     */
    public BackupItemProperties() {
    }

    /**
     * Get the backupId property: Id of the backup.
     * 
     * @return the backupId value.
     */
    public Integer backupId() {
        return this.backupId;
    }

    /**
     * Get the storageAccountUrl property: SAS URL for the storage account container which contains this backup.
     * 
     * @return the storageAccountUrl value.
     */
    public String storageAccountUrl() {
        return this.storageAccountUrl;
    }

    /**
     * Get the blobName property: Name of the blob which contains data for this backup.
     * 
     * @return the blobName value.
     */
    public String blobName() {
        return this.blobName;
    }

    /**
     * Get the name property: Name of this backup.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the status property: Backup status.
     * 
     * @return the status value.
     */
    public BackupItemStatus status() {
        return this.status;
    }

    /**
     * Get the sizeInBytes property: Size of the backup in bytes.
     * 
     * @return the sizeInBytes value.
     */
    public Long sizeInBytes() {
        return this.sizeInBytes;
    }

    /**
     * Get the created property: Timestamp of the backup creation.
     * 
     * @return the created value.
     */
    public OffsetDateTime created() {
        return this.created;
    }

    /**
     * Get the log property: Details regarding this backup. Might contain an error message.
     * 
     * @return the log value.
     */
    public String log() {
        return this.log;
    }

    /**
     * Get the databases property: List of databases included in the backup.
     * 
     * @return the databases value.
     */
    public List<DatabaseBackupSetting> databases() {
        return this.databases;
    }

    /**
     * Get the scheduled property: True if this backup has been created due to a schedule being triggered.
     * 
     * @return the scheduled value.
     */
    public Boolean scheduled() {
        return this.scheduled;
    }

    /**
     * Get the lastRestoreTimestamp property: Timestamp of a last restore operation which used this backup.
     * 
     * @return the lastRestoreTimestamp value.
     */
    public OffsetDateTime lastRestoreTimestamp() {
        return this.lastRestoreTimestamp;
    }

    /**
     * Get the finishedTimestamp property: Timestamp when this backup finished.
     * 
     * @return the finishedTimestamp value.
     */
    public OffsetDateTime finishedTimestamp() {
        return this.finishedTimestamp;
    }

    /**
     * Get the correlationId property: Unique correlation identifier. Please use this along with the timestamp while
     * communicating with Azure support.
     * 
     * @return the correlationId value.
     */
    public String correlationId() {
        return this.correlationId;
    }

    /**
     * Get the websiteSizeInBytes property: Size of the original web app which has been backed up.
     * 
     * @return the websiteSizeInBytes value.
     */
    public Long websiteSizeInBytes() {
        return this.websiteSizeInBytes;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (databases() != null) {
            databases().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BackupItemProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BackupItemProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the BackupItemProperties.
     */
    public static BackupItemProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BackupItemProperties deserializedBackupItemProperties = new BackupItemProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedBackupItemProperties.backupId = reader.getNullable(JsonReader::getInt);
                } else if ("storageAccountUrl".equals(fieldName)) {
                    deserializedBackupItemProperties.storageAccountUrl = reader.getString();
                } else if ("blobName".equals(fieldName)) {
                    deserializedBackupItemProperties.blobName = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedBackupItemProperties.name = reader.getString();
                } else if ("status".equals(fieldName)) {
                    deserializedBackupItemProperties.status = BackupItemStatus.fromString(reader.getString());
                } else if ("sizeInBytes".equals(fieldName)) {
                    deserializedBackupItemProperties.sizeInBytes = reader.getNullable(JsonReader::getLong);
                } else if ("created".equals(fieldName)) {
                    deserializedBackupItemProperties.created = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("log".equals(fieldName)) {
                    deserializedBackupItemProperties.log = reader.getString();
                } else if ("databases".equals(fieldName)) {
                    List<DatabaseBackupSetting> databases
                        = reader.readArray(reader1 -> DatabaseBackupSetting.fromJson(reader1));
                    deserializedBackupItemProperties.databases = databases;
                } else if ("scheduled".equals(fieldName)) {
                    deserializedBackupItemProperties.scheduled = reader.getNullable(JsonReader::getBoolean);
                } else if ("lastRestoreTimeStamp".equals(fieldName)) {
                    deserializedBackupItemProperties.lastRestoreTimestamp = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("finishedTimeStamp".equals(fieldName)) {
                    deserializedBackupItemProperties.finishedTimestamp = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("correlationId".equals(fieldName)) {
                    deserializedBackupItemProperties.correlationId = reader.getString();
                } else if ("websiteSizeInBytes".equals(fieldName)) {
                    deserializedBackupItemProperties.websiteSizeInBytes = reader.getNullable(JsonReader::getLong);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBackupItemProperties;
        });
    }
}
