// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * ASE region resource specific properties.
 */
@Fluent
public final class AseRegionProperties implements JsonSerializable<AseRegionProperties> {
    /*
     * Display name for region.
     */
    private String displayName;

    /*
     * Is region standard.
     */
    private Boolean standard;

    /*
     * Dedicated host enabled.
     */
    private Boolean dedicatedHost;

    /*
     * Zone redundant deployment enabled.
     */
    private Boolean zoneRedundant;

    /*
     * Available Skus in region.
     */
    private List<String> availableSku;

    /*
     * Available OSs in region.
     */
    private List<String> availableOS;

    /**
     * Creates an instance of AseRegionProperties class.
     */
    public AseRegionProperties() {
    }

    /**
     * Get the displayName property: Display name for region.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Get the standard property: Is region standard.
     * 
     * @return the standard value.
     */
    public Boolean standard() {
        return this.standard;
    }

    /**
     * Get the dedicatedHost property: Dedicated host enabled.
     * 
     * @return the dedicatedHost value.
     */
    public Boolean dedicatedHost() {
        return this.dedicatedHost;
    }

    /**
     * Get the zoneRedundant property: Zone redundant deployment enabled.
     * 
     * @return the zoneRedundant value.
     */
    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    /**
     * Get the availableSku property: Available Skus in region.
     * 
     * @return the availableSku value.
     */
    public List<String> availableSku() {
        return this.availableSku;
    }

    /**
     * Set the availableSku property: Available Skus in region.
     * 
     * @param availableSku the availableSku value to set.
     * @return the AseRegionProperties object itself.
     */
    public AseRegionProperties withAvailableSku(List<String> availableSku) {
        this.availableSku = availableSku;
        return this;
    }

    /**
     * Get the availableOS property: Available OSs in region.
     * 
     * @return the availableOS value.
     */
    public List<String> availableOS() {
        return this.availableOS;
    }

    /**
     * Set the availableOS property: Available OSs in region.
     * 
     * @param availableOS the availableOS value to set.
     * @return the AseRegionProperties object itself.
     */
    public AseRegionProperties withAvailableOS(List<String> availableOS) {
        this.availableOS = availableOS;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("availableSku", this.availableSku, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("availableOS", this.availableOS, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AseRegionProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AseRegionProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the AseRegionProperties.
     */
    public static AseRegionProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AseRegionProperties deserializedAseRegionProperties = new AseRegionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("displayName".equals(fieldName)) {
                    deserializedAseRegionProperties.displayName = reader.getString();
                } else if ("standard".equals(fieldName)) {
                    deserializedAseRegionProperties.standard = reader.getNullable(JsonReader::getBoolean);
                } else if ("dedicatedHost".equals(fieldName)) {
                    deserializedAseRegionProperties.dedicatedHost = reader.getNullable(JsonReader::getBoolean);
                } else if ("zoneRedundant".equals(fieldName)) {
                    deserializedAseRegionProperties.zoneRedundant = reader.getNullable(JsonReader::getBoolean);
                } else if ("availableSku".equals(fieldName)) {
                    List<String> availableSku = reader.readArray(reader1 -> reader1.getString());
                    deserializedAseRegionProperties.availableSku = availableSku;
                } else if ("availableOS".equals(fieldName)) {
                    List<String> availableOS = reader.readArray(reader1 -> reader1.getString());
                    deserializedAseRegionProperties.availableOS = availableOS;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAseRegionProperties;
        });
    }
}
