// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;
import java.util.List;

/**
 * ASE region.
 */
@Fluent
public final class AseRegionInner extends ProxyOnlyResource {
    /*
     * ASE region resource specific properties
     */
    private AseRegionProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of AseRegionInner class.
     */
    public AseRegionInner() {
    }

    /**
     * Get the innerProperties property: ASE region resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private AseRegionProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AseRegionInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the displayName property: Display name for region.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    /**
     * Get the standard property: Is region standard.
     * 
     * @return the standard value.
     */
    public Boolean standard() {
        return this.innerProperties() == null ? null : this.innerProperties().standard();
    }

    /**
     * Get the dedicatedHost property: Dedicated host enabled.
     * 
     * @return the dedicatedHost value.
     */
    public Boolean dedicatedHost() {
        return this.innerProperties() == null ? null : this.innerProperties().dedicatedHost();
    }

    /**
     * Get the zoneRedundant property: Zone redundant deployment enabled.
     * 
     * @return the zoneRedundant value.
     */
    public Boolean zoneRedundant() {
        return this.innerProperties() == null ? null : this.innerProperties().zoneRedundant();
    }

    /**
     * Get the availableSku property: Available Skus in region.
     * 
     * @return the availableSku value.
     */
    public List<String> availableSku() {
        return this.innerProperties() == null ? null : this.innerProperties().availableSku();
    }

    /**
     * Set the availableSku property: Available Skus in region.
     * 
     * @param availableSku the availableSku value to set.
     * @return the AseRegionInner object itself.
     */
    public AseRegionInner withAvailableSku(List<String> availableSku) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AseRegionProperties();
        }
        this.innerProperties().withAvailableSku(availableSku);
        return this;
    }

    /**
     * Get the availableOS property: Available OSs in region.
     * 
     * @return the availableOS value.
     */
    public List<String> availableOS() {
        return this.innerProperties() == null ? null : this.innerProperties().availableOS();
    }

    /**
     * Set the availableOS property: Available OSs in region.
     * 
     * @param availableOS the availableOS value to set.
     * @return the AseRegionInner object itself.
     */
    public AseRegionInner withAvailableOS(List<String> availableOS) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AseRegionProperties();
        }
        this.innerProperties().withAvailableOS(availableOS);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AseRegionInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AseRegionInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AseRegionInner.
     */
    public static AseRegionInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AseRegionInner deserializedAseRegionInner = new AseRegionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedAseRegionInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedAseRegionInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedAseRegionInner.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedAseRegionInner.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedAseRegionInner.innerProperties = AseRegionProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAseRegionInner;
        });
    }
}
