/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.Dimension;
import com.azure.resourcemanager.appservice.models.MetricAvailability;
import java.io.IOException;
import java.util.List;

public final class MetricSpecification
implements JsonSerializable<MetricSpecification> {
    private String name;
    private String displayName;
    private String displayDescription;
    private String unit;
    private String aggregationType;
    private Boolean supportsInstanceLevelAggregation;
    private Boolean enableRegionalMdmAccount;
    private String sourceMdmAccount;
    private String sourceMdmNamespace;
    private String metricFilterPattern;
    private Boolean fillGapWithZero;
    private Boolean isInternal;
    private List<Dimension> dimensions;
    private String category;
    private List<MetricAvailability> availabilities;
    private List<String> supportedTimeGrainTypes;
    private List<String> supportedAggregationTypes;

    public String name() {
        return this.name;
    }

    public MetricSpecification withName(String name) {
        this.name = name;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public MetricSpecification withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String displayDescription() {
        return this.displayDescription;
    }

    public MetricSpecification withDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    public String unit() {
        return this.unit;
    }

    public MetricSpecification withUnit(String unit) {
        this.unit = unit;
        return this;
    }

    public String aggregationType() {
        return this.aggregationType;
    }

    public MetricSpecification withAggregationType(String aggregationType) {
        this.aggregationType = aggregationType;
        return this;
    }

    public Boolean supportsInstanceLevelAggregation() {
        return this.supportsInstanceLevelAggregation;
    }

    public MetricSpecification withSupportsInstanceLevelAggregation(Boolean supportsInstanceLevelAggregation) {
        this.supportsInstanceLevelAggregation = supportsInstanceLevelAggregation;
        return this;
    }

    public Boolean enableRegionalMdmAccount() {
        return this.enableRegionalMdmAccount;
    }

    public MetricSpecification withEnableRegionalMdmAccount(Boolean enableRegionalMdmAccount) {
        this.enableRegionalMdmAccount = enableRegionalMdmAccount;
        return this;
    }

    public String sourceMdmAccount() {
        return this.sourceMdmAccount;
    }

    public MetricSpecification withSourceMdmAccount(String sourceMdmAccount) {
        this.sourceMdmAccount = sourceMdmAccount;
        return this;
    }

    public String sourceMdmNamespace() {
        return this.sourceMdmNamespace;
    }

    public MetricSpecification withSourceMdmNamespace(String sourceMdmNamespace) {
        this.sourceMdmNamespace = sourceMdmNamespace;
        return this;
    }

    public String metricFilterPattern() {
        return this.metricFilterPattern;
    }

    public MetricSpecification withMetricFilterPattern(String metricFilterPattern) {
        this.metricFilterPattern = metricFilterPattern;
        return this;
    }

    public Boolean fillGapWithZero() {
        return this.fillGapWithZero;
    }

    public MetricSpecification withFillGapWithZero(Boolean fillGapWithZero) {
        this.fillGapWithZero = fillGapWithZero;
        return this;
    }

    public Boolean isInternal() {
        return this.isInternal;
    }

    public MetricSpecification withIsInternal(Boolean isInternal) {
        this.isInternal = isInternal;
        return this;
    }

    public List<Dimension> dimensions() {
        return this.dimensions;
    }

    public MetricSpecification withDimensions(List<Dimension> dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public String category() {
        return this.category;
    }

    public MetricSpecification withCategory(String category) {
        this.category = category;
        return this;
    }

    public List<MetricAvailability> availabilities() {
        return this.availabilities;
    }

    public MetricSpecification withAvailabilities(List<MetricAvailability> availabilities) {
        this.availabilities = availabilities;
        return this;
    }

    public List<String> supportedTimeGrainTypes() {
        return this.supportedTimeGrainTypes;
    }

    public MetricSpecification withSupportedTimeGrainTypes(List<String> supportedTimeGrainTypes) {
        this.supportedTimeGrainTypes = supportedTimeGrainTypes;
        return this;
    }

    public List<String> supportedAggregationTypes() {
        return this.supportedAggregationTypes;
    }

    public MetricSpecification withSupportedAggregationTypes(List<String> supportedAggregationTypes) {
        this.supportedAggregationTypes = supportedAggregationTypes;
        return this;
    }

    public void validate() {
        if (this.dimensions() != null) {
            this.dimensions().forEach(e -> e.validate());
        }
        if (this.availabilities() != null) {
            this.availabilities().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("displayDescription", this.displayDescription);
        jsonWriter.writeStringField("unit", this.unit);
        jsonWriter.writeStringField("aggregationType", this.aggregationType);
        jsonWriter.writeBooleanField("supportsInstanceLevelAggregation", this.supportsInstanceLevelAggregation);
        jsonWriter.writeBooleanField("enableRegionalMdmAccount", this.enableRegionalMdmAccount);
        jsonWriter.writeStringField("sourceMdmAccount", this.sourceMdmAccount);
        jsonWriter.writeStringField("sourceMdmNamespace", this.sourceMdmNamespace);
        jsonWriter.writeStringField("metricFilterPattern", this.metricFilterPattern);
        jsonWriter.writeBooleanField("fillGapWithZero", this.fillGapWithZero);
        jsonWriter.writeBooleanField("isInternal", this.isInternal);
        jsonWriter.writeArrayField("dimensions", this.dimensions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("category", this.category);
        jsonWriter.writeArrayField("availabilities", this.availabilities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("supportedTimeGrainTypes", this.supportedTimeGrainTypes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("supportedAggregationTypes", this.supportedAggregationTypes, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static MetricSpecification fromJson(JsonReader jsonReader) throws IOException {
        return (MetricSpecification)jsonReader.readObject(reader -> {
            MetricSpecification deserializedMetricSpecification = new MetricSpecification();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedMetricSpecification.name = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedMetricSpecification.displayName = reader.getString();
                    continue;
                }
                if ("displayDescription".equals(fieldName)) {
                    deserializedMetricSpecification.displayDescription = reader.getString();
                    continue;
                }
                if ("unit".equals(fieldName)) {
                    deserializedMetricSpecification.unit = reader.getString();
                    continue;
                }
                if ("aggregationType".equals(fieldName)) {
                    deserializedMetricSpecification.aggregationType = reader.getString();
                    continue;
                }
                if ("supportsInstanceLevelAggregation".equals(fieldName)) {
                    deserializedMetricSpecification.supportsInstanceLevelAggregation = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableRegionalMdmAccount".equals(fieldName)) {
                    deserializedMetricSpecification.enableRegionalMdmAccount = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("sourceMdmAccount".equals(fieldName)) {
                    deserializedMetricSpecification.sourceMdmAccount = reader.getString();
                    continue;
                }
                if ("sourceMdmNamespace".equals(fieldName)) {
                    deserializedMetricSpecification.sourceMdmNamespace = reader.getString();
                    continue;
                }
                if ("metricFilterPattern".equals(fieldName)) {
                    deserializedMetricSpecification.metricFilterPattern = reader.getString();
                    continue;
                }
                if ("fillGapWithZero".equals(fieldName)) {
                    deserializedMetricSpecification.fillGapWithZero = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isInternal".equals(fieldName)) {
                    deserializedMetricSpecification.isInternal = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("dimensions".equals(fieldName)) {
                    List dimensions;
                    deserializedMetricSpecification.dimensions = dimensions = reader.readArray(reader1 -> Dimension.fromJson(reader1));
                    continue;
                }
                if ("category".equals(fieldName)) {
                    deserializedMetricSpecification.category = reader.getString();
                    continue;
                }
                if ("availabilities".equals(fieldName)) {
                    List availabilities;
                    deserializedMetricSpecification.availabilities = availabilities = reader.readArray(reader1 -> MetricAvailability.fromJson(reader1));
                    continue;
                }
                if ("supportedTimeGrainTypes".equals(fieldName)) {
                    List supportedTimeGrainTypes;
                    deserializedMetricSpecification.supportedTimeGrainTypes = supportedTimeGrainTypes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("supportedAggregationTypes".equals(fieldName)) {
                    List supportedAggregationTypes;
                    deserializedMetricSpecification.supportedAggregationTypes = supportedAggregationTypes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMetricSpecification;
        });
    }
}

