/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.IdentifierInner;
import java.io.IOException;
import java.util.List;

public final class CustomHostnameSitesProperties
implements JsonSerializable<CustomHostnameSitesProperties> {
    private String customHostname;
    private String region;
    private List<IdentifierInner> siteResourceIds;

    public String customHostname() {
        return this.customHostname;
    }

    public CustomHostnameSitesProperties withCustomHostname(String customHostname) {
        this.customHostname = customHostname;
        return this;
    }

    public String region() {
        return this.region;
    }

    public CustomHostnameSitesProperties withRegion(String region) {
        this.region = region;
        return this;
    }

    public List<IdentifierInner> siteResourceIds() {
        return this.siteResourceIds;
    }

    public CustomHostnameSitesProperties withSiteResourceIds(List<IdentifierInner> siteResourceIds) {
        this.siteResourceIds = siteResourceIds;
        return this;
    }

    public void validate() {
        if (this.siteResourceIds() != null) {
            this.siteResourceIds().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("customHostname", this.customHostname);
        jsonWriter.writeStringField("region", this.region);
        jsonWriter.writeArrayField("siteResourceIds", this.siteResourceIds, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static CustomHostnameSitesProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CustomHostnameSitesProperties)jsonReader.readObject(reader -> {
            CustomHostnameSitesProperties deserializedCustomHostnameSitesProperties = new CustomHostnameSitesProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("customHostname".equals(fieldName)) {
                    deserializedCustomHostnameSitesProperties.customHostname = reader.getString();
                    continue;
                }
                if ("region".equals(fieldName)) {
                    deserializedCustomHostnameSitesProperties.region = reader.getString();
                    continue;
                }
                if ("siteResourceIds".equals(fieldName)) {
                    List siteResourceIds;
                    deserializedCustomHostnameSitesProperties.siteResourceIds = siteResourceIds = reader.readArray(reader1 -> IdentifierInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomHostnameSitesProperties;
        });
    }
}

