/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.AnalysisDefinitionInner;
import java.io.IOException;
import java.util.List;

public final class DiagnosticAnalysisCollection
implements JsonSerializable<DiagnosticAnalysisCollection> {
    private List<AnalysisDefinitionInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(DiagnosticAnalysisCollection.class);

    public List<AnalysisDefinitionInner> value() {
        return this.value;
    }

    public DiagnosticAnalysisCollection withValue(List<AnalysisDefinitionInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model DiagnosticAnalysisCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DiagnosticAnalysisCollection fromJson(JsonReader jsonReader) throws IOException {
        return (DiagnosticAnalysisCollection)jsonReader.readObject(reader -> {
            DiagnosticAnalysisCollection deserializedDiagnosticAnalysisCollection = new DiagnosticAnalysisCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedDiagnosticAnalysisCollection.value = value = reader.readArray(reader1 -> AnalysisDefinitionInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedDiagnosticAnalysisCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiagnosticAnalysisCollection;
        });
    }
}

