/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.CertificatePatchResourceProperties;
import com.azure.resourcemanager.appservice.models.HostingEnvironmentProfile;
import com.azure.resourcemanager.appservice.models.KeyVaultSecretStatus;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class CertificatePatchResource
extends ProxyOnlyResource {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private CertificatePatchResourceProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private CertificatePatchResourceProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public CertificatePatchResource withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public String password() {
        return this.innerProperties() == null ? null : this.innerProperties().password();
    }

    public CertificatePatchResource withPassword(String password) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificatePatchResourceProperties();
        }
        this.innerProperties().withPassword(password);
        return this;
    }

    public String friendlyName() {
        return this.innerProperties() == null ? null : this.innerProperties().friendlyName();
    }

    public String subjectName() {
        return this.innerProperties() == null ? null : this.innerProperties().subjectName();
    }

    public List<String> hostNames() {
        return this.innerProperties() == null ? null : this.innerProperties().hostNames();
    }

    public CertificatePatchResource withHostNames(List<String> hostNames) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificatePatchResourceProperties();
        }
        this.innerProperties().withHostNames(hostNames);
        return this;
    }

    public byte[] pfxBlob() {
        return this.innerProperties() == null ? EMPTY_BYTE_ARRAY : this.innerProperties().pfxBlob();
    }

    public CertificatePatchResource withPfxBlob(byte[] pfxBlob) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificatePatchResourceProperties();
        }
        this.innerProperties().withPfxBlob(pfxBlob);
        return this;
    }

    public String siteName() {
        return this.innerProperties() == null ? null : this.innerProperties().siteName();
    }

    public String selfLink() {
        return this.innerProperties() == null ? null : this.innerProperties().selfLink();
    }

    public String issuer() {
        return this.innerProperties() == null ? null : this.innerProperties().issuer();
    }

    public OffsetDateTime issueDate() {
        return this.innerProperties() == null ? null : this.innerProperties().issueDate();
    }

    public OffsetDateTime expirationDate() {
        return this.innerProperties() == null ? null : this.innerProperties().expirationDate();
    }

    public String thumbprint() {
        return this.innerProperties() == null ? null : this.innerProperties().thumbprint();
    }

    public Boolean valid() {
        return this.innerProperties() == null ? null : this.innerProperties().valid();
    }

    public byte[] cerBlob() {
        return this.innerProperties() == null ? EMPTY_BYTE_ARRAY : this.innerProperties().cerBlob();
    }

    public String publicKeyHash() {
        return this.innerProperties() == null ? null : this.innerProperties().publicKeyHash();
    }

    public HostingEnvironmentProfile hostingEnvironmentProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().hostingEnvironmentProfile();
    }

    public String keyVaultId() {
        return this.innerProperties() == null ? null : this.innerProperties().keyVaultId();
    }

    public CertificatePatchResource withKeyVaultId(String keyVaultId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificatePatchResourceProperties();
        }
        this.innerProperties().withKeyVaultId(keyVaultId);
        return this;
    }

    public String keyVaultSecretName() {
        return this.innerProperties() == null ? null : this.innerProperties().keyVaultSecretName();
    }

    public CertificatePatchResource withKeyVaultSecretName(String keyVaultSecretName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificatePatchResourceProperties();
        }
        this.innerProperties().withKeyVaultSecretName(keyVaultSecretName);
        return this;
    }

    public KeyVaultSecretStatus keyVaultSecretStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().keyVaultSecretStatus();
    }

    public String serverFarmId() {
        return this.innerProperties() == null ? null : this.innerProperties().serverFarmId();
    }

    public CertificatePatchResource withServerFarmId(String serverFarmId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificatePatchResourceProperties();
        }
        this.innerProperties().withServerFarmId(serverFarmId);
        return this;
    }

    public String canonicalName() {
        return this.innerProperties() == null ? null : this.innerProperties().canonicalName();
    }

    public CertificatePatchResource withCanonicalName(String canonicalName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificatePatchResourceProperties();
        }
        this.innerProperties().withCanonicalName(canonicalName);
        return this;
    }

    public String domainValidationMethod() {
        return this.innerProperties() == null ? null : this.innerProperties().domainValidationMethod();
    }

    public CertificatePatchResource withDomainValidationMethod(String domainValidationMethod) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificatePatchResourceProperties();
        }
        this.innerProperties().withDomainValidationMethod(domainValidationMethod);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static CertificatePatchResource fromJson(JsonReader jsonReader) throws IOException {
        return (CertificatePatchResource)((Object)jsonReader.readObject(reader -> {
            CertificatePatchResource deserializedCertificatePatchResource = new CertificatePatchResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCertificatePatchResource.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedCertificatePatchResource.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCertificatePatchResource.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedCertificatePatchResource.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedCertificatePatchResource.innerProperties = CertificatePatchResourceProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCertificatePatchResource;
        }));
    }
}

