/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.fluent.WebAppsClient;
import com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.azure.resourcemanager.appservice.fluent.models.SiteConfigResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteLogsConfigInner;
import com.azure.resourcemanager.appservice.implementation.FunctionAppImpl;
import com.azure.resourcemanager.appservice.implementation.FunctionDeploymentSlotBasicImpl;
import com.azure.resourcemanager.appservice.implementation.FunctionDeploymentSlotImpl;
import com.azure.resourcemanager.appservice.models.FunctionApp;
import com.azure.resourcemanager.appservice.models.FunctionDeploymentSlot;
import com.azure.resourcemanager.appservice.models.FunctionDeploymentSlotBasic;
import com.azure.resourcemanager.appservice.models.FunctionDeploymentSlots;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.IndependentChildResourcesImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import reactor.core.publisher.Mono;

class FunctionDeploymentSlotsImpl
extends IndependentChildResourcesImpl<FunctionDeploymentSlot, FunctionDeploymentSlotImpl, SiteInner, WebAppsClient, AppServiceManager, FunctionApp>
implements FunctionDeploymentSlots {
    private final FunctionAppImpl parent;

    FunctionDeploymentSlotsImpl(FunctionAppImpl parent) {
        super((Object)((WebSiteManagementClient)((AppServiceManager)parent.manager()).serviceClient()).getWebApps(), (Manager)((AppServiceManager)parent.manager()));
        this.parent = parent;
    }

    protected FunctionDeploymentSlotImpl wrapModel(String name) {
        return (FunctionDeploymentSlotImpl)((FunctionDeploymentSlotImpl)new FunctionDeploymentSlotImpl(name, new SiteInner(), null, null, this.parent).withRegion(this.parent.regionName())).withExistingResourceGroup(this.parent.resourceGroupName());
    }

    protected FunctionDeploymentSlotImpl wrapModel(SiteInner inner) {
        if (inner == null) {
            return null;
        }
        return this.wrapModel(inner, null, null);
    }

    public FunctionDeploymentSlotImpl define(String name) {
        return this.wrapModel(name);
    }

    public Mono<FunctionDeploymentSlot> getByParentAsync(String resourceGroup, String parentName, String name) {
        return ((WebAppsClient)this.innerCollection).getSlotAsync(resourceGroup, parentName, name).flatMap(siteInner -> Mono.zip(((WebAppsClient)this.innerCollection).getConfigurationSlotAsync(resourceGroup, parentName, name.replaceAll(".*/", "")), ((WebAppsClient)this.innerCollection).getDiagnosticLogsConfigurationSlotAsync(resourceGroup, parentName, name.replaceAll(".*/", "")), (siteConfigResourceInner, logsConfigInner) -> this.wrapModel((SiteInner)((Object)siteInner), (SiteConfigResourceInner)((Object)((Object)siteConfigResourceInner)), (SiteLogsConfigInner)((Object)((Object)logsConfigInner)))));
    }

    public PagedIterable<FunctionDeploymentSlot> listByParent(String resourceGroupName, String parentName) {
        return new PagedIterable(this.wrapPageAsync(((WebAppsClient)this.innerCollection).listSlotsAsync(resourceGroupName, parentName)));
    }

    public Mono<Void> deleteByParentAsync(String groupName, String parentName, String name) {
        return ((WebAppsClient)this.innerCollection).deleteSlotAsync(groupName, parentName, name);
    }

    public void deleteByName(String name) {
        this.deleteByParent(this.parent.resourceGroupName(), this.parent.name(), name);
    }

    public Mono<Void> deleteByNameAsync(String name) {
        return this.deleteByParentAsync(this.parent.resourceGroupName(), this.parent.name(), name);
    }

    public PagedIterable<FunctionDeploymentSlotBasic> list() {
        return new PagedIterable(this.listAsync());
    }

    public FunctionDeploymentSlot getByName(String name) {
        return (FunctionDeploymentSlot)this.getByParent(this.parent.resourceGroupName(), this.parent.name(), name);
    }

    public Mono<FunctionDeploymentSlot> getByNameAsync(String name) {
        return this.getByParentAsync(this.parent.resourceGroupName(), this.parent.name(), name);
    }

    public FunctionApp parent() {
        return this.parent;
    }

    public PagedFlux<FunctionDeploymentSlotBasic> listAsync() {
        return PagedConverter.mapPage(((WebAppsClient)this.innerCollection).listSlotsAsync(this.parent.resourceGroupName(), this.parent.name()), inner -> new FunctionDeploymentSlotBasicImpl((SiteInner)((Object)inner), this.parent));
    }

    private FunctionDeploymentSlotImpl wrapModel(SiteInner inner, SiteConfigResourceInner siteConfig, SiteLogsConfigInner logConfig) {
        if (inner == null) {
            return null;
        }
        return new FunctionDeploymentSlotImpl(inner.name(), inner, siteConfig, logConfig, this.parent);
    }
}

