/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.ApiKVReferenceProperties;
import com.azure.resourcemanager.appservice.models.ConfigReferenceSource;
import com.azure.resourcemanager.appservice.models.ManagedServiceIdentity;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.ResolveStatus;
import java.io.IOException;

public final class ApiKVReferenceInner
extends ProxyOnlyResource {
    private ApiKVReferenceProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private ApiKVReferenceProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public ApiKVReferenceInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public String reference() {
        return this.innerProperties() == null ? null : this.innerProperties().reference();
    }

    public ApiKVReferenceInner withReference(String reference) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiKVReferenceProperties();
        }
        this.innerProperties().withReference(reference);
        return this;
    }

    public ResolveStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public ApiKVReferenceInner withStatus(ResolveStatus status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiKVReferenceProperties();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    public String vaultName() {
        return this.innerProperties() == null ? null : this.innerProperties().vaultName();
    }

    public ApiKVReferenceInner withVaultName(String vaultName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiKVReferenceProperties();
        }
        this.innerProperties().withVaultName(vaultName);
        return this;
    }

    public String secretName() {
        return this.innerProperties() == null ? null : this.innerProperties().secretName();
    }

    public ApiKVReferenceInner withSecretName(String secretName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiKVReferenceProperties();
        }
        this.innerProperties().withSecretName(secretName);
        return this;
    }

    public String secretVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().secretVersion();
    }

    public ApiKVReferenceInner withSecretVersion(String secretVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiKVReferenceProperties();
        }
        this.innerProperties().withSecretVersion(secretVersion);
        return this;
    }

    public ManagedServiceIdentity identityType() {
        return this.innerProperties() == null ? null : this.innerProperties().identityType();
    }

    public ApiKVReferenceInner withIdentityType(ManagedServiceIdentity identityType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiKVReferenceProperties();
        }
        this.innerProperties().withIdentityType(identityType);
        return this;
    }

    public String details() {
        return this.innerProperties() == null ? null : this.innerProperties().details();
    }

    public ApiKVReferenceInner withDetails(String details) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiKVReferenceProperties();
        }
        this.innerProperties().withDetails(details);
        return this;
    }

    public ConfigReferenceSource source() {
        return this.innerProperties() == null ? null : this.innerProperties().source();
    }

    public ApiKVReferenceInner withSource(ConfigReferenceSource source) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiKVReferenceProperties();
        }
        this.innerProperties().withSource(source);
        return this;
    }

    public String activeVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().activeVersion();
    }

    public ApiKVReferenceInner withActiveVersion(String activeVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiKVReferenceProperties();
        }
        this.innerProperties().withActiveVersion(activeVersion);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ApiKVReferenceInner fromJson(JsonReader jsonReader) throws IOException {
        return (ApiKVReferenceInner)((Object)jsonReader.readObject(reader -> {
            ApiKVReferenceInner deserializedApiKVReferenceInner = new ApiKVReferenceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedApiKVReferenceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedApiKVReferenceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedApiKVReferenceInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedApiKVReferenceInner.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedApiKVReferenceInner.innerProperties = ApiKVReferenceProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApiKVReferenceInner;
        }));
    }
}

