// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.WorkflowTriggerInner;
import java.io.IOException;
import java.util.List;

/**
 * The list of workflow triggers.
 */
@Fluent
public final class WorkflowTriggerListResult implements JsonSerializable<WorkflowTriggerListResult> {
    /*
     * A list of workflow triggers.
     */
    private List<WorkflowTriggerInner> value;

    /*
     * The URL to get the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of WorkflowTriggerListResult class.
     */
    public WorkflowTriggerListResult() {
    }

    /**
     * Get the value property: A list of workflow triggers.
     * 
     * @return the value value.
     */
    public List<WorkflowTriggerInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of workflow triggers.
     * 
     * @param value the value value to set.
     * @return the WorkflowTriggerListResult object itself.
     */
    public WorkflowTriggerListResult withValue(List<WorkflowTriggerInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to get the next set of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the WorkflowTriggerListResult object itself.
     */
    public WorkflowTriggerListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WorkflowTriggerListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WorkflowTriggerListResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the WorkflowTriggerListResult.
     */
    public static WorkflowTriggerListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WorkflowTriggerListResult deserializedWorkflowTriggerListResult = new WorkflowTriggerListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<WorkflowTriggerInner> value
                        = reader.readArray(reader1 -> WorkflowTriggerInner.fromJson(reader1));
                    deserializedWorkflowTriggerListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedWorkflowTriggerListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWorkflowTriggerListResult;
        });
    }
}
