// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * The workflow filter.
 */
@Fluent
public final class WorkflowArtifacts implements JsonSerializable<WorkflowArtifacts> {
    /*
     * Application settings of the workflow.
     */
    private Object appSettings;

    /*
     * Files of the app.
     */
    private Map<String, Object> files;

    /*
     * Files of the app to delete.
     */
    private List<String> filesToDelete;

    /**
     * Creates an instance of WorkflowArtifacts class.
     */
    public WorkflowArtifacts() {
    }

    /**
     * Get the appSettings property: Application settings of the workflow.
     * 
     * @return the appSettings value.
     */
    public Object appSettings() {
        return this.appSettings;
    }

    /**
     * Set the appSettings property: Application settings of the workflow.
     * 
     * @param appSettings the appSettings value to set.
     * @return the WorkflowArtifacts object itself.
     */
    public WorkflowArtifacts withAppSettings(Object appSettings) {
        this.appSettings = appSettings;
        return this;
    }

    /**
     * Get the files property: Files of the app.
     * 
     * @return the files value.
     */
    public Map<String, Object> files() {
        return this.files;
    }

    /**
     * Set the files property: Files of the app.
     * 
     * @param files the files value to set.
     * @return the WorkflowArtifacts object itself.
     */
    public WorkflowArtifacts withFiles(Map<String, Object> files) {
        this.files = files;
        return this;
    }

    /**
     * Get the filesToDelete property: Files of the app to delete.
     * 
     * @return the filesToDelete value.
     */
    public List<String> filesToDelete() {
        return this.filesToDelete;
    }

    /**
     * Set the filesToDelete property: Files of the app to delete.
     * 
     * @param filesToDelete the filesToDelete value to set.
     * @return the WorkflowArtifacts object itself.
     */
    public WorkflowArtifacts withFilesToDelete(List<String> filesToDelete) {
        this.filesToDelete = filesToDelete;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.appSettings != null) {
            jsonWriter.writeUntypedField("appSettings", this.appSettings);
        }
        jsonWriter.writeMapField("files", this.files, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeArrayField("filesToDelete", this.filesToDelete,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WorkflowArtifacts from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WorkflowArtifacts if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the WorkflowArtifacts.
     */
    public static WorkflowArtifacts fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WorkflowArtifacts deserializedWorkflowArtifacts = new WorkflowArtifacts();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("appSettings".equals(fieldName)) {
                    deserializedWorkflowArtifacts.appSettings = reader.readUntyped();
                } else if ("files".equals(fieldName)) {
                    Map<String, Object> files = reader.readMap(reader1 -> reader1.readUntyped());
                    deserializedWorkflowArtifacts.files = files;
                } else if ("filesToDelete".equals(fieldName)) {
                    List<String> filesToDelete = reader.readArray(reader1 -> reader1.getString());
                    deserializedWorkflowArtifacts.filesToDelete = filesToDelete;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWorkflowArtifacts;
        });
    }
}
