// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * The operation result definition.
 */
@Fluent
public class OperationResult extends OperationResultProperties {
    /*
     * Gets the tracking id.
     */
    private String trackingId;

    /*
     * Gets the inputs.
     */
    private Object inputs;

    /*
     * Gets the link to inputs.
     */
    private ContentLink inputsLink;

    /*
     * Gets the outputs.
     */
    private Object outputs;

    /*
     * Gets the link to outputs.
     */
    private ContentLink outputsLink;

    /*
     * Gets the tracked properties.
     */
    private Object trackedProperties;

    /*
     * Gets the retry histories.
     */
    private List<RetryHistory> retryHistory;

    /*
     * The iterationCount property.
     */
    private Integer iterationCount;

    /**
     * Creates an instance of OperationResult class.
     */
    public OperationResult() {
    }

    /**
     * Get the trackingId property: Gets the tracking id.
     * 
     * @return the trackingId value.
     */
    public String trackingId() {
        return this.trackingId;
    }

    /**
     * Set the trackingId property: Gets the tracking id.
     * 
     * @param trackingId the trackingId value to set.
     * @return the OperationResult object itself.
     */
    OperationResult withTrackingId(String trackingId) {
        this.trackingId = trackingId;
        return this;
    }

    /**
     * Get the inputs property: Gets the inputs.
     * 
     * @return the inputs value.
     */
    public Object inputs() {
        return this.inputs;
    }

    /**
     * Set the inputs property: Gets the inputs.
     * 
     * @param inputs the inputs value to set.
     * @return the OperationResult object itself.
     */
    OperationResult withInputs(Object inputs) {
        this.inputs = inputs;
        return this;
    }

    /**
     * Get the inputsLink property: Gets the link to inputs.
     * 
     * @return the inputsLink value.
     */
    public ContentLink inputsLink() {
        return this.inputsLink;
    }

    /**
     * Set the inputsLink property: Gets the link to inputs.
     * 
     * @param inputsLink the inputsLink value to set.
     * @return the OperationResult object itself.
     */
    OperationResult withInputsLink(ContentLink inputsLink) {
        this.inputsLink = inputsLink;
        return this;
    }

    /**
     * Get the outputs property: Gets the outputs.
     * 
     * @return the outputs value.
     */
    public Object outputs() {
        return this.outputs;
    }

    /**
     * Set the outputs property: Gets the outputs.
     * 
     * @param outputs the outputs value to set.
     * @return the OperationResult object itself.
     */
    OperationResult withOutputs(Object outputs) {
        this.outputs = outputs;
        return this;
    }

    /**
     * Get the outputsLink property: Gets the link to outputs.
     * 
     * @return the outputsLink value.
     */
    public ContentLink outputsLink() {
        return this.outputsLink;
    }

    /**
     * Set the outputsLink property: Gets the link to outputs.
     * 
     * @param outputsLink the outputsLink value to set.
     * @return the OperationResult object itself.
     */
    OperationResult withOutputsLink(ContentLink outputsLink) {
        this.outputsLink = outputsLink;
        return this;
    }

    /**
     * Get the trackedProperties property: Gets the tracked properties.
     * 
     * @return the trackedProperties value.
     */
    public Object trackedProperties() {
        return this.trackedProperties;
    }

    /**
     * Set the trackedProperties property: Gets the tracked properties.
     * 
     * @param trackedProperties the trackedProperties value to set.
     * @return the OperationResult object itself.
     */
    OperationResult withTrackedProperties(Object trackedProperties) {
        this.trackedProperties = trackedProperties;
        return this;
    }

    /**
     * Get the retryHistory property: Gets the retry histories.
     * 
     * @return the retryHistory value.
     */
    public List<RetryHistory> retryHistory() {
        return this.retryHistory;
    }

    /**
     * Set the retryHistory property: Gets the retry histories.
     * 
     * @param retryHistory the retryHistory value to set.
     * @return the OperationResult object itself.
     */
    public OperationResult withRetryHistory(List<RetryHistory> retryHistory) {
        this.retryHistory = retryHistory;
        return this;
    }

    /**
     * Get the iterationCount property: The iterationCount property.
     * 
     * @return the iterationCount value.
     */
    public Integer iterationCount() {
        return this.iterationCount;
    }

    /**
     * Set the iterationCount property: The iterationCount property.
     * 
     * @param iterationCount the iterationCount value to set.
     * @return the OperationResult object itself.
     */
    public OperationResult withIterationCount(Integer iterationCount) {
        this.iterationCount = iterationCount;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public OperationResult withStartTime(OffsetDateTime startTime) {
        super.withStartTime(startTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public OperationResult withEndTime(OffsetDateTime endTime) {
        super.withEndTime(endTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public OperationResult withCorrelation(RunActionCorrelation correlation) {
        super.withCorrelation(correlation);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public OperationResult withStatus(WorkflowStatus status) {
        super.withStatus(status);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public OperationResult withCode(String code) {
        super.withCode(code);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public OperationResult withError(Object error) {
        super.withError(error);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (inputsLink() != null) {
            inputsLink().validate();
        }
        if (outputsLink() != null) {
            outputsLink().validate();
        }
        if (retryHistory() != null) {
            retryHistory().forEach(e -> e.validate());
        }
        if (correlation() != null) {
            correlation().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startTime",
            startTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(startTime()));
        jsonWriter.writeStringField("endTime",
            endTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(endTime()));
        jsonWriter.writeJsonField("correlation", correlation());
        jsonWriter.writeStringField("status", status() == null ? null : status().toString());
        jsonWriter.writeStringField("code", code());
        if (error() != null) {
            jsonWriter.writeUntypedField("error", error());
        }
        jsonWriter.writeArrayField("retryHistory", this.retryHistory, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeNumberField("iterationCount", this.iterationCount);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OperationResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OperationResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the OperationResult.
     */
    public static OperationResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OperationResult deserializedOperationResult = new OperationResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("startTime".equals(fieldName)) {
                    deserializedOperationResult.withStartTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("endTime".equals(fieldName)) {
                    deserializedOperationResult.withEndTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("correlation".equals(fieldName)) {
                    deserializedOperationResult.withCorrelation(RunActionCorrelation.fromJson(reader));
                } else if ("status".equals(fieldName)) {
                    deserializedOperationResult.withStatus(WorkflowStatus.fromString(reader.getString()));
                } else if ("code".equals(fieldName)) {
                    deserializedOperationResult.withCode(reader.getString());
                } else if ("error".equals(fieldName)) {
                    deserializedOperationResult.withError(reader.readUntyped());
                } else if ("trackingId".equals(fieldName)) {
                    deserializedOperationResult.trackingId = reader.getString();
                } else if ("inputs".equals(fieldName)) {
                    deserializedOperationResult.inputs = reader.readUntyped();
                } else if ("inputsLink".equals(fieldName)) {
                    deserializedOperationResult.inputsLink = ContentLink.fromJson(reader);
                } else if ("outputs".equals(fieldName)) {
                    deserializedOperationResult.outputs = reader.readUntyped();
                } else if ("outputsLink".equals(fieldName)) {
                    deserializedOperationResult.outputsLink = ContentLink.fromJson(reader);
                } else if ("trackedProperties".equals(fieldName)) {
                    deserializedOperationResult.trackedProperties = reader.readUntyped();
                } else if ("retryHistory".equals(fieldName)) {
                    List<RetryHistory> retryHistory = reader.readArray(reader1 -> RetryHistory.fromJson(reader1));
                    deserializedOperationResult.retryHistory = retryHistory;
                } else if ("iterationCount".equals(fieldName)) {
                    deserializedOperationResult.iterationCount = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOperationResult;
        });
    }
}
