// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Definition of a single resource metric.
 */
@Fluent
public final class MetricSpecification implements JsonSerializable<MetricSpecification> {
    /*
     * The name property.
     */
    private String name;

    /*
     * The displayName property.
     */
    private String displayName;

    /*
     * The displayDescription property.
     */
    private String displayDescription;

    /*
     * The unit property.
     */
    private String unit;

    /*
     * The aggregationType property.
     */
    private String aggregationType;

    /*
     * The supportsInstanceLevelAggregation property.
     */
    private Boolean supportsInstanceLevelAggregation;

    /*
     * The enableRegionalMdmAccount property.
     */
    private Boolean enableRegionalMdmAccount;

    /*
     * The sourceMdmAccount property.
     */
    private String sourceMdmAccount;

    /*
     * The sourceMdmNamespace property.
     */
    private String sourceMdmNamespace;

    /*
     * The metricFilterPattern property.
     */
    private String metricFilterPattern;

    /*
     * The fillGapWithZero property.
     */
    private Boolean fillGapWithZero;

    /*
     * The isInternal property.
     */
    private Boolean isInternal;

    /*
     * The dimensions property.
     */
    private List<Dimension> dimensions;

    /*
     * The category property.
     */
    private String category;

    /*
     * The availabilities property.
     */
    private List<MetricAvailability> availabilities;

    /*
     * The supportedTimeGrainTypes property.
     */
    private List<String> supportedTimeGrainTypes;

    /*
     * The supportedAggregationTypes property.
     */
    private List<String> supportedAggregationTypes;

    /**
     * Creates an instance of MetricSpecification class.
     */
    public MetricSpecification() {
    }

    /**
     * Get the name property: The name property.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name property.
     * 
     * @param name the name value to set.
     * @return the MetricSpecification object itself.
     */
    public MetricSpecification withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the displayName property: The displayName property.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The displayName property.
     * 
     * @param displayName the displayName value to set.
     * @return the MetricSpecification object itself.
     */
    public MetricSpecification withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the displayDescription property: The displayDescription property.
     * 
     * @return the displayDescription value.
     */
    public String displayDescription() {
        return this.displayDescription;
    }

    /**
     * Set the displayDescription property: The displayDescription property.
     * 
     * @param displayDescription the displayDescription value to set.
     * @return the MetricSpecification object itself.
     */
    public MetricSpecification withDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    /**
     * Get the unit property: The unit property.
     * 
     * @return the unit value.
     */
    public String unit() {
        return this.unit;
    }

    /**
     * Set the unit property: The unit property.
     * 
     * @param unit the unit value to set.
     * @return the MetricSpecification object itself.
     */
    public MetricSpecification withUnit(String unit) {
        this.unit = unit;
        return this;
    }

    /**
     * Get the aggregationType property: The aggregationType property.
     * 
     * @return the aggregationType value.
     */
    public String aggregationType() {
        return this.aggregationType;
    }

    /**
     * Set the aggregationType property: The aggregationType property.
     * 
     * @param aggregationType the aggregationType value to set.
     * @return the MetricSpecification object itself.
     */
    public MetricSpecification withAggregationType(String aggregationType) {
        this.aggregationType = aggregationType;
        return this;
    }

    /**
     * Get the supportsInstanceLevelAggregation property: The supportsInstanceLevelAggregation property.
     * 
     * @return the supportsInstanceLevelAggregation value.
     */
    public Boolean supportsInstanceLevelAggregation() {
        return this.supportsInstanceLevelAggregation;
    }

    /**
     * Set the supportsInstanceLevelAggregation property: The supportsInstanceLevelAggregation property.
     * 
     * @param supportsInstanceLevelAggregation the supportsInstanceLevelAggregation value to set.
     * @return the MetricSpecification object itself.
     */
    public MetricSpecification withSupportsInstanceLevelAggregation(Boolean supportsInstanceLevelAggregation) {
        this.supportsInstanceLevelAggregation = supportsInstanceLevelAggregation;
        return this;
    }

    /**
     * Get the enableRegionalMdmAccount property: The enableRegionalMdmAccount property.
     * 
     * @return the enableRegionalMdmAccount value.
     */
    public Boolean enableRegionalMdmAccount() {
        return this.enableRegionalMdmAccount;
    }

    /**
     * Set the enableRegionalMdmAccount property: The enableRegionalMdmAccount property.
     * 
     * @param enableRegionalMdmAccount the enableRegionalMdmAccount value to set.
     * @return the MetricSpecification object itself.
     */
    public MetricSpecification withEnableRegionalMdmAccount(Boolean enableRegionalMdmAccount) {
        this.enableRegionalMdmAccount = enableRegionalMdmAccount;
        return this;
    }

    /**
     * Get the sourceMdmAccount property: The sourceMdmAccount property.
     * 
     * @return the sourceMdmAccount value.
     */
    public String sourceMdmAccount() {
        return this.sourceMdmAccount;
    }

    /**
     * Set the sourceMdmAccount property: The sourceMdmAccount property.
     * 
     * @param sourceMdmAccount the sourceMdmAccount value to set.
     * @return the MetricSpecification object itself.
     */
    public MetricSpecification withSourceMdmAccount(String sourceMdmAccount) {
        this.sourceMdmAccount = sourceMdmAccount;
        return this;
    }

    /**
     * Get the sourceMdmNamespace property: The sourceMdmNamespace property.
     * 
     * @return the sourceMdmNamespace value.
     */
    public String sourceMdmNamespace() {
        return this.sourceMdmNamespace;
    }

    /**
     * Set the sourceMdmNamespace property: The sourceMdmNamespace property.
     * 
     * @param sourceMdmNamespace the sourceMdmNamespace value to set.
     * @return the MetricSpecification object itself.
     */
    public MetricSpecification withSourceMdmNamespace(String sourceMdmNamespace) {
        this.sourceMdmNamespace = sourceMdmNamespace;
        return this;
    }

    /**
     * Get the metricFilterPattern property: The metricFilterPattern property.
     * 
     * @return the metricFilterPattern value.
     */
    public String metricFilterPattern() {
        return this.metricFilterPattern;
    }

    /**
     * Set the metricFilterPattern property: The metricFilterPattern property.
     * 
     * @param metricFilterPattern the metricFilterPattern value to set.
     * @return the MetricSpecification object itself.
     */
    public MetricSpecification withMetricFilterPattern(String metricFilterPattern) {
        this.metricFilterPattern = metricFilterPattern;
        return this;
    }

    /**
     * Get the fillGapWithZero property: The fillGapWithZero property.
     * 
     * @return the fillGapWithZero value.
     */
    public Boolean fillGapWithZero() {
        return this.fillGapWithZero;
    }

    /**
     * Set the fillGapWithZero property: The fillGapWithZero property.
     * 
     * @param fillGapWithZero the fillGapWithZero value to set.
     * @return the MetricSpecification object itself.
     */
    public MetricSpecification withFillGapWithZero(Boolean fillGapWithZero) {
        this.fillGapWithZero = fillGapWithZero;
        return this;
    }

    /**
     * Get the isInternal property: The isInternal property.
     * 
     * @return the isInternal value.
     */
    public Boolean isInternal() {
        return this.isInternal;
    }

    /**
     * Set the isInternal property: The isInternal property.
     * 
     * @param isInternal the isInternal value to set.
     * @return the MetricSpecification object itself.
     */
    public MetricSpecification withIsInternal(Boolean isInternal) {
        this.isInternal = isInternal;
        return this;
    }

    /**
     * Get the dimensions property: The dimensions property.
     * 
     * @return the dimensions value.
     */
    public List<Dimension> dimensions() {
        return this.dimensions;
    }

    /**
     * Set the dimensions property: The dimensions property.
     * 
     * @param dimensions the dimensions value to set.
     * @return the MetricSpecification object itself.
     */
    public MetricSpecification withDimensions(List<Dimension> dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    /**
     * Get the category property: The category property.
     * 
     * @return the category value.
     */
    public String category() {
        return this.category;
    }

    /**
     * Set the category property: The category property.
     * 
     * @param category the category value to set.
     * @return the MetricSpecification object itself.
     */
    public MetricSpecification withCategory(String category) {
        this.category = category;
        return this;
    }

    /**
     * Get the availabilities property: The availabilities property.
     * 
     * @return the availabilities value.
     */
    public List<MetricAvailability> availabilities() {
        return this.availabilities;
    }

    /**
     * Set the availabilities property: The availabilities property.
     * 
     * @param availabilities the availabilities value to set.
     * @return the MetricSpecification object itself.
     */
    public MetricSpecification withAvailabilities(List<MetricAvailability> availabilities) {
        this.availabilities = availabilities;
        return this;
    }

    /**
     * Get the supportedTimeGrainTypes property: The supportedTimeGrainTypes property.
     * 
     * @return the supportedTimeGrainTypes value.
     */
    public List<String> supportedTimeGrainTypes() {
        return this.supportedTimeGrainTypes;
    }

    /**
     * Set the supportedTimeGrainTypes property: The supportedTimeGrainTypes property.
     * 
     * @param supportedTimeGrainTypes the supportedTimeGrainTypes value to set.
     * @return the MetricSpecification object itself.
     */
    public MetricSpecification withSupportedTimeGrainTypes(List<String> supportedTimeGrainTypes) {
        this.supportedTimeGrainTypes = supportedTimeGrainTypes;
        return this;
    }

    /**
     * Get the supportedAggregationTypes property: The supportedAggregationTypes property.
     * 
     * @return the supportedAggregationTypes value.
     */
    public List<String> supportedAggregationTypes() {
        return this.supportedAggregationTypes;
    }

    /**
     * Set the supportedAggregationTypes property: The supportedAggregationTypes property.
     * 
     * @param supportedAggregationTypes the supportedAggregationTypes value to set.
     * @return the MetricSpecification object itself.
     */
    public MetricSpecification withSupportedAggregationTypes(List<String> supportedAggregationTypes) {
        this.supportedAggregationTypes = supportedAggregationTypes;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (dimensions() != null) {
            dimensions().forEach(e -> e.validate());
        }
        if (availabilities() != null) {
            availabilities().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("displayDescription", this.displayDescription);
        jsonWriter.writeStringField("unit", this.unit);
        jsonWriter.writeStringField("aggregationType", this.aggregationType);
        jsonWriter.writeBooleanField("supportsInstanceLevelAggregation", this.supportsInstanceLevelAggregation);
        jsonWriter.writeBooleanField("enableRegionalMdmAccount", this.enableRegionalMdmAccount);
        jsonWriter.writeStringField("sourceMdmAccount", this.sourceMdmAccount);
        jsonWriter.writeStringField("sourceMdmNamespace", this.sourceMdmNamespace);
        jsonWriter.writeStringField("metricFilterPattern", this.metricFilterPattern);
        jsonWriter.writeBooleanField("fillGapWithZero", this.fillGapWithZero);
        jsonWriter.writeBooleanField("isInternal", this.isInternal);
        jsonWriter.writeArrayField("dimensions", this.dimensions, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("category", this.category);
        jsonWriter.writeArrayField("availabilities", this.availabilities,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("supportedTimeGrainTypes", this.supportedTimeGrainTypes,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("supportedAggregationTypes", this.supportedAggregationTypes,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MetricSpecification from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MetricSpecification if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the MetricSpecification.
     */
    public static MetricSpecification fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MetricSpecification deserializedMetricSpecification = new MetricSpecification();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedMetricSpecification.name = reader.getString();
                } else if ("displayName".equals(fieldName)) {
                    deserializedMetricSpecification.displayName = reader.getString();
                } else if ("displayDescription".equals(fieldName)) {
                    deserializedMetricSpecification.displayDescription = reader.getString();
                } else if ("unit".equals(fieldName)) {
                    deserializedMetricSpecification.unit = reader.getString();
                } else if ("aggregationType".equals(fieldName)) {
                    deserializedMetricSpecification.aggregationType = reader.getString();
                } else if ("supportsInstanceLevelAggregation".equals(fieldName)) {
                    deserializedMetricSpecification.supportsInstanceLevelAggregation
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("enableRegionalMdmAccount".equals(fieldName)) {
                    deserializedMetricSpecification.enableRegionalMdmAccount
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("sourceMdmAccount".equals(fieldName)) {
                    deserializedMetricSpecification.sourceMdmAccount = reader.getString();
                } else if ("sourceMdmNamespace".equals(fieldName)) {
                    deserializedMetricSpecification.sourceMdmNamespace = reader.getString();
                } else if ("metricFilterPattern".equals(fieldName)) {
                    deserializedMetricSpecification.metricFilterPattern = reader.getString();
                } else if ("fillGapWithZero".equals(fieldName)) {
                    deserializedMetricSpecification.fillGapWithZero = reader.getNullable(JsonReader::getBoolean);
                } else if ("isInternal".equals(fieldName)) {
                    deserializedMetricSpecification.isInternal = reader.getNullable(JsonReader::getBoolean);
                } else if ("dimensions".equals(fieldName)) {
                    List<Dimension> dimensions = reader.readArray(reader1 -> Dimension.fromJson(reader1));
                    deserializedMetricSpecification.dimensions = dimensions;
                } else if ("category".equals(fieldName)) {
                    deserializedMetricSpecification.category = reader.getString();
                } else if ("availabilities".equals(fieldName)) {
                    List<MetricAvailability> availabilities
                        = reader.readArray(reader1 -> MetricAvailability.fromJson(reader1));
                    deserializedMetricSpecification.availabilities = availabilities;
                } else if ("supportedTimeGrainTypes".equals(fieldName)) {
                    List<String> supportedTimeGrainTypes = reader.readArray(reader1 -> reader1.getString());
                    deserializedMetricSpecification.supportedTimeGrainTypes = supportedTimeGrainTypes;
                } else if ("supportedAggregationTypes".equals(fieldName)) {
                    List<String> supportedAggregationTypes = reader.readArray(reader1 -> reader1.getString());
                    deserializedMetricSpecification.supportedAggregationTypes = supportedAggregationTypes;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMetricSpecification;
        });
    }
}
