// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The endpoints configuration.
 */
@Fluent
public final class FlowEndpointsConfiguration implements JsonSerializable<FlowEndpointsConfiguration> {
    /*
     * The workflow endpoints.
     */
    private FlowEndpoints workflow;

    /*
     * The connector endpoints.
     */
    private FlowEndpoints connector;

    /**
     * Creates an instance of FlowEndpointsConfiguration class.
     */
    public FlowEndpointsConfiguration() {
    }

    /**
     * Get the workflow property: The workflow endpoints.
     * 
     * @return the workflow value.
     */
    public FlowEndpoints workflow() {
        return this.workflow;
    }

    /**
     * Set the workflow property: The workflow endpoints.
     * 
     * @param workflow the workflow value to set.
     * @return the FlowEndpointsConfiguration object itself.
     */
    public FlowEndpointsConfiguration withWorkflow(FlowEndpoints workflow) {
        this.workflow = workflow;
        return this;
    }

    /**
     * Get the connector property: The connector endpoints.
     * 
     * @return the connector value.
     */
    public FlowEndpoints connector() {
        return this.connector;
    }

    /**
     * Set the connector property: The connector endpoints.
     * 
     * @param connector the connector value to set.
     * @return the FlowEndpointsConfiguration object itself.
     */
    public FlowEndpointsConfiguration withConnector(FlowEndpoints connector) {
        this.connector = connector;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (workflow() != null) {
            workflow().validate();
        }
        if (connector() != null) {
            connector().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("workflow", this.workflow);
        jsonWriter.writeJsonField("connector", this.connector);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FlowEndpointsConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FlowEndpointsConfiguration if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FlowEndpointsConfiguration.
     */
    public static FlowEndpointsConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FlowEndpointsConfiguration deserializedFlowEndpointsConfiguration = new FlowEndpointsConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("workflow".equals(fieldName)) {
                    deserializedFlowEndpointsConfiguration.workflow = FlowEndpoints.fromJson(reader);
                } else if ("connector".equals(fieldName)) {
                    deserializedFlowEndpointsConfiguration.connector = FlowEndpoints.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFlowEndpointsConfiguration;
        });
    }
}
