// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The expression root.
 */
@Fluent
public final class ExpressionRoot extends Expression {
    /*
     * The path.
     */
    private String path;

    /**
     * Creates an instance of ExpressionRoot class.
     */
    public ExpressionRoot() {
    }

    /**
     * Get the path property: The path.
     * 
     * @return the path value.
     */
    public String path() {
        return this.path;
    }

    /**
     * Set the path property: The path.
     * 
     * @param path the path value to set.
     * @return the ExpressionRoot object itself.
     */
    public ExpressionRoot withPath(String path) {
        this.path = path;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ExpressionRoot withText(String text) {
        super.withText(text);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ExpressionRoot withValue(Object value) {
        super.withValue(value);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ExpressionRoot withSubexpressions(List<Expression> subexpressions) {
        super.withSubexpressions(subexpressions);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ExpressionRoot withError(AzureResourceErrorInfo error) {
        super.withError(error);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (subexpressions() != null) {
            subexpressions().forEach(e -> e.validate());
        }
        if (error() != null) {
            error().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", text());
        if (value() != null) {
            jsonWriter.writeUntypedField("value", value());
        }
        jsonWriter.writeArrayField("subexpressions", subexpressions(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("error", error());
        jsonWriter.writeStringField("path", this.path);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExpressionRoot from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExpressionRoot if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ExpressionRoot.
     */
    public static ExpressionRoot fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressionRoot deserializedExpressionRoot = new ExpressionRoot();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("text".equals(fieldName)) {
                    deserializedExpressionRoot.withText(reader.getString());
                } else if ("value".equals(fieldName)) {
                    deserializedExpressionRoot.withValue(reader.readUntyped());
                } else if ("subexpressions".equals(fieldName)) {
                    List<Expression> subexpressions = reader.readArray(reader1 -> Expression.fromJson(reader1));
                    deserializedExpressionRoot.withSubexpressions(subexpressions);
                } else if ("error".equals(fieldName)) {
                    deserializedExpressionRoot.withError(AzureResourceErrorInfo.fromJson(reader));
                } else if ("path".equals(fieldName)) {
                    deserializedExpressionRoot.path = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExpressionRoot;
        });
    }
}
