// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The DnlResourceNameAvailabilityRequest model.
 */
@Fluent
public final class DnlResourceNameAvailabilityRequest implements JsonSerializable<DnlResourceNameAvailabilityRequest> {
    /*
     * Resource group name
     */
    private String resourceGroupName;

    /*
     * Indicates the endpoint name reuse scope.The default value is TenantReuse.
     * Supported values are TenantReuse, SubscriptionReuse, ResourceGroupReuse, NoReuse
     */
    private String autoGeneratedDomainNameLabelScope;

    /*
     * Resource name to verify.
     */
    private String name;

    /*
     * Resource type used for verification.
     */
    private CheckNameResourceTypes type;

    /**
     * Creates an instance of DnlResourceNameAvailabilityRequest class.
     */
    public DnlResourceNameAvailabilityRequest() {
    }

    /**
     * Get the resourceGroupName property: Resource group name.
     * 
     * @return the resourceGroupName value.
     */
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    /**
     * Set the resourceGroupName property: Resource group name.
     * 
     * @param resourceGroupName the resourceGroupName value to set.
     * @return the DnlResourceNameAvailabilityRequest object itself.
     */
    public DnlResourceNameAvailabilityRequest withResourceGroupName(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    /**
     * Get the autoGeneratedDomainNameLabelScope property: Indicates the endpoint name reuse scope.The default value is
     * TenantReuse.
     * Supported values are TenantReuse, SubscriptionReuse, ResourceGroupReuse, NoReuse.
     * 
     * @return the autoGeneratedDomainNameLabelScope value.
     */
    public String autoGeneratedDomainNameLabelScope() {
        return this.autoGeneratedDomainNameLabelScope;
    }

    /**
     * Set the autoGeneratedDomainNameLabelScope property: Indicates the endpoint name reuse scope.The default value is
     * TenantReuse.
     * Supported values are TenantReuse, SubscriptionReuse, ResourceGroupReuse, NoReuse.
     * 
     * @param autoGeneratedDomainNameLabelScope the autoGeneratedDomainNameLabelScope value to set.
     * @return the DnlResourceNameAvailabilityRequest object itself.
     */
    public DnlResourceNameAvailabilityRequest
        withAutoGeneratedDomainNameLabelScope(String autoGeneratedDomainNameLabelScope) {
        this.autoGeneratedDomainNameLabelScope = autoGeneratedDomainNameLabelScope;
        return this;
    }

    /**
     * Get the name property: Resource name to verify.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Resource name to verify.
     * 
     * @param name the name value to set.
     * @return the DnlResourceNameAvailabilityRequest object itself.
     */
    public DnlResourceNameAvailabilityRequest withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: Resource type used for verification.
     * 
     * @return the type value.
     */
    public CheckNameResourceTypes type() {
        return this.type;
    }

    /**
     * Set the type property: Resource type used for verification.
     * 
     * @param type the type value to set.
     * @return the DnlResourceNameAvailabilityRequest object itself.
     */
    public DnlResourceNameAvailabilityRequest withType(CheckNameResourceTypes type) {
        this.type = type;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property name in model DnlResourceNameAvailabilityRequest"));
        }
        if (type() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property type in model DnlResourceNameAvailabilityRequest"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DnlResourceNameAvailabilityRequest.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("resourceGroupName", this.resourceGroupName);
        jsonWriter.writeStringField("autoGeneratedDomainNameLabelScope", this.autoGeneratedDomainNameLabelScope);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DnlResourceNameAvailabilityRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DnlResourceNameAvailabilityRequest if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DnlResourceNameAvailabilityRequest.
     */
    public static DnlResourceNameAvailabilityRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DnlResourceNameAvailabilityRequest deserializedDnlResourceNameAvailabilityRequest
                = new DnlResourceNameAvailabilityRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedDnlResourceNameAvailabilityRequest.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedDnlResourceNameAvailabilityRequest.type
                        = CheckNameResourceTypes.fromString(reader.getString());
                } else if ("resourceGroupName".equals(fieldName)) {
                    deserializedDnlResourceNameAvailabilityRequest.resourceGroupName = reader.getString();
                } else if ("autoGeneratedDomainNameLabelScope".equals(fieldName)) {
                    deserializedDnlResourceNameAvailabilityRequest.autoGeneratedDomainNameLabelScope
                        = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDnlResourceNameAvailabilityRequest;
        });
    }
}
