// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The configuration settings of the app registration for providers that have client ids and client secrets.
 */
@Fluent
public final class ClientRegistration implements JsonSerializable<ClientRegistration> {
    /*
     * The Client ID of the app used for login.
     */
    private String clientId;

    /*
     * The app setting name that contains the client secret.
     */
    private String clientSecretSettingName;

    /**
     * Creates an instance of ClientRegistration class.
     */
    public ClientRegistration() {
    }

    /**
     * Get the clientId property: The Client ID of the app used for login.
     * 
     * @return the clientId value.
     */
    public String clientId() {
        return this.clientId;
    }

    /**
     * Set the clientId property: The Client ID of the app used for login.
     * 
     * @param clientId the clientId value to set.
     * @return the ClientRegistration object itself.
     */
    public ClientRegistration withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    /**
     * Get the clientSecretSettingName property: The app setting name that contains the client secret.
     * 
     * @return the clientSecretSettingName value.
     */
    public String clientSecretSettingName() {
        return this.clientSecretSettingName;
    }

    /**
     * Set the clientSecretSettingName property: The app setting name that contains the client secret.
     * 
     * @param clientSecretSettingName the clientSecretSettingName value to set.
     * @return the ClientRegistration object itself.
     */
    public ClientRegistration withClientSecretSettingName(String clientSecretSettingName) {
        this.clientSecretSettingName = clientSecretSettingName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("clientId", this.clientId);
        jsonWriter.writeStringField("clientSecretSettingName", this.clientSecretSettingName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ClientRegistration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ClientRegistration if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ClientRegistration.
     */
    public static ClientRegistration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ClientRegistration deserializedClientRegistration = new ClientRegistration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("clientId".equals(fieldName)) {
                    deserializedClientRegistration.clientId = reader.getString();
                } else if ("clientSecretSettingName".equals(fieldName)) {
                    deserializedClientRegistration.clientSecretSettingName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedClientRegistration;
        });
    }
}
