// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

/**
 * Specifies the scope of uniqueness for the default hostname during resource creation.
 */
public enum AutoGeneratedDomainNameLabelScope {
    /**
     * Enum value TenantReuse.
     */
    TENANT_REUSE("TenantReuse"),

    /**
     * Enum value SubscriptionReuse.
     */
    SUBSCRIPTION_REUSE("SubscriptionReuse"),

    /**
     * Enum value ResourceGroupReuse.
     */
    RESOURCE_GROUP_REUSE("ResourceGroupReuse"),

    /**
     * Enum value NoReuse.
     */
    NO_REUSE("NoReuse");

    /**
     * The actual serialized value for a AutoGeneratedDomainNameLabelScope instance.
     */
    private final String value;

    AutoGeneratedDomainNameLabelScope(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a AutoGeneratedDomainNameLabelScope instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed AutoGeneratedDomainNameLabelScope object, or null if unable to parse.
     */
    public static AutoGeneratedDomainNameLabelScope fromString(String value) {
        if (value == null) {
            return null;
        }
        AutoGeneratedDomainNameLabelScope[] items = AutoGeneratedDomainNameLabelScope.values();
        for (AutoGeneratedDomainNameLabelScope item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
