// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Application logs configuration.
 */
@Fluent
public final class ApplicationLogsConfig implements JsonSerializable<ApplicationLogsConfig> {
    /*
     * Application logs to file system configuration.
     */
    private FileSystemApplicationLogsConfig fileSystem;

    /*
     * Application logs to azure table storage configuration.
     */
    private AzureTableStorageApplicationLogsConfig azureTableStorage;

    /*
     * Application logs to blob storage configuration.
     */
    private AzureBlobStorageApplicationLogsConfig azureBlobStorage;

    /**
     * Creates an instance of ApplicationLogsConfig class.
     */
    public ApplicationLogsConfig() {
    }

    /**
     * Get the fileSystem property: Application logs to file system configuration.
     * 
     * @return the fileSystem value.
     */
    public FileSystemApplicationLogsConfig fileSystem() {
        return this.fileSystem;
    }

    /**
     * Set the fileSystem property: Application logs to file system configuration.
     * 
     * @param fileSystem the fileSystem value to set.
     * @return the ApplicationLogsConfig object itself.
     */
    public ApplicationLogsConfig withFileSystem(FileSystemApplicationLogsConfig fileSystem) {
        this.fileSystem = fileSystem;
        return this;
    }

    /**
     * Get the azureTableStorage property: Application logs to azure table storage configuration.
     * 
     * @return the azureTableStorage value.
     */
    public AzureTableStorageApplicationLogsConfig azureTableStorage() {
        return this.azureTableStorage;
    }

    /**
     * Set the azureTableStorage property: Application logs to azure table storage configuration.
     * 
     * @param azureTableStorage the azureTableStorage value to set.
     * @return the ApplicationLogsConfig object itself.
     */
    public ApplicationLogsConfig withAzureTableStorage(AzureTableStorageApplicationLogsConfig azureTableStorage) {
        this.azureTableStorage = azureTableStorage;
        return this;
    }

    /**
     * Get the azureBlobStorage property: Application logs to blob storage configuration.
     * 
     * @return the azureBlobStorage value.
     */
    public AzureBlobStorageApplicationLogsConfig azureBlobStorage() {
        return this.azureBlobStorage;
    }

    /**
     * Set the azureBlobStorage property: Application logs to blob storage configuration.
     * 
     * @param azureBlobStorage the azureBlobStorage value to set.
     * @return the ApplicationLogsConfig object itself.
     */
    public ApplicationLogsConfig withAzureBlobStorage(AzureBlobStorageApplicationLogsConfig azureBlobStorage) {
        this.azureBlobStorage = azureBlobStorage;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (fileSystem() != null) {
            fileSystem().validate();
        }
        if (azureTableStorage() != null) {
            azureTableStorage().validate();
        }
        if (azureBlobStorage() != null) {
            azureBlobStorage().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("fileSystem", this.fileSystem);
        jsonWriter.writeJsonField("azureTableStorage", this.azureTableStorage);
        jsonWriter.writeJsonField("azureBlobStorage", this.azureBlobStorage);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationLogsConfig from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationLogsConfig if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationLogsConfig.
     */
    public static ApplicationLogsConfig fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationLogsConfig deserializedApplicationLogsConfig = new ApplicationLogsConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("fileSystem".equals(fieldName)) {
                    deserializedApplicationLogsConfig.fileSystem = FileSystemApplicationLogsConfig.fromJson(reader);
                } else if ("azureTableStorage".equals(fieldName)) {
                    deserializedApplicationLogsConfig.azureTableStorage
                        = AzureTableStorageApplicationLogsConfig.fromJson(reader);
                } else if ("azureBlobStorage".equals(fieldName)) {
                    deserializedApplicationLogsConfig.azureBlobStorage
                        = AzureBlobStorageApplicationLogsConfig.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationLogsConfig;
        });
    }
}
