// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.appservice.fluent.SiteCertificatesClient;
import com.azure.resourcemanager.appservice.fluent.models.CertificateInner;
import com.azure.resourcemanager.appservice.models.CertificateCollection;
import com.azure.resourcemanager.appservice.models.CertificatePatchResource;
import com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in SiteCertificatesClient.
 */
public final class SiteCertificatesClientImpl implements SiteCertificatesClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final SiteCertificatesService service;

    /**
     * The service client containing this operation class.
     */
    private final WebSiteManagementClientImpl client;

    /**
     * Initializes an instance of SiteCertificatesClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    SiteCertificatesClientImpl(WebSiteManagementClientImpl client) {
        this.service
            = RestProxy.create(SiteCertificatesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for WebSiteManagementClientSiteCertificates to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "WebSiteManagementCli")
    public interface SiteCertificatesService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/certificates")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<CertificateCollection>> list(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/certificates/{certificateName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<CertificateInner>> get(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("certificateName") String certificateName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/certificates/{certificateName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<CertificateInner>> createOrUpdate(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("certificateName") String certificateName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CertificateInner certificateEnvelope, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/certificates/{certificateName}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> delete(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("certificateName") String certificateName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/certificates/{certificateName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<CertificateInner>> update(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("certificateName") String certificateName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CertificatePatchResource certificateEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/certificates")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<CertificateCollection>> listSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/certificates/{certificateName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<CertificateInner>> getSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("certificateName") String certificateName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/certificates/{certificateName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<CertificateInner>> createOrUpdateSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("subscriptionId") String subscriptionId, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("certificateName") String certificateName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CertificateInner certificateEnvelope, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/certificates/{certificateName}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> deleteSlot(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("certificateName") String certificateName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/certificates/{certificateName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<CertificateInner>> updateSlot(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("slot") String slot, @PathParam("certificateName") String certificateName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CertificatePatchResource certificateEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<CertificateCollection>> listNext(@PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<CertificateCollection>> listSlotNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Get all certificates in a resource group under a site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all certificates in a resource group under a site along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<CertificateInner>> listSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.list(this.client.getEndpoint(), resourceGroupName, name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .<PagedResponse<CertificateInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get all certificates in a resource group under a site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all certificates in a resource group under a site along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<CertificateInner>> listSinglePageAsync(String resourceGroupName, String name,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(),
                this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get all certificates in a resource group under a site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all certificates in a resource group under a site as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<CertificateInner> listAsync(String resourceGroupName, String name) {
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, name),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Get all certificates in a resource group under a site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all certificates in a resource group under a site as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<CertificateInner> listAsync(String resourceGroupName, String name, Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, name, context),
            nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get all certificates in a resource group under a site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all certificates in a resource group under a site as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<CertificateInner> list(String resourceGroupName, String name) {
        return new PagedIterable<>(listAsync(resourceGroupName, name));
    }

    /**
     * Get all certificates in a resource group under a site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all certificates in a resource group under a site as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<CertificateInner> list(String resourceGroupName, String name, Context context) {
        return new PagedIterable<>(listAsync(resourceGroupName, name, context));
    }

    /**
     * Get a certificate belonging to a given site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param certificateName Name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate belonging to a given site along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CertificateInner>> getWithResponseAsync(String resourceGroupName, String name,
        String certificateName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (certificateName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter certificateName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.get(this.client.getEndpoint(), resourceGroupName, name, certificateName,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get a certificate belonging to a given site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param certificateName Name of the certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate belonging to a given site along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<CertificateInner>> getWithResponseAsync(String resourceGroupName, String name,
        String certificateName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (certificateName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter certificateName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), resourceGroupName, name, certificateName,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Get a certificate belonging to a given site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param certificateName Name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate belonging to a given site on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CertificateInner> getAsync(String resourceGroupName, String name, String certificateName) {
        return getWithResponseAsync(resourceGroupName, name, certificateName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get a certificate belonging to a given site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param certificateName Name of the certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate belonging to a given site along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CertificateInner> getWithResponse(String resourceGroupName, String name, String certificateName,
        Context context) {
        return getWithResponseAsync(resourceGroupName, name, certificateName, context).block();
    }

    /**
     * Get a certificate belonging to a given site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param certificateName Name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate belonging to a given site.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CertificateInner get(String resourceGroupName, String name, String certificateName) {
        return getWithResponse(resourceGroupName, name, certificateName, Context.NONE).getValue();
    }

    /**
     * Create or update a certificate under a given site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param certificateName Name of the certificate.
     * @param certificateEnvelope Details of certificate, if it exists already.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sSL certificate for an app along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CertificateInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String name,
        String certificateName, CertificateInner certificateEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (certificateName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter certificateName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (certificateEnvelope == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter certificateEnvelope is required and cannot be null."));
        } else {
            certificateEnvelope.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, name, certificateName,
                    this.client.getSubscriptionId(), this.client.getApiVersion(), certificateEnvelope, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create or update a certificate under a given site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param certificateName Name of the certificate.
     * @param certificateEnvelope Details of certificate, if it exists already.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sSL certificate for an app along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<CertificateInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String name,
        String certificateName, CertificateInner certificateEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (certificateName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter certificateName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (certificateEnvelope == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter certificateEnvelope is required and cannot be null."));
        } else {
            certificateEnvelope.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, name, certificateName,
            this.client.getSubscriptionId(), this.client.getApiVersion(), certificateEnvelope, accept, context);
    }

    /**
     * Create or update a certificate under a given site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param certificateName Name of the certificate.
     * @param certificateEnvelope Details of certificate, if it exists already.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sSL certificate for an app on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CertificateInner> createOrUpdateAsync(String resourceGroupName, String name, String certificateName,
        CertificateInner certificateEnvelope) {
        return createOrUpdateWithResponseAsync(resourceGroupName, name, certificateName, certificateEnvelope)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Create or update a certificate under a given site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param certificateName Name of the certificate.
     * @param certificateEnvelope Details of certificate, if it exists already.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sSL certificate for an app along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CertificateInner> createOrUpdateWithResponse(String resourceGroupName, String name,
        String certificateName, CertificateInner certificateEnvelope, Context context) {
        return createOrUpdateWithResponseAsync(resourceGroupName, name, certificateName, certificateEnvelope, context)
            .block();
    }

    /**
     * Create or update a certificate under a given site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param certificateName Name of the certificate.
     * @param certificateEnvelope Details of certificate, if it exists already.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sSL certificate for an app.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CertificateInner createOrUpdate(String resourceGroupName, String name, String certificateName,
        CertificateInner certificateEnvelope) {
        return createOrUpdateWithResponse(resourceGroupName, name, certificateName, certificateEnvelope, Context.NONE)
            .getValue();
    }

    /**
     * Delete a certificate from the site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param certificateName Name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String name, String certificateName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (certificateName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter certificateName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.delete(this.client.getEndpoint(), resourceGroupName, name, certificateName,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Delete a certificate from the site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param certificateName Name of the certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String name, String certificateName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (certificateName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter certificateName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), resourceGroupName, name, certificateName,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Delete a certificate from the site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param certificateName Name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String name, String certificateName) {
        return deleteWithResponseAsync(resourceGroupName, name, certificateName).flatMap(ignored -> Mono.empty());
    }

    /**
     * Delete a certificate from the site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param certificateName Name of the certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String name, String certificateName,
        Context context) {
        return deleteWithResponseAsync(resourceGroupName, name, certificateName, context).block();
    }

    /**
     * Delete a certificate from the site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param certificateName Name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String name, String certificateName) {
        deleteWithResponse(resourceGroupName, name, certificateName, Context.NONE);
    }

    /**
     * Create or update a certificate under a given site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param certificateName Name of the certificate.
     * @param certificateEnvelope Details of certificate, if it exists already.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sSL certificate for an app along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CertificateInner>> updateWithResponseAsync(String resourceGroupName, String name,
        String certificateName, CertificatePatchResource certificateEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (certificateName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter certificateName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (certificateEnvelope == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter certificateEnvelope is required and cannot be null."));
        } else {
            certificateEnvelope.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.update(this.client.getEndpoint(), resourceGroupName, name, certificateName,
                this.client.getSubscriptionId(), this.client.getApiVersion(), certificateEnvelope, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create or update a certificate under a given site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param certificateName Name of the certificate.
     * @param certificateEnvelope Details of certificate, if it exists already.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sSL certificate for an app along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<CertificateInner>> updateWithResponseAsync(String resourceGroupName, String name,
        String certificateName, CertificatePatchResource certificateEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (certificateName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter certificateName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (certificateEnvelope == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter certificateEnvelope is required and cannot be null."));
        } else {
            certificateEnvelope.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.update(this.client.getEndpoint(), resourceGroupName, name, certificateName,
            this.client.getSubscriptionId(), this.client.getApiVersion(), certificateEnvelope, accept, context);
    }

    /**
     * Create or update a certificate under a given site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param certificateName Name of the certificate.
     * @param certificateEnvelope Details of certificate, if it exists already.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sSL certificate for an app on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CertificateInner> updateAsync(String resourceGroupName, String name, String certificateName,
        CertificatePatchResource certificateEnvelope) {
        return updateWithResponseAsync(resourceGroupName, name, certificateName, certificateEnvelope)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Create or update a certificate under a given site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param certificateName Name of the certificate.
     * @param certificateEnvelope Details of certificate, if it exists already.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sSL certificate for an app along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CertificateInner> updateWithResponse(String resourceGroupName, String name, String certificateName,
        CertificatePatchResource certificateEnvelope, Context context) {
        return updateWithResponseAsync(resourceGroupName, name, certificateName, certificateEnvelope, context).block();
    }

    /**
     * Create or update a certificate under a given site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param certificateName Name of the certificate.
     * @param certificateEnvelope Details of certificate, if it exists already.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sSL certificate for an app.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CertificateInner update(String resourceGroupName, String name, String certificateName,
        CertificatePatchResource certificateEnvelope) {
        return updateWithResponse(resourceGroupName, name, certificateName, certificateEnvelope, Context.NONE)
            .getValue();
    }

    /**
     * Get all certificates in a resource group for a given site and a deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all certificates in a resource group for a given site and a deployment slot along with
     * {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<CertificateInner>> listSlotSinglePageAsync(String resourceGroupName, String name,
        String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error(new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listSlot(this.client.getEndpoint(), resourceGroupName, name, slot,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .<PagedResponse<CertificateInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get all certificates in a resource group for a given site and a deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all certificates in a resource group for a given site and a deployment slot along with
     * {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<CertificateInner>> listSlotSinglePageAsync(String resourceGroupName, String name,
        String slot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error(new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(),
                this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get all certificates in a resource group for a given site and a deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all certificates in a resource group for a given site and a deployment slot as paginated response with
     * {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<CertificateInner> listSlotAsync(String resourceGroupName, String name, String slot) {
        return new PagedFlux<>(() -> listSlotSinglePageAsync(resourceGroupName, name, slot),
            nextLink -> listSlotNextSinglePageAsync(nextLink));
    }

    /**
     * Get all certificates in a resource group for a given site and a deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all certificates in a resource group for a given site and a deployment slot as paginated response with
     * {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<CertificateInner> listSlotAsync(String resourceGroupName, String name, String slot,
        Context context) {
        return new PagedFlux<>(() -> listSlotSinglePageAsync(resourceGroupName, name, slot, context),
            nextLink -> listSlotNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get all certificates in a resource group for a given site and a deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all certificates in a resource group for a given site and a deployment slot as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<CertificateInner> listSlot(String resourceGroupName, String name, String slot) {
        return new PagedIterable<>(listSlotAsync(resourceGroupName, name, slot));
    }

    /**
     * Get all certificates in a resource group for a given site and a deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all certificates in a resource group for a given site and a deployment slot as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<CertificateInner> listSlot(String resourceGroupName, String name, String slot,
        Context context) {
        return new PagedIterable<>(listSlotAsync(resourceGroupName, name, slot, context));
    }

    /**
     * Get a certificate for a given site and deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param certificateName Name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate for a given site and deployment slot along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CertificateInner>> getSlotWithResponseAsync(String resourceGroupName, String name, String slot,
        String certificateName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error(new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (certificateName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter certificateName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getSlot(this.client.getEndpoint(), resourceGroupName, name, slot,
                certificateName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get a certificate for a given site and deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param certificateName Name of the certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate for a given site and deployment slot along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<CertificateInner>> getSlotWithResponseAsync(String resourceGroupName, String name,
        String slot, String certificateName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error(new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (certificateName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter certificateName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getSlot(this.client.getEndpoint(), resourceGroupName, name, slot, certificateName,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Get a certificate for a given site and deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param certificateName Name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate for a given site and deployment slot on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CertificateInner> getSlotAsync(String resourceGroupName, String name, String slot,
        String certificateName) {
        return getSlotWithResponseAsync(resourceGroupName, name, slot, certificateName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get a certificate for a given site and deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param certificateName Name of the certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate for a given site and deployment slot along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CertificateInner> getSlotWithResponse(String resourceGroupName, String name, String slot,
        String certificateName, Context context) {
        return getSlotWithResponseAsync(resourceGroupName, name, slot, certificateName, context).block();
    }

    /**
     * Get a certificate for a given site and deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param certificateName Name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate for a given site and deployment slot.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CertificateInner getSlot(String resourceGroupName, String name, String slot, String certificateName) {
        return getSlotWithResponse(resourceGroupName, name, slot, certificateName, Context.NONE).getValue();
    }

    /**
     * Create or update a certificate in a given site and deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param certificateName Name of the certificate.
     * @param certificateEnvelope Details of certificate, if it exists already.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sSL certificate for an app along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CertificateInner>> createOrUpdateSlotWithResponseAsync(String resourceGroupName, String name,
        String slot, String certificateName, CertificateInner certificateEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error(new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (certificateName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter certificateName is required and cannot be null."));
        }
        if (certificateEnvelope == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter certificateEnvelope is required and cannot be null."));
        } else {
            certificateEnvelope.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdateSlot(this.client.getEndpoint(), resourceGroupName,
                this.client.getSubscriptionId(), name, slot, certificateName, this.client.getApiVersion(),
                certificateEnvelope, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create or update a certificate in a given site and deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param certificateName Name of the certificate.
     * @param certificateEnvelope Details of certificate, if it exists already.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sSL certificate for an app along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<CertificateInner>> createOrUpdateSlotWithResponseAsync(String resourceGroupName, String name,
        String slot, String certificateName, CertificateInner certificateEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error(new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (certificateName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter certificateName is required and cannot be null."));
        }
        if (certificateEnvelope == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter certificateEnvelope is required and cannot be null."));
        } else {
            certificateEnvelope.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdateSlot(this.client.getEndpoint(), resourceGroupName, this.client.getSubscriptionId(),
            name, slot, certificateName, this.client.getApiVersion(), certificateEnvelope, accept, context);
    }

    /**
     * Create or update a certificate in a given site and deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param certificateName Name of the certificate.
     * @param certificateEnvelope Details of certificate, if it exists already.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sSL certificate for an app on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CertificateInner> createOrUpdateSlotAsync(String resourceGroupName, String name, String slot,
        String certificateName, CertificateInner certificateEnvelope) {
        return createOrUpdateSlotWithResponseAsync(resourceGroupName, name, slot, certificateName, certificateEnvelope)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Create or update a certificate in a given site and deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param certificateName Name of the certificate.
     * @param certificateEnvelope Details of certificate, if it exists already.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sSL certificate for an app along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CertificateInner> createOrUpdateSlotWithResponse(String resourceGroupName, String name, String slot,
        String certificateName, CertificateInner certificateEnvelope, Context context) {
        return createOrUpdateSlotWithResponseAsync(resourceGroupName, name, slot, certificateName, certificateEnvelope,
            context).block();
    }

    /**
     * Create or update a certificate in a given site and deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param certificateName Name of the certificate.
     * @param certificateEnvelope Details of certificate, if it exists already.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sSL certificate for an app.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CertificateInner createOrUpdateSlot(String resourceGroupName, String name, String slot,
        String certificateName, CertificateInner certificateEnvelope) {
        return createOrUpdateSlotWithResponse(resourceGroupName, name, slot, certificateName, certificateEnvelope,
            Context.NONE).getValue();
    }

    /**
     * Delete a certificate for a given site and deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param certificateName Name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteSlotWithResponseAsync(String resourceGroupName, String name, String slot,
        String certificateName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error(new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (certificateName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter certificateName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.deleteSlot(this.client.getEndpoint(), resourceGroupName, name, slot,
                certificateName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Delete a certificate for a given site and deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param certificateName Name of the certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteSlotWithResponseAsync(String resourceGroupName, String name, String slot,
        String certificateName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error(new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (certificateName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter certificateName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deleteSlot(this.client.getEndpoint(), resourceGroupName, name, slot, certificateName,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Delete a certificate for a given site and deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param certificateName Name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteSlotAsync(String resourceGroupName, String name, String slot, String certificateName) {
        return deleteSlotWithResponseAsync(resourceGroupName, name, slot, certificateName)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Delete a certificate for a given site and deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param certificateName Name of the certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteSlotWithResponse(String resourceGroupName, String name, String slot,
        String certificateName, Context context) {
        return deleteSlotWithResponseAsync(resourceGroupName, name, slot, certificateName, context).block();
    }

    /**
     * Delete a certificate for a given site and deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param certificateName Name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteSlot(String resourceGroupName, String name, String slot, String certificateName) {
        deleteSlotWithResponse(resourceGroupName, name, slot, certificateName, Context.NONE);
    }

    /**
     * Create or update a certificate for a site and deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param certificateName Name of the certificate.
     * @param certificateEnvelope Details of certificate, if it exists already.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sSL certificate for an app along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CertificateInner>> updateSlotWithResponseAsync(String resourceGroupName, String name,
        String slot, String certificateName, CertificatePatchResource certificateEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error(new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (certificateName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter certificateName is required and cannot be null."));
        }
        if (certificateEnvelope == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter certificateEnvelope is required and cannot be null."));
        } else {
            certificateEnvelope.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.updateSlot(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, name, slot, certificateName, this.client.getApiVersion(), certificateEnvelope,
                accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create or update a certificate for a site and deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param certificateName Name of the certificate.
     * @param certificateEnvelope Details of certificate, if it exists already.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sSL certificate for an app along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<CertificateInner>> updateSlotWithResponseAsync(String resourceGroupName, String name,
        String slot, String certificateName, CertificatePatchResource certificateEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error(new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (certificateName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter certificateName is required and cannot be null."));
        }
        if (certificateEnvelope == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter certificateEnvelope is required and cannot be null."));
        } else {
            certificateEnvelope.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.updateSlot(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, name,
            slot, certificateName, this.client.getApiVersion(), certificateEnvelope, accept, context);
    }

    /**
     * Create or update a certificate for a site and deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param certificateName Name of the certificate.
     * @param certificateEnvelope Details of certificate, if it exists already.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sSL certificate for an app on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CertificateInner> updateSlotAsync(String resourceGroupName, String name, String slot,
        String certificateName, CertificatePatchResource certificateEnvelope) {
        return updateSlotWithResponseAsync(resourceGroupName, name, slot, certificateName, certificateEnvelope)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Create or update a certificate for a site and deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param certificateName Name of the certificate.
     * @param certificateEnvelope Details of certificate, if it exists already.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sSL certificate for an app along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CertificateInner> updateSlotWithResponse(String resourceGroupName, String name, String slot,
        String certificateName, CertificatePatchResource certificateEnvelope, Context context) {
        return updateSlotWithResponseAsync(resourceGroupName, name, slot, certificateName, certificateEnvelope, context)
            .block();
    }

    /**
     * Create or update a certificate for a site and deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param certificateName Name of the certificate.
     * @param certificateEnvelope Details of certificate, if it exists already.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sSL certificate for an app.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CertificateInner updateSlot(String resourceGroupName, String name, String slot, String certificateName,
        CertificatePatchResource certificateEnvelope) {
        return updateSlotWithResponse(resourceGroupName, name, slot, certificateName, certificateEnvelope, Context.NONE)
            .getValue();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of certificates along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<CertificateInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<CertificateInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of certificates along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<CertificateInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of certificates along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<CertificateInner>> listSlotNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listSlotNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<CertificateInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of certificates along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<CertificateInner>> listSlotNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listSlotNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
