// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * SourceControl resource specific properties.
 */
@Fluent
public final class SourceControlProperties implements JsonSerializable<SourceControlProperties> {
    /*
     * OAuth access token.
     */
    private String token;

    /*
     * OAuth access token secret.
     */
    private String tokenSecret;

    /*
     * OAuth refresh token.
     */
    private String refreshToken;

    /*
     * OAuth token expiration.
     */
    private OffsetDateTime expirationTime;

    /**
     * Creates an instance of SourceControlProperties class.
     */
    public SourceControlProperties() {
    }

    /**
     * Get the token property: OAuth access token.
     * 
     * @return the token value.
     */
    public String token() {
        return this.token;
    }

    /**
     * Set the token property: OAuth access token.
     * 
     * @param token the token value to set.
     * @return the SourceControlProperties object itself.
     */
    public SourceControlProperties withToken(String token) {
        this.token = token;
        return this;
    }

    /**
     * Get the tokenSecret property: OAuth access token secret.
     * 
     * @return the tokenSecret value.
     */
    public String tokenSecret() {
        return this.tokenSecret;
    }

    /**
     * Set the tokenSecret property: OAuth access token secret.
     * 
     * @param tokenSecret the tokenSecret value to set.
     * @return the SourceControlProperties object itself.
     */
    public SourceControlProperties withTokenSecret(String tokenSecret) {
        this.tokenSecret = tokenSecret;
        return this;
    }

    /**
     * Get the refreshToken property: OAuth refresh token.
     * 
     * @return the refreshToken value.
     */
    public String refreshToken() {
        return this.refreshToken;
    }

    /**
     * Set the refreshToken property: OAuth refresh token.
     * 
     * @param refreshToken the refreshToken value to set.
     * @return the SourceControlProperties object itself.
     */
    public SourceControlProperties withRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    /**
     * Get the expirationTime property: OAuth token expiration.
     * 
     * @return the expirationTime value.
     */
    public OffsetDateTime expirationTime() {
        return this.expirationTime;
    }

    /**
     * Set the expirationTime property: OAuth token expiration.
     * 
     * @param expirationTime the expirationTime value to set.
     * @return the SourceControlProperties object itself.
     */
    public SourceControlProperties withExpirationTime(OffsetDateTime expirationTime) {
        this.expirationTime = expirationTime;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("token", this.token);
        jsonWriter.writeStringField("tokenSecret", this.tokenSecret);
        jsonWriter.writeStringField("refreshToken", this.refreshToken);
        jsonWriter.writeStringField("expirationTime",
            this.expirationTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationTime));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SourceControlProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SourceControlProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SourceControlProperties.
     */
    public static SourceControlProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SourceControlProperties deserializedSourceControlProperties = new SourceControlProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("token".equals(fieldName)) {
                    deserializedSourceControlProperties.token = reader.getString();
                } else if ("tokenSecret".equals(fieldName)) {
                    deserializedSourceControlProperties.tokenSecret = reader.getString();
                } else if ("refreshToken".equals(fieldName)) {
                    deserializedSourceControlProperties.refreshToken = reader.getString();
                } else if ("expirationTime".equals(fieldName)) {
                    deserializedSourceControlProperties.expirationTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSourceControlProperties;
        });
    }
}
