// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Site seal.
 */
@Fluent
public final class SiteSealInner implements JsonSerializable<SiteSealInner> {
    /*
     * HTML snippet
     */
    private String html;

    /**
     * Creates an instance of SiteSealInner class.
     */
    public SiteSealInner() {
    }

    /**
     * Get the html property: HTML snippet.
     * 
     * @return the html value.
     */
    public String html() {
        return this.html;
    }

    /**
     * Set the html property: HTML snippet.
     * 
     * @param html the html value to set.
     * @return the SiteSealInner object itself.
     */
    public SiteSealInner withHtml(String html) {
        this.html = html;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (html() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property html in model SiteSealInner"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SiteSealInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("html", this.html);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SiteSealInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SiteSealInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SiteSealInner.
     */
    public static SiteSealInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SiteSealInner deserializedSiteSealInner = new SiteSealInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("html".equals(fieldName)) {
                    deserializedSiteSealInner.html = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSiteSealInner;
        });
    }
}
