// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.AuthType;
import com.azure.resourcemanager.appservice.models.EnvironmentVariable;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.VolumeMount;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * Container of a site.
 */
@Fluent
public final class SiteContainerInner extends ProxyOnlyResource {
    /*
     * SiteContainer resource specific properties
     */
    private SiteContainerProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of SiteContainerInner class.
     */
    public SiteContainerInner() {
    }

    /**
     * Get the innerProperties property: SiteContainer resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private SiteContainerProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SiteContainerInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the image property: Image Name.
     * 
     * @return the image value.
     */
    public String image() {
        return this.innerProperties() == null ? null : this.innerProperties().image();
    }

    /**
     * Set the image property: Image Name.
     * 
     * @param image the image value to set.
     * @return the SiteContainerInner object itself.
     */
    public SiteContainerInner withImage(String image) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteContainerProperties();
        }
        this.innerProperties().withImage(image);
        return this;
    }

    /**
     * Get the targetPort property: Target Port.
     * 
     * @return the targetPort value.
     */
    public String targetPort() {
        return this.innerProperties() == null ? null : this.innerProperties().targetPort();
    }

    /**
     * Set the targetPort property: Target Port.
     * 
     * @param targetPort the targetPort value to set.
     * @return the SiteContainerInner object itself.
     */
    public SiteContainerInner withTargetPort(String targetPort) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteContainerProperties();
        }
        this.innerProperties().withTargetPort(targetPort);
        return this;
    }

    /**
     * Get the isMain property: &lt;code&gt;true&lt;/code&gt; if the container is the main site container;
     * &lt;code&gt;false&lt;/code&gt; otherwise.
     * 
     * @return the isMain value.
     */
    public Boolean isMain() {
        return this.innerProperties() == null ? null : this.innerProperties().isMain();
    }

    /**
     * Set the isMain property: &lt;code&gt;true&lt;/code&gt; if the container is the main site container;
     * &lt;code&gt;false&lt;/code&gt; otherwise.
     * 
     * @param isMain the isMain value to set.
     * @return the SiteContainerInner object itself.
     */
    public SiteContainerInner withIsMain(Boolean isMain) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteContainerProperties();
        }
        this.innerProperties().withIsMain(isMain);
        return this;
    }

    /**
     * Get the startUpCommand property: StartUp Command.
     * 
     * @return the startUpCommand value.
     */
    public String startUpCommand() {
        return this.innerProperties() == null ? null : this.innerProperties().startUpCommand();
    }

    /**
     * Set the startUpCommand property: StartUp Command.
     * 
     * @param startUpCommand the startUpCommand value to set.
     * @return the SiteContainerInner object itself.
     */
    public SiteContainerInner withStartUpCommand(String startUpCommand) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteContainerProperties();
        }
        this.innerProperties().withStartUpCommand(startUpCommand);
        return this;
    }

    /**
     * Get the authType property: Auth Type.
     * 
     * @return the authType value.
     */
    public AuthType authType() {
        return this.innerProperties() == null ? null : this.innerProperties().authType();
    }

    /**
     * Set the authType property: Auth Type.
     * 
     * @param authType the authType value to set.
     * @return the SiteContainerInner object itself.
     */
    public SiteContainerInner withAuthType(AuthType authType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteContainerProperties();
        }
        this.innerProperties().withAuthType(authType);
        return this;
    }

    /**
     * Get the username property: User Name.
     * 
     * @return the username value.
     */
    public String username() {
        return this.innerProperties() == null ? null : this.innerProperties().username();
    }

    /**
     * Set the username property: User Name.
     * 
     * @param username the username value to set.
     * @return the SiteContainerInner object itself.
     */
    public SiteContainerInner withUsername(String username) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteContainerProperties();
        }
        this.innerProperties().withUsername(username);
        return this;
    }

    /**
     * Get the passwordSecret property: Password Secret.
     * 
     * @return the passwordSecret value.
     */
    public String passwordSecret() {
        return this.innerProperties() == null ? null : this.innerProperties().passwordSecret();
    }

    /**
     * Set the passwordSecret property: Password Secret.
     * 
     * @param passwordSecret the passwordSecret value to set.
     * @return the SiteContainerInner object itself.
     */
    public SiteContainerInner withPasswordSecret(String passwordSecret) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteContainerProperties();
        }
        this.innerProperties().withPasswordSecret(passwordSecret);
        return this;
    }

    /**
     * Get the userManagedIdentityClientId property: UserManagedIdentity ClientId.
     * 
     * @return the userManagedIdentityClientId value.
     */
    public String userManagedIdentityClientId() {
        return this.innerProperties() == null ? null : this.innerProperties().userManagedIdentityClientId();
    }

    /**
     * Set the userManagedIdentityClientId property: UserManagedIdentity ClientId.
     * 
     * @param userManagedIdentityClientId the userManagedIdentityClientId value to set.
     * @return the SiteContainerInner object itself.
     */
    public SiteContainerInner withUserManagedIdentityClientId(String userManagedIdentityClientId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteContainerProperties();
        }
        this.innerProperties().withUserManagedIdentityClientId(userManagedIdentityClientId);
        return this;
    }

    /**
     * Get the createdTime property: Created Time.
     * 
     * @return the createdTime value.
     */
    public OffsetDateTime createdTime() {
        return this.innerProperties() == null ? null : this.innerProperties().createdTime();
    }

    /**
     * Get the lastModifiedTime property: Last Modified Time.
     * 
     * @return the lastModifiedTime value.
     */
    public OffsetDateTime lastModifiedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedTime();
    }

    /**
     * Get the volumeMounts property: List of volume mounts.
     * 
     * @return the volumeMounts value.
     */
    public List<VolumeMount> volumeMounts() {
        return this.innerProperties() == null ? null : this.innerProperties().volumeMounts();
    }

    /**
     * Set the volumeMounts property: List of volume mounts.
     * 
     * @param volumeMounts the volumeMounts value to set.
     * @return the SiteContainerInner object itself.
     */
    public SiteContainerInner withVolumeMounts(List<VolumeMount> volumeMounts) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteContainerProperties();
        }
        this.innerProperties().withVolumeMounts(volumeMounts);
        return this;
    }

    /**
     * Get the inheritAppSettingsAndConnectionStrings property: &lt;code&gt;true&lt;/code&gt; if all AppSettings and
     * ConnectionStrings have to be passed to the container as environment variables; &lt;code&gt;false&lt;/code&gt;
     * otherwise.
     * 
     * @return the inheritAppSettingsAndConnectionStrings value.
     */
    public Boolean inheritAppSettingsAndConnectionStrings() {
        return this.innerProperties() == null ? null : this.innerProperties().inheritAppSettingsAndConnectionStrings();
    }

    /**
     * Set the inheritAppSettingsAndConnectionStrings property: &lt;code&gt;true&lt;/code&gt; if all AppSettings and
     * ConnectionStrings have to be passed to the container as environment variables; &lt;code&gt;false&lt;/code&gt;
     * otherwise.
     * 
     * @param inheritAppSettingsAndConnectionStrings the inheritAppSettingsAndConnectionStrings value to set.
     * @return the SiteContainerInner object itself.
     */
    public SiteContainerInner
        withInheritAppSettingsAndConnectionStrings(Boolean inheritAppSettingsAndConnectionStrings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteContainerProperties();
        }
        this.innerProperties().withInheritAppSettingsAndConnectionStrings(inheritAppSettingsAndConnectionStrings);
        return this;
    }

    /**
     * Get the environmentVariables property: List of environment variables.
     * 
     * @return the environmentVariables value.
     */
    public List<EnvironmentVariable> environmentVariables() {
        return this.innerProperties() == null ? null : this.innerProperties().environmentVariables();
    }

    /**
     * Set the environmentVariables property: List of environment variables.
     * 
     * @param environmentVariables the environmentVariables value to set.
     * @return the SiteContainerInner object itself.
     */
    public SiteContainerInner withEnvironmentVariables(List<EnvironmentVariable> environmentVariables) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteContainerProperties();
        }
        this.innerProperties().withEnvironmentVariables(environmentVariables);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SiteContainerInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SiteContainerInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SiteContainerInner.
     */
    public static SiteContainerInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SiteContainerInner deserializedSiteContainerInner = new SiteContainerInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedSiteContainerInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedSiteContainerInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedSiteContainerInner.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedSiteContainerInner.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedSiteContainerInner.innerProperties = SiteContainerProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSiteContainerInner;
        });
    }
}
