// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.BackupRestoreOperationType;
import com.azure.resourcemanager.appservice.models.DatabaseBackupSetting;
import java.io.IOException;
import java.util.List;

/**
 * RestoreRequest resource specific properties.
 */
@Fluent
public final class RestoreRequestProperties implements JsonSerializable<RestoreRequestProperties> {
    /*
     * SAS URL to the container.
     */
    private String storageAccountUrl;

    /*
     * Name of a blob which contains the backup.
     */
    private String blobName;

    /*
     * <code>true</code> if the restore operation can overwrite target app; otherwise, <code>false</code>.
     * <code>true</code> is needed if trying to restore over an existing app.
     */
    private boolean overwrite;

    /*
     * Name of an app.
     */
    private String siteName;

    /*
     * Collection of databases which should be restored. This list has to match the list of databases included in the
     * backup.
     */
    private List<DatabaseBackupSetting> databases;

    /*
     * Changes a logic when restoring an app with custom domains. <code>true</code> to remove custom domains
     * automatically. If <code>false</code>, custom domains are added to
     * the app's object when it is being restored, but that might fail due to conflicts during the operation.
     */
    private Boolean ignoreConflictingHostNames;

    /*
     * Ignore the databases and only restore the site content
     */
    private Boolean ignoreDatabases;

    /*
     * Specify app service plan that will own restored site.
     */
    private String appServicePlan;

    /*
     * Operation type.
     */
    private BackupRestoreOperationType operationType;

    /*
     * <code>true</code> if SiteConfig.ConnectionStrings should be set in new app; otherwise, <code>false</code>.
     */
    private Boolean adjustConnectionStrings;

    /*
     * App Service Environment name, if needed (only when restoring an app to an App Service Environment).
     */
    private String hostingEnvironment;

    /**
     * Creates an instance of RestoreRequestProperties class.
     */
    public RestoreRequestProperties() {
    }

    /**
     * Get the storageAccountUrl property: SAS URL to the container.
     * 
     * @return the storageAccountUrl value.
     */
    public String storageAccountUrl() {
        return this.storageAccountUrl;
    }

    /**
     * Set the storageAccountUrl property: SAS URL to the container.
     * 
     * @param storageAccountUrl the storageAccountUrl value to set.
     * @return the RestoreRequestProperties object itself.
     */
    public RestoreRequestProperties withStorageAccountUrl(String storageAccountUrl) {
        this.storageAccountUrl = storageAccountUrl;
        return this;
    }

    /**
     * Get the blobName property: Name of a blob which contains the backup.
     * 
     * @return the blobName value.
     */
    public String blobName() {
        return this.blobName;
    }

    /**
     * Set the blobName property: Name of a blob which contains the backup.
     * 
     * @param blobName the blobName value to set.
     * @return the RestoreRequestProperties object itself.
     */
    public RestoreRequestProperties withBlobName(String blobName) {
        this.blobName = blobName;
        return this;
    }

    /**
     * Get the overwrite property: &lt;code&gt;true&lt;/code&gt; if the restore operation can overwrite target app;
     * otherwise, &lt;code&gt;false&lt;/code&gt;. &lt;code&gt;true&lt;/code&gt; is needed if trying to restore over an
     * existing app.
     * 
     * @return the overwrite value.
     */
    public boolean overwrite() {
        return this.overwrite;
    }

    /**
     * Set the overwrite property: &lt;code&gt;true&lt;/code&gt; if the restore operation can overwrite target app;
     * otherwise, &lt;code&gt;false&lt;/code&gt;. &lt;code&gt;true&lt;/code&gt; is needed if trying to restore over an
     * existing app.
     * 
     * @param overwrite the overwrite value to set.
     * @return the RestoreRequestProperties object itself.
     */
    public RestoreRequestProperties withOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
        return this;
    }

    /**
     * Get the siteName property: Name of an app.
     * 
     * @return the siteName value.
     */
    public String siteName() {
        return this.siteName;
    }

    /**
     * Set the siteName property: Name of an app.
     * 
     * @param siteName the siteName value to set.
     * @return the RestoreRequestProperties object itself.
     */
    public RestoreRequestProperties withSiteName(String siteName) {
        this.siteName = siteName;
        return this;
    }

    /**
     * Get the databases property: Collection of databases which should be restored. This list has to match the list of
     * databases included in the backup.
     * 
     * @return the databases value.
     */
    public List<DatabaseBackupSetting> databases() {
        return this.databases;
    }

    /**
     * Set the databases property: Collection of databases which should be restored. This list has to match the list of
     * databases included in the backup.
     * 
     * @param databases the databases value to set.
     * @return the RestoreRequestProperties object itself.
     */
    public RestoreRequestProperties withDatabases(List<DatabaseBackupSetting> databases) {
        this.databases = databases;
        return this;
    }

    /**
     * Get the ignoreConflictingHostNames property: Changes a logic when restoring an app with custom domains.
     * &lt;code&gt;true&lt;/code&gt; to remove custom domains automatically. If &lt;code&gt;false&lt;/code&gt;, custom
     * domains are added to
     * the app's object when it is being restored, but that might fail due to conflicts during the operation.
     * 
     * @return the ignoreConflictingHostNames value.
     */
    public Boolean ignoreConflictingHostNames() {
        return this.ignoreConflictingHostNames;
    }

    /**
     * Set the ignoreConflictingHostNames property: Changes a logic when restoring an app with custom domains.
     * &lt;code&gt;true&lt;/code&gt; to remove custom domains automatically. If &lt;code&gt;false&lt;/code&gt;, custom
     * domains are added to
     * the app's object when it is being restored, but that might fail due to conflicts during the operation.
     * 
     * @param ignoreConflictingHostNames the ignoreConflictingHostNames value to set.
     * @return the RestoreRequestProperties object itself.
     */
    public RestoreRequestProperties withIgnoreConflictingHostNames(Boolean ignoreConflictingHostNames) {
        this.ignoreConflictingHostNames = ignoreConflictingHostNames;
        return this;
    }

    /**
     * Get the ignoreDatabases property: Ignore the databases and only restore the site content.
     * 
     * @return the ignoreDatabases value.
     */
    public Boolean ignoreDatabases() {
        return this.ignoreDatabases;
    }

    /**
     * Set the ignoreDatabases property: Ignore the databases and only restore the site content.
     * 
     * @param ignoreDatabases the ignoreDatabases value to set.
     * @return the RestoreRequestProperties object itself.
     */
    public RestoreRequestProperties withIgnoreDatabases(Boolean ignoreDatabases) {
        this.ignoreDatabases = ignoreDatabases;
        return this;
    }

    /**
     * Get the appServicePlan property: Specify app service plan that will own restored site.
     * 
     * @return the appServicePlan value.
     */
    public String appServicePlan() {
        return this.appServicePlan;
    }

    /**
     * Set the appServicePlan property: Specify app service plan that will own restored site.
     * 
     * @param appServicePlan the appServicePlan value to set.
     * @return the RestoreRequestProperties object itself.
     */
    public RestoreRequestProperties withAppServicePlan(String appServicePlan) {
        this.appServicePlan = appServicePlan;
        return this;
    }

    /**
     * Get the operationType property: Operation type.
     * 
     * @return the operationType value.
     */
    public BackupRestoreOperationType operationType() {
        return this.operationType;
    }

    /**
     * Set the operationType property: Operation type.
     * 
     * @param operationType the operationType value to set.
     * @return the RestoreRequestProperties object itself.
     */
    public RestoreRequestProperties withOperationType(BackupRestoreOperationType operationType) {
        this.operationType = operationType;
        return this;
    }

    /**
     * Get the adjustConnectionStrings property: &lt;code&gt;true&lt;/code&gt; if SiteConfig.ConnectionStrings should be
     * set in new app; otherwise, &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the adjustConnectionStrings value.
     */
    public Boolean adjustConnectionStrings() {
        return this.adjustConnectionStrings;
    }

    /**
     * Set the adjustConnectionStrings property: &lt;code&gt;true&lt;/code&gt; if SiteConfig.ConnectionStrings should be
     * set in new app; otherwise, &lt;code&gt;false&lt;/code&gt;.
     * 
     * @param adjustConnectionStrings the adjustConnectionStrings value to set.
     * @return the RestoreRequestProperties object itself.
     */
    public RestoreRequestProperties withAdjustConnectionStrings(Boolean adjustConnectionStrings) {
        this.adjustConnectionStrings = adjustConnectionStrings;
        return this;
    }

    /**
     * Get the hostingEnvironment property: App Service Environment name, if needed (only when restoring an app to an
     * App Service Environment).
     * 
     * @return the hostingEnvironment value.
     */
    public String hostingEnvironment() {
        return this.hostingEnvironment;
    }

    /**
     * Set the hostingEnvironment property: App Service Environment name, if needed (only when restoring an app to an
     * App Service Environment).
     * 
     * @param hostingEnvironment the hostingEnvironment value to set.
     * @return the RestoreRequestProperties object itself.
     */
    public RestoreRequestProperties withHostingEnvironment(String hostingEnvironment) {
        this.hostingEnvironment = hostingEnvironment;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (storageAccountUrl() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property storageAccountUrl in model RestoreRequestProperties"));
        }
        if (databases() != null) {
            databases().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RestoreRequestProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storageAccountUrl", this.storageAccountUrl);
        jsonWriter.writeBooleanField("overwrite", this.overwrite);
        jsonWriter.writeStringField("blobName", this.blobName);
        jsonWriter.writeStringField("siteName", this.siteName);
        jsonWriter.writeArrayField("databases", this.databases, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeBooleanField("ignoreConflictingHostNames", this.ignoreConflictingHostNames);
        jsonWriter.writeBooleanField("ignoreDatabases", this.ignoreDatabases);
        jsonWriter.writeStringField("appServicePlan", this.appServicePlan);
        jsonWriter.writeStringField("operationType", this.operationType == null ? null : this.operationType.toString());
        jsonWriter.writeBooleanField("adjustConnectionStrings", this.adjustConnectionStrings);
        jsonWriter.writeStringField("hostingEnvironment", this.hostingEnvironment);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RestoreRequestProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RestoreRequestProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RestoreRequestProperties.
     */
    public static RestoreRequestProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RestoreRequestProperties deserializedRestoreRequestProperties = new RestoreRequestProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("storageAccountUrl".equals(fieldName)) {
                    deserializedRestoreRequestProperties.storageAccountUrl = reader.getString();
                } else if ("overwrite".equals(fieldName)) {
                    deserializedRestoreRequestProperties.overwrite = reader.getBoolean();
                } else if ("blobName".equals(fieldName)) {
                    deserializedRestoreRequestProperties.blobName = reader.getString();
                } else if ("siteName".equals(fieldName)) {
                    deserializedRestoreRequestProperties.siteName = reader.getString();
                } else if ("databases".equals(fieldName)) {
                    List<DatabaseBackupSetting> databases
                        = reader.readArray(reader1 -> DatabaseBackupSetting.fromJson(reader1));
                    deserializedRestoreRequestProperties.databases = databases;
                } else if ("ignoreConflictingHostNames".equals(fieldName)) {
                    deserializedRestoreRequestProperties.ignoreConflictingHostNames
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("ignoreDatabases".equals(fieldName)) {
                    deserializedRestoreRequestProperties.ignoreDatabases = reader.getNullable(JsonReader::getBoolean);
                } else if ("appServicePlan".equals(fieldName)) {
                    deserializedRestoreRequestProperties.appServicePlan = reader.getString();
                } else if ("operationType".equals(fieldName)) {
                    deserializedRestoreRequestProperties.operationType
                        = BackupRestoreOperationType.fromString(reader.getString());
                } else if ("adjustConnectionStrings".equals(fieldName)) {
                    deserializedRestoreRequestProperties.adjustConnectionStrings
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("hostingEnvironment".equals(fieldName)) {
                    deserializedRestoreRequestProperties.hostingEnvironment = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRestoreRequestProperties;
        });
    }
}
