// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.PrivateAccessVirtualNetwork;
import java.io.IOException;
import java.util.List;

/**
 * PrivateAccess resource specific properties.
 */
@Fluent
public final class PrivateAccessProperties implements JsonSerializable<PrivateAccessProperties> {
    /*
     * Whether private access is enabled or not.
     */
    private Boolean enabled;

    /*
     * The Virtual Networks (and subnets) allowed to access the site privately.
     */
    private List<PrivateAccessVirtualNetwork> virtualNetworks;

    /**
     * Creates an instance of PrivateAccessProperties class.
     */
    public PrivateAccessProperties() {
    }

    /**
     * Get the enabled property: Whether private access is enabled or not.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Whether private access is enabled or not.
     * 
     * @param enabled the enabled value to set.
     * @return the PrivateAccessProperties object itself.
     */
    public PrivateAccessProperties withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the virtualNetworks property: The Virtual Networks (and subnets) allowed to access the site privately.
     * 
     * @return the virtualNetworks value.
     */
    public List<PrivateAccessVirtualNetwork> virtualNetworks() {
        return this.virtualNetworks;
    }

    /**
     * Set the virtualNetworks property: The Virtual Networks (and subnets) allowed to access the site privately.
     * 
     * @param virtualNetworks the virtualNetworks value to set.
     * @return the PrivateAccessProperties object itself.
     */
    public PrivateAccessProperties withVirtualNetworks(List<PrivateAccessVirtualNetwork> virtualNetworks) {
        this.virtualNetworks = virtualNetworks;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (virtualNetworks() != null) {
            virtualNetworks().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeArrayField("virtualNetworks", this.virtualNetworks,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PrivateAccessProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PrivateAccessProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PrivateAccessProperties.
     */
    public static PrivateAccessProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PrivateAccessProperties deserializedPrivateAccessProperties = new PrivateAccessProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enabled".equals(fieldName)) {
                    deserializedPrivateAccessProperties.enabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("virtualNetworks".equals(fieldName)) {
                    List<PrivateAccessVirtualNetwork> virtualNetworks
                        = reader.readArray(reader1 -> PrivateAccessVirtualNetwork.fromJson(reader1));
                    deserializedPrivateAccessProperties.virtualNetworks = virtualNetworks;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPrivateAccessProperties;
        });
    }
}
