// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Network trace.
 */
@Fluent
public final class NetworkTraceInner implements JsonSerializable<NetworkTraceInner> {
    /*
     * Local file path for the captured network trace file.
     */
    private String path;

    /*
     * Current status of the network trace operation, same as Operation.Status (InProgress/Succeeded/Failed).
     */
    private String status;

    /*
     * Detailed message of a network trace operation, e.g. error message in case of failure.
     */
    private String message;

    /**
     * Creates an instance of NetworkTraceInner class.
     */
    public NetworkTraceInner() {
    }

    /**
     * Get the path property: Local file path for the captured network trace file.
     * 
     * @return the path value.
     */
    public String path() {
        return this.path;
    }

    /**
     * Set the path property: Local file path for the captured network trace file.
     * 
     * @param path the path value to set.
     * @return the NetworkTraceInner object itself.
     */
    public NetworkTraceInner withPath(String path) {
        this.path = path;
        return this;
    }

    /**
     * Get the status property: Current status of the network trace operation, same as Operation.Status
     * (InProgress/Succeeded/Failed).
     * 
     * @return the status value.
     */
    public String status() {
        return this.status;
    }

    /**
     * Set the status property: Current status of the network trace operation, same as Operation.Status
     * (InProgress/Succeeded/Failed).
     * 
     * @param status the status value to set.
     * @return the NetworkTraceInner object itself.
     */
    public NetworkTraceInner withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
     * Get the message property: Detailed message of a network trace operation, e.g. error message in case of failure.
     * 
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Set the message property: Detailed message of a network trace operation, e.g. error message in case of failure.
     * 
     * @param message the message value to set.
     * @return the NetworkTraceInner object itself.
     */
    public NetworkTraceInner withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("path", this.path);
        jsonWriter.writeStringField("status", this.status);
        jsonWriter.writeStringField("message", this.message);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkTraceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkTraceInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the NetworkTraceInner.
     */
    public static NetworkTraceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkTraceInner deserializedNetworkTraceInner = new NetworkTraceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("path".equals(fieldName)) {
                    deserializedNetworkTraceInner.path = reader.getString();
                } else if ("status".equals(fieldName)) {
                    deserializedNetworkTraceInner.status = reader.getString();
                } else if ("message".equals(fieldName)) {
                    deserializedNetworkTraceInner.message = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkTraceInner;
        });
    }
}
